#ifndef __CBUCFG_H__
#define __CBUCFG_H__
/******************************************************************************
 * FILE PURPOSE: Structures shared between DSP and host for CBU
 ******************************************************************************
 * FILE NAME:   cbucfg.h
 * (C) Copyright 2005 Texas Instruments Incorporated. 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#include <ti/mas/iface/ifeco/mgdefs.h>

/* Dummy Define for a Micro Macro */
#ifndef TNI_ATTR_PACK
#define TNI_ATTR_PACK
#endif

/***********************************************************************
 * Name: MGB_MD_CBU_CONFIG    2215                                     *
 * Description: Conference Bridge Unit Configuration                   *
 ***********************************************************************/

struct MGB_MDS_CBU_CONFIG
{
  tuint bridge_id;

  tuint valid_params;
#define MGB_CBU_CONFIG_VALID_FRAME_SIZE     0x0001
#define MGB_CBU_CONFIG_VALID_DOMINANT_N     0x0002
#define MGB_CBU_CONFIG_VALID_MAX_NOISE_SUPP 0x0004
#define MGB_CBU_CONFIG_VALID_VAD_NOISE_FLO  0x0008
#define MGB_CBU_CONFIG_VALID_VAD_HANG_MS    0x0010
#define MGB_CBU_CONFIG_VALID_VAD_WIN_SIZE   0x0020
#define MGB_CBU_CONFIG_VALID_AGC_TARGET_POW 0x0040
#define MGB_CBU_CONFIG_VALID_AGC_MAX_LOSS   0x0080
#define MGB_CBU_CONFIG_VALID_AGC_MAX_GAIN   0x0100
#define MGB_CBU_CONFIG_VALID_RESET          0x0200

  tint max_conf_frameSize;    /* Frame size in samples                      */
  tint num_dominant_channels; /* DominantN                                  */
  tint max_noise_suppression; /* MaxNoiseSuppression                        */
  tint vad_noise_floor_thresh;/* VADNoiseFloorThresh - range: 0..-96 in dBm */
  tint vad_hang_msec;         /* VADHangMSec - Hang time in milliseconds    */
  tint vad_window_size;       /* VADWindowSize - Window size in samples     */
  tint agc_target_powerIn;    /* AGCTargetPowerIn - range: 0 ... -20 in dBm */
  tint agc_maxLoss_limitIn;   /* AGCMaxLossLimitIn - range: 0 ... -23 in dB */
  tint agc_maxGain_limitIn;   /* AGCMaxGainLimitIn - range: 0 ... +23 in dB */
  tint reset_bridge;          /* 1:reset 0:no reset                         */
} TNI_ATTR_PACK;


/***********************************************************************
 * Name: MGB_MD_CONF_INIT_CONFIG    2224                               *
 * Description: Conference Bridge Unit Init configuration.             *
 ***********************************************************************/
struct MGB_MDS_CONF_INIT_CONFIG {
  tuint routerEnabled;                    /* Is router enabled */
  tuint noOfMaxConferenceChannels;        /* Number of conference channels to be configured */
  tuint noOfMaxBridges;                   /* Number of bridges to be configured */
} TNI_ATTR_PACK;


/* Bit fields used by 1:N Redundancy configuration collection routine */
#define MGB_CBU_CONFIG_VPBT1   0x11111111
#define MGB_CBU_CONFIG_VPBT2   0x00000011

#endif  /* __CBUCFG_H__ */

/* nothing past this point */
