/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



#ifndef _DTMF_H
#define _DTMF_H
/******************************************************************************
 * FILE PURPOSE: Interface for DTMF
 ******************************************************************************
 * FILE NAME:   dtmf.h
 *
 * DESCRIPTION: This file is used by both Micro and DSP software.
 *
******************************************************************************/

#include <ti/mas/iface/ifeco/mgdefs.h>

/* Dummy Define for a Micro Macro */
#ifndef TNI_ATTR_PACK
#define TNI_ATTR_PACK 
#endif

/***********************************************************************
 * Name: MGB_MDS_DIGIT_ACTIONS_CONFIG                                  *
 * Description: Type of action to be performed when digits are detected*
 * Notes:                                                              *
 * - Report-to-host action: DSP sends digit indication to the HOST     *
 * - Relay peer-to-peer action: Peer-to-peer message is generated by   *
 *                          the DSP, and shipped "in-band"             *
 * - Squelch voice action: Voice packet stream is stopped during digit *
 *                          event. (voice packet flow to the network)  *
 *   MF Relay configuration setup in siutdu.c needs to be modified.    *
 *   It is necessary to separate DSPs detection configuration from     *
 *   encapsulation of these events.                                    *
 *   In <R9.2 AAL2/RTP we can not generate both VOICE PACKETs and      *
 *   DIGIT EVENT PACKETs (that is: squelch voice is implied, if DIGIT  *
 *   packets are generated).                                           *
 *   DSP IMPACT AREA: SIU, PVP                                         *
 * DIM ACTION PLAN:                                                    *
 *   Pass parameters as received from DIM client.                      *
 ***********************************************************************/
struct MGB_MDS_DIGIT_ACTIONS_CONFIG {
#define MGB_DIGIT_ACTIONS_REPORT_TO_HOST    0x0001
#define MGB_DIGIT_ACTIONS_RELAY_P2P         0x0002
#define MGB_DIGIT_ACTIONS_SQUELCH_VOICE     0x0004
#define MGB_DIGIT_ACTIONS_DTMF_UPSPEED      0x0008
#define MGB_DIGIT_ACTIONS_M_BIT_PKT_OPT     0x0010
#define MGB_DIGIT_ACTIONS_MIN_ON_PLAYOUT    0x0020
#define MGB_DIGIT_ACTIONS_DTMF_PKT2TDM_PWR  0x0040
#define MGB_DIGIT_ACTIONS_OFF               0x0000
  tuint digit_actions;
/*-----------------------------------------------------------------------
 * Bit field: filter_bfield (0 - indicates TNI default operation)
 *-----------------------------------------------------------------------
 *
 * Various types/classes are:
 * Number  - N [DTMF digits 0-9, MF all digits]
 * Letter  - L [DTMF digits A-D]
 * Star    - * [DTMF digit *]
 * Hash    - # [DTMF digit #]
 * Long digits - LO [Events of duration longer than defined] 
 *
 * filter_bfield;
 *
 *   15  14  13  12  11  10   9   8   7   6   5   4   3   2   1   0
 *  +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
 *  |TRGR EVENT |     Reserved      |    ON Report  |   OFF Report  |
 *  +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
 *  |TLO|TOF|TON|                   | # | * | L | N | # | * | L | N |
 *  +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
 *
 * Report Types:
 *  Trigger Select Bits       
 *    TON:  [1: Upon a trigger event, All ON reports enabled]
 *          [0: Trigger disabled]
 *    TOF:  [1: Upon a trigger event, All OFF reports enabled]
 *          [0: Trigger disabled]
 *    TLO:  [1: Upon a trigger event, All LONG reports enabled]
 *          [0: Trigger disabled]
 *
 *  ON Report, OFF Report
 *  If 1 : All event/digit reports suppressed
 *     0 : Event/digit reports enabled and is a trigger event
 *----------------------------------------------------------------------*/
  tuint filter_bfield;
  
/*-------------------------------------------------------------------------------
 * Bit field: long_digit_bfield (0 - indicates TNI default operation)
 *-------------------------------------------------------------------------------
 * Bit  0 - Tone ID  0, long digit  0 is not reported (0) / reported (1)
 * Bit  1 - Tone ID  1, long digit  1 is not reported (0) / reported (1)
 * Bit  2 - Tone ID  2, long digit  2 is not reported (0) / reported (1)
 * ...      ...
 * Bit 14 - Tone ID 14, long digit 14 is not reported (0) / reported (1)
 * Bit 15 - Tone ID 15, long digit 15 is not reported (0) / reported (1)
 *-------------------------------------------------------------------------------*/
  tuint long_digit_bfield;
  tuint long_digit_hangover;  /* Long digit min duration (ms) */
  tuint upspeed_profile_idx;  /* If DTMF Upspeed is enabled, codec from 
                                * specified profile index is switched in during
                                * DTMF event (0-based) */
  tuint digit_Mbit_option;
         /* when MGB_DIGIT_ACTIONS_M_BIT_PKT_OPT is set:                 */
         /*    0: M-bit packet carries TS=T1; D=0                        */
         /*    1: M-bit packet carries TS=T0; D=DIGIT_INIT_DURATION_30ms */
  #define MGB_DIGIT_ACTIONS_M_BIT_PKT_T1_D0    0
  #define MGB_DIGIT_ACTIONS_M_BIT_PKT_T0_D30   1
         /* Note: Refer QRS 4543 for definition of T0 and T1. */
  /* Initial Packets Duration */
  #define MGB_DIGIT_INIT_DURATION_30ms         240  /* 30ms */   
  
  tuint digit_minimum_tone_on_playout;     
         /* when MGB_DIGIT_ACTIONS_MINIMUM_PLAYOUT is set: */
         /*    value of minimum tone on playout time in ms */
  tuint pkt2tdm_low_frequency_power;  /* Q1, dBm */
  tuint pkt2tdm_high_frequency_power; /* Q1, dBm */
} TNI_ATTR_PACK;

#endif /* _DTMF_H */
/* nothing past this point */
