/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



#ifndef _GAINS_H
#define _GAINS_H
/******************************************************************************
 * FILE PURPOSE: Any Message Related with Gain (Digital, Analog Codec etc.)
 ******************************************************************************
 * FILE NAME:   gains.h
 *
 * DESCRIPTION: This file is used by both Micro and DSP software.
 *
******************************************************************************/

#include <ti/mas/iface/ifeco/mgdefs.h>

/* Dummy Define for a Micro Macro */
#ifndef TNI_ATTR_PACK
#define TNI_ATTR_PACK
#endif

/*****************************************************************************
 * Used to set different Gain values
 *****************************************************************************/
struct MGB_MDS_GAIN_CTRL {
  tuint  change_bitmap;
#define MGB_GAIN_CTRL_TX_DIG_GAIN               0x0001
#define MGB_GAIN_CTRL_RX_DIG_GAIN               0x0002
#define MGB_GAIN_CTRL_TX_AN_GAIN                0x0004
#define MGB_GAIN_CTRL_RX_AN_GAIN                0x0008
#define MGB_GAIN_CTRL_RX_SEC_AN_GAIN            0x0010
#define MGB_GAIN_CTRL_LCD_GAIN                  0x0020
#define MGB_GAIN_CTRL_SIDE_TONE_GAIN            0x0040
  tint tx_digital_gain;     /* TX Digital Gain: -20 to +20 dB in 1dB steps */
  tint rx_digital_gain;     /* RX Digital Gain: -20 to +20 dB in 1dB steps */
  tint tx_analog_gain;      /* TX Analog Gain in 0.5dB steps - used only for IP Phone */
  tint rx_analog_gain;      /* RX Analog Gain in 0.5dB steps - used only for IP Phone */
  tint rx_sec_analog_gain;  /* RX Analog Gain in 0.5dB steps - for duplicate channel, used 
                                only for IP phone */
  tint lcd_gain;            /* LCD gain prog. in 3/16V steps - values 0-15 */
  tint side_tone_gain;      /* Sidetone Gain in 0.5dB steps - used only for IP Phone */
} TNI_ATTR_PACK;

/*****************************************************************************
 * Request the current DSP gains
 *****************************************************************************/
struct MGB_MDS_GET_GAINS {
  tuint  request_bitmap;
#define MGB_GG_CTRL_TX_DIG_GAIN               0x0001
#define MGB_GG_CTRL_RX_DIG_GAIN               0x0002
#define MGB_GG_CTRL_TX_AN_GAIN                0x0004
#define MGB_GG_CTRL_RX_AN_GAIN                0x0008
#define MGB_GG_CTRL_RX_SEC_AN_GAIN            0x0010
#define MGB_GG_CTRL_LCD_GAIN                  0x0020
#define MGB_GG_CTRL_SIDE_TONE_GAIN            0x0040
#define MGB_GG_CTRL_AER_TX_DIGITAL            0x0080
#define MGB_GG_CTRL_AER_RX_DIGITAL            0x0100
#define MGB_GG_CTRL_OVERRIDE_AIC_MAP          0x0200
  tuint  override_aic_map;
#define MGB_GG_PRI_IN_MASK                    0x0003
#define MGB_GG_PRI_IN_HAND_SET                   0x0
#define MGB_GG_PRI_IN_HEAD_SET                   0x1
#define MGB_GG_PRI_IN_HNDS_FREE                  0x2
#define MGB_GG_PRI_IN_LINE                       0x3
#define MGB_GG_PRI_IN_RESERVED                0x0004
#define MGB_GG_PRI_IN_CODEC                   0x0008

#define MGB_GG_PRI_OUT_MASK                   0x0030
#define MGB_GG_PRI_OUT_HAND_SET                 0x00
#define MGB_GG_PRI_OUT_HEAD_SET                 0x10
#define MGB_GG_PRI_OUT_HNDS_FREE                0x20
#define MGB_GG_PRI_OUT_LINE                     0x30
#define MGB_GG_PRI_OUT_RESERVED               0x0040
#define MGB_GG_PRI_OUT_CODEC                  0x0080

#define MGB_GG_SEC_OUT_MASK                   0x0300
#define MGB_GG_SEC_OUT_HAND_SET                0x000
#define MGB_GG_SEC_OUT_HEAD_SET                0x100
#define MGB_GG_SEC_OUT_HNDS_FREE               0x200
#define MGB_GG_SEC_OUT_LINE                    0x300
#define MGB_GG_SEC_OUT_RESERVED               0x0400
#define MGB_GG_SEC_OUT_CODEC                  0x0800

#define MGB_GG_RESERVED                       0xF000

} TNI_ATTR_PACK;

/*****************************************************************************
 * Returns Different Gain Parameters
 *****************************************************************************/
struct MGB_DMS_GET_GAINS{
  tuint  valid_bitmap;
#define MGB_GAIN_VALID_TX_DIG_GAIN               0x0001
#define MGB_GAIN_VALID_RX_DIG_GAIN               0x0002
#define MGB_GAIN_VALID_TX_AN_GAIN                0x0004
#define MGB_GAIN_VALID_RX_AN_GAIN                0x0008
#define MGB_GAIN_VALID_RX_SEC_AN_GAIN            0x0010
#define MGB_GAIN_VALID_LCD_GAIN                  0x0020
#define MGB_GAIN_VALID_SIDE_TONE_GAIN            0x0040
#define MGB_GAIN_VALID_AER_TX_DIGITAL            0x0080
#define MGB_GAIN_VALID_AER_RX_DIGITAL            0x0100
#define MGB_GAIN_VALID_OVERRIDE_AIC_MAP          0x0200
  tint tx_digital_gain;     /* TX Digital Gain: -14 to +14dB in 1dB steps */
  tint rx_digital_gain;     /* RX Digital Gain: -14 to +14dB in 1dB steps */
  tint tx_analog_gain;      /* TX Analog Gain in 0.5dB steps - used only for IP Phone */
  /*For AIC20 -  tx_analog_gain Max = 54db tx_analog_gain Min = 0 db     */
  /*For AIC23 -  tx_analog_gain Max = 12db tx_analog_gain Min = -34.5 db */
  tint rx_analog_gain;      /* RX Analog Gain in 0.5dB steps - used only for IP Phone */
  /*For AIC20 -  rx_analog_gain Min = -54db rx_analog_gain Max = 0 db */
  /*For AIC23 -  rx_analog_gain Min = -73db rx_analog_gain Max = 6 db */
  tint rx_sec_analog_gain;  /* RX Analog Gain in 0.5dB steps - for duplicate channel, used 
                                only for IP phone */
  tint lcd_gain;            /* LCD gain prog. in 3/16V steps - values 0-15 */
  tint side_tone_gain;      /* Sidetone Gain in 0.5dB steps - used only for IP Phone */
  tint aer_tx_dig_gain;
  tint aer_rx_dig_gain;
} TNI_ATTR_PACK;


#endif /* _GAINS_H */
/* nothing past this point */
