#ifndef _HALAPI_H
#define _HALAPI_H
/************************************************************************************
 * FILE PURPOSE: Structures shared between the DSP and host for the HAL module
 ************************************************************************************
 * FILE NAME: halapi.h
 *
 * DESCRIPTION: Defines shared structures for the hal module. 
 *
 * TABS: None
 *
 * Copyright (C) 2002, Texas Instruments Inc. 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#include <ti/mas/iface/ifeco/mgdefs.h>

/* Dummy Define for a Micro Macro */
#ifndef TNI_ATTR_PACK
#define TNI_ATTR_PACK
#endif

/***********************************************************************************
 * Message IDs used for hal access, host to DSP. Reserved values from 2101-2200
 ***********************************************************************************/
enum {
  MGB_MD_HALAPI_PROXY_ACCESS = 2101         /* 2101 */  
};

/*********************************************************************************
 * Message IDs for replies to host
 *********************************************************************************/
enum {
  MGB_DM_HALAPI_PROXY_ACCESS = MGB_MD_HALAPI_PROXY_ACCESS   /* 2101 */
};


/*********************************************************************************
 * Query/return registers accessed through a proxy interface.
 *********************************************************************************/
struct MGB_MDS_PROXY_ACCESS {
  tuint  write_mask_msw;      /* Bit map register indicating which reg to write */
  tuint  write_mask_lsw;      /* Lsw of write mask */
  tuint  read_mask_msw;       /* Bit map register of returned reads */
  tuint  read_mask_lsw;       /* Lsw of read mask */
  tuint  address_msw;         /* Pcntl address register - specifies periph address */
  tuint  address_lsw;         /* Pcntl address registers, lsw */
  tuint  first_word;          /* First register to write. Remaining values follow
                                * sequentially. */
} TNI_ATTR_PACK;

/*********************************************************************************
 * The return structure shares the same format
 *********************************************************************************/
struct MGB_DMS_PROXY_ACCESS {
  tuint  write_mask_msw;      /* Bit map register indicating which reg to write */
  tuint  write_mask_lsw;      /* Lsw of write mask */
  tuint  read_mask_msw;       /* Bit map register of returned reads */
  tuint  read_mask_lsw;       /* Lsw of read mask */
  tuint  address_msw;         /* Pcntl address register - specifies periph address */
  tuint  address_lsw;         /* Pcntl address registers, lsw */
  tuint  first_word;          /* First register to write. Remaining values follow
                                * sequentially. */
} TNI_ATTR_PACK;


/************************************************************************************
 * Idle timeslot drive configuration 
 ************************************************************************************/
typedef enum {
  HAL_IDLE_DRIVE_0 = 0,     /* Drive 0 on unused timeslot */
  HAL_IDLE_DRIVE_1 = 1,     /* Drive 1 on unused timeslot */       
  HAL_IDLE_DRIVE_Z = 2,     /* Hi-Z unused timeslot       */
  HAL_IDLE_DRIVE_R = 3      /* Reserved                   */
} TNI_ATTR_PACK halIdleDrive_t;

/************************************************************************************
 * EMIF configuration
 *
 * For the himalaya/tomahawk DDR2, please see SPRU970, sections 3.2 and 4,
 * to translate from memory data sheet parameters to these parameters.
 *
 ************************************************************************************/
struct MGB_MDS_EMIF_SDRAM
{
  tuint valid_params;
#define MGB_SDRAM_DOTEST  (1<<0)
#define MGB_SDRAM_CPU_PLL (1<<1)
#define MGB_SDRAM_CONFIG  (1<<2)
#define MGB_SDRAM_REFRESH (1<<3)
#define MGB_SDRAM_TIMING1 (1<<4)
#define MGB_SDRAM_TIMING2 (1<<5)
#define MGB_SDRAM_DDR_PLL (1<<6)
#define MGB_SDRAM_TIMING3 (1<<7)
#define MGB_SDRAM_PHYC    (1<<8)


  tuint pll;       /* CPU pll. CPU pll may be required for ddr2 access */
  
  tuint configMsw;
  tuint configLsw; /* Bit 22: ddr2 differential dqs enable 
                     * Bit 21: ddr2 termination value 0 = 75 ohm, 1 = 150 ohm 
                     * Bit 20: ddr2 enabled
                     * Bit 18: drive strength: 0 = normal, 1 = weak
                     * Bit 17: ddr enable: 0 = single rate, 1 = double rate
                     * Bit 16: sdram enable
                     * Bit 14: narrow mode: 0 for narry mode
                     * Bits 11:9: CAS latency (valid values are 2 - 6)
                     * Bits 6:4: Internal sdram bank setup
                     * Bit 3: External chip select setup
                     * Bits 2:0: page size */
                       
  tuint refreshMsw;
  tuint refreshLsw; /* Bit 31: Self refresh enable 
                      * Bit 30: mclk stop enable
                      * Bits 15:0: Refresh rate */
 
  tuint timing1Msw;
  tuint timing1Lsw; /* Bits 31:25: load to activate cycle timing 
                      * Bits 24:22: Precharge to activate cycles
                      * Bits 21:19: Active to read or write cycles
                      * Bits 18:16: Write to pre-charge cycles
                      * Bits 15:11: Activate to pre-charge cycles
                      * Bits 10:6:  Active to activate cycles
                      * Bits 5:3:   Active to activate (different bank) cycles
                      * Bits 1:0:   Write to read cycles */
                      
  tuint timing2Msw;
  tuint timing2Lsw;  /* Bits 24:23: EDT enable to write cycles 
                       * Bits 22:16: Self refresh exit to any command but read cycles
                       * Bits 15:8:  Self refresh exti to read command cycles
                       * Bits 7:5:   Read to pre-charge cycles
                       * Bits 4:0:   pado mcke change cycles */
                       
  tuint ddr_pll;     /* DDR pll. */
  tuint timing3Msw;
  tuint timing3Lsw;   /* Bits 24:23: EDT enable to write cycles 
                       * Bits 22:16: Self refresh exit to any command but read cycles
                       * Bits 15:8:  Self refresh exti to read command cycles
                       * Bits 7:5:   Read to pre-charge cycles
                       * Bits 4:0:   pado mcke change cycles */
  tuint phycMsw;
  tuint phycLsw;                     
                       
                       
} TNI_ATTR_PACK;                       
                    
 
struct MGB_MDS_EMIF_CONFIG
{
  union {
   struct MGB_MDS_EMIF_SDRAM sdram;
  } u;
  
} TNI_ATTR_PACK;


/* The maximum reply length - 5 words for dsp message header, 6 words for proxy header,
 * 64 words for 32-32 bit registers */
#define HAL_PROXY_ACCESS_MAX_MSG_SIZE   75





#endif /* _HALAPI_H */


