#ifndef _MACRAPI_H
#define _MACRAPI_H

#include <ti/mas/iface/ifeco/mgdefs.h>

/* Dummy Define for a Micro Macro */
#ifndef TNI_ATTR_PACK
#define TNI_ATTR_PACK
#endif

/******************************************************************************************************
 * FILE PURPOSE: Define the host API to configure MAC router
 ******************************************************************************************************
 * FILE NAME: macrapi.h
 *
 * DESCRIPTION: Defines the messages to configure the MAC router and receive MAC router status
 *
 * Copyright (C) 2008, Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
 
 
 /********************************************************************************************
  * MGB_MDS_MACR_REQUEST_STATS
  *
  *   This message is used to request mac router statistics. The bandwidth statistics 
  *   can be configured to be sent periodically.
  *
  ********************************************************************************************/
 struct MGB_MDS_MACR_REQUEST_STATS
 {
   
   tuint  requested_stats;     /* Bitmap of stats requested */
#define MGB_MACR_REQ_STATS_GENERAL  0x0001
#define MGB_MACR_REQ_STATS_ARP      0x0002
#define MGB_MACR_REQ_STATS_ICMP     0x0004
#define MGB_MACR_REQ_STATS_RX_BW    0x0008
#define MGB_MACR_REQ_STATS_TX_BW    0x0010
 
   tuint  physical_port;        /* Identifies which port the stats are from */
   
   tuint  persistence;         /* Persistance only applies if TX/RX BW stats are set in requested_stats */
#define MGB_MACR_REQ_STATS_ONCE         0x0000
#define MGB_MACR_REQ_STATS_PERSISTENT   0x0001
#define MGB_MACR_REQ_STATS_HALT         0x0002

} TNI_ATTR_PACK;


/***********************************************************************************************
 * MGB_MDS_MACR_CONFIG_ADDRESS
 *
 *   This message is used to configure IP/MAC addresses for ARP and PING replies
 *
 ***********************************************************************************************/
struct MGB_MDS_MACR_CONFIG_ADDRESS
{

  tuint function;
#define MGB_MACR_ADDR_CFG_FCN_ADD        0    /* Add this entry to the table                   */
#define MGB_MACR_ADDR_CFG_DEL_MAC        1    /* Delete all entries with this mac address      */
#define MGB_MACR_ADDR_CFG_DEL_IP         2    /* Delete the entry with this IP address         */
#define MGB_MACR_ADDR_CFG_DEL_MACIP      3    /* Delete the entry with this MAC/IP combination */

 tuint ip_addr[8];          /* The IP address  */
 tuint mac_addr[3];         /* The MAC address */
 
 /*  arp_config:
  *  /--------------------------------------------------------------\
  *  | 15      7  |        6       |   5        3  |   2       0    |
  *  |  reserved  |  reply enable  | accept config |  reply config  |
  *  \--------------------------------------------------------------/ 
  *
  *  -Accept config- specifies which physical port requests are accepted on
  *  -Reply config- specifies which physical port replies are sent on
  */
 tuint arp_config;
 
#define MGB_MACR_ADDR_CFG_ARP_REPLY_ENABLE        1
#define MGB_MACR_ADDR_CFG_ARP_REPLY_DISABLE       0

#define MGB_MACR_ADDR_CFG_ARP_ACCEPT_ANY_PORT     7
#define MGB_MACR_ADDR_CFG_ARP_REPLY_REC_PORT      7

#define MGB_MACR_ADDR_CFG_ARP_REPLY_CONFIG_BASE   0
#define MGB_MACR_ADDR_CFG_ARP_REPLY_CONFIG_MASK   7

#define MGB_MACR_ADDR_CFG_ARP_ACCEPT_CONFIG_BASE  3
#define MGB_MACR_ADDR_CFG_ARP_ACCEPT_CONFIG_MASK  7

#define MGB_MACR_ADDR_CFG_ARP_REPLY_ENABLE_BASE   6
#define MGB_MACR_ADDR_CFG_ARP_REPLY_ENABLE_MASK   1


  /*  icmp_config:
   *  /--------------------------------------------------------------\
   *  | 15      7  |        6       |   5        3  |   2       0    |
   *  |  reserved  |  reply enable  | accept config |  reply config  |
   *  \--------------------------------------------------------------/
   *
   *  -Accept config- specifies which physical port requests are accepted on
   *  -Reply config- specifies which physical port replies are sent on
   */
  tuint icmp_config;
  
#define MGB_MACR_ADDR_CFG_ICMP_REPLY_ENABLE       1
#define MGB_MACR_ADDR_CFG_ICMP_REPLY_DISABLE      0

#define MGB_MACR_ADDR_CFG_ICMP_ACCEPT_ANY_PORT    7
#define MGB_MACR_ADDR_CFG_ICMP_REPLY_REC_PORT     7

#define MGB_MACR_ADDR_CFG_ICMP_ENABLE_BASE        6
#define MGB_MACR_ADDR_CFG_ICMP_ENABLE_MASK        1

#define MGB_MACR_ADDR_CFG_ICMP_REPLY_CONFIG_BASE  0
#define MGB_MACR_ADDR_CFG_ICMP_REPLY_CONFIG_MASK  7

#define MGB_MACR_ADDR_CFG_ICMP_ACCEPT_CONFIG_BASE 6
#define MGB_MACR_ADDR_CFG_ICMP_ACCEPT_CONFIG_MASK


  tuint ip_version;
#define MGB_MACR_ADDR_CFG_IP_IPV4   0
#define MGB_MACR_ADDR_CFG_IP_IPV6   1

  tuint ttl_hop_limit;
  
} TNI_ATTR_PACK;


/*********************************************************************************************
 * MGB_MDS_MACR_CONFIG_TABLE
 *
 *  This message is used to map or unmap UDP port addresses to MAC addresses
 *
 *********************************************************************************************/
struct MGB_MDS_MACR_CONFIG_TABLE {

  tuint function;
#define MGB_MACR_MAC_TBL_CFG_ADD_ELEMENTS    0
#define MGB_MACR_MAC_TBL_CFG_DEL_ELEMENTS    1   /* Deletes the UDP to MAC element entry */
#define MGB_MACR_MAC_TBL_CFG_READ_ELEMENTS   2
#define MGB_MACR_MAC_TBL_CFG_DEL_MAC         3   /* Deletes all UDP with the MAC value   */

  tuint dest_mac[3];
  
  tuint src_mac[3];
  
  /*  port_config
   *  /-------------------------------------------------------------------\
   *  |    15   | 14     11  |  10        8   |  7     3  | 2         0   |
   *  | src mac |  reserved  | accept config  |  reserved | reply config  |
   *  \-------------------------------------------------------------------/
   *
   *  -src mac- if set the value in src_mac is used on outbound packets
   *            if not set the original dest mac value is used
   *
   *  -accept config- specifies which physical port requests are accepted on
   *  -reply config- specifies which physical port replies are sent on
   */
  tuint port_config;
#define MGB_MACR_MAC_TBL_CFG_ACCEPT_ANY_PORT     7
#define MGB_MACR_MAC_TBL_CFG_REPLY_REC_PORT      7

#define MGB_MACR_MAC_TBL_CFG_REPLY_BASE          0
#define MGB_MACR_MAC_TBL_CFG_REPLY_MASK          7

#define MGB_MACR_MAC_TBL_CFG_ACCEPT_BASE         8
#define MGB_MACR_MAC_TBL_CFG_ACCEPT_MASK         7

#define MGB_MACR_MAC_TBL_CFG_SRC_BASE           15
#define MGB_MACR_MAC_TBL_CFG_SRC_MASK            1

  tuint nports;
  tuint first_port;
  tuint port_delta;
  
#define MGB_MACR_MAC_TBL_MAX_READ_PORTS         100  /* The maximum number of ports that can read */
  
} TNI_ATTR_PACK;

/**********************************************************************************
 * MAC routing enable/disable by port
 **********************************************************************************/
struct MGB_MDS_MACR_PORT_STATE  {

  tuint function;
#define MGB_MACR_PORT_STATE_DISABLE     0  /* Disable MAC routing on a port */
#define MGB_MACR_PORT_STATE_ENABLE      1  /* Enable MAC routing on a port  */

  tuint physical_port;   /* The physical port to enable/disable MAC routing */
  
} TNI_ATTR_PACK;


/*************************************************************************************************
 * General stats reply
 *************************************************************************************************/
struct MGB_MACR_STATS_REPLY_GENERAL  {

  tuint receive_packet_count_msw;
  tuint receive_packet_count_lsw;

  tuint receive_bcast_count_msw;
  tuint receive_bcast_count_lsw;
  
  tuint receive_drop_ethertype_msw;
  tuint receive_drop_ethertype_lsw;

  tuint receive_bcast_drop_ip_protocol_msw;
  tuint receive_bcast_drop_ip_protocol_lsw;
  
  tuint receive_mcast_drop_ip_protocol_msw;
  tuint receive_mcast_drop_ip_protocol_lsw;
  
  tuint receive_unicast_drop_ip_protocol_msw;
  tuint receive_unicast_drop_ip_protocol_lsw;
  
  tuint receive_drop_no_udp_match_msw;
  tuint receive_drop_no_udp_match_lsw;

  tuint receive_drop_port_reject_msw;
  tuint receive_drop_port_reject_lsw;
  
  tuint forwarded_packet_count_msw;
  tuint forwarded_packet_count_lsw;
  
  tuint xmit_drop_overflow_msw;
  tuint xmit_drop_overflow_lsw;

} TNI_ATTR_PACK;

/**********************************************************************************************
 * ARP stats reply
 **********************************************************************************************/
struct MGB_MACR_STATS_REPLY_ARP
{
  tuint arp_parse_fail_count_msw;
  tuint arp_parse_fail_count_lsw;
  
  tuint arp_drop_opcode_msw;
  tuint arp_drop_opcode_lsw;
  
  tuint arp_reply_count_msw;
  tuint arp_reply_count_lsw;
  
  tuint arp_drop_invalid_hw_len_msw;
  tuint arp_drop_invalid_hw_len_lsw;
  
  tuint arp_no_match_msw;
  tuint arp_no_match_lsw;

  tuint arp_reply_drop_overflow_msw;
  tuint arp_reply_drop_overflow_lsw;
  
  tuint arp_drop_port_reject_msw;
  tuint arp_drop_port_reject_lsw;
  
  tuint arp_drop_proto_not_ip_msw;
  tuint arp_drop_proto_not_ip_lsw;
  
  tuint arp_drop_in_table_no_reply_set_msw;
  tuint arp_drop_in_table_no_reply_set_lsw;

} TNI_ATTR_PACK;

/*************************************************************************************************
 * ICMP stats reply
 *************************************************************************************************/
struct MGB_MACR_STATS_REPLY_ICMP
{
  tuint icmp_parse_fail_count_msw;
  tuint icmp_parse_fail_count_lsw;
  
  tuint icmp_drop_not_echo_request_msw;
  tuint icmp_drop_not_echo_request_lsw;

  tuint icmp_drop_in_table_no_reply_set_msw;
  tuint icmp_drop_in_table_no_reply_set_lsw;

  tuint icmp_drop_port_reject_msw;
  tuint icmp_drop_port_reject_lsw;

  tuint icmp_ping_reply_count_msw;
  tuint icmp_ping_reply_count_lsw;

  tuint icmp_drop_ipv4_frag_msw;
  tuint icmp_drop_ipv4_frag_lsw;

  tuint icmp_drop_code_error_msw;
  tuint icmp_drop_code_error_lsw;

  tuint icmp_drop_reply_code_error_msw;
  tuint icmp_drop_reply_code_error_lsw;

  tuint icmp_reply_drop_overflow_msw;
  tuint icmp_reply_drop_overflow_lsw;
} TNI_ATTR_PACK;

/*************************************************************************************************
 * Bandwitdh stats reply
 *************************************************************************************************/
struct MGB_MACR_STATS_REPLY_BW
{

  tuint start_timestamp_ms_msw;
  tuint start_timestamp_ms_lsw;
  
#define MGB_MACR_BW_NBINS   64
  tuint bin_msw[MGB_MACR_BW_NBINS];
  tuint bin_lsw[MGB_MACR_BW_NBINS];
  
} TNI_ATTR_PACK;


/*************************************************************************************************
 * MGB_DMS_MACR_STATS_REPLY
 *
 * This message is generated in response to a stats request message.
 *
 *************************************************************************************************/
struct MGB_DMS_MACR_STATS_REPLY
{
  tuint req_stats;
#define MGB_MACR_STATS_REPLY_REQ_GENERAL    0
#define MGB_MACR_STATS_REPLY_REQ_ARP        1
#define MGB_MACR_STATS_REPLY_REQ_ICMP       2
#define MGB_MACR_STATS_REPLY_REQ_RX_BW      3
#define MGB_MACR_STATS_REPLY_REQ_TX_BW      4

  tuint physical_port;


  union  {
  
    struct MGB_MACR_STATS_REPLY_GENERAL general;
    struct MGB_MACR_STATS_REPLY_ARP     arp;
    struct MGB_MACR_STATS_REPLY_ICMP    icmp;
    struct MGB_MACR_STATS_REPLY_BW      rx;
    struct MGB_MACR_STATS_REPLY_BW      tx;
   
  } u;
  
} TNI_ATTR_PACK;



/****************************************************************************************************
 * MGB_DMS_MACR_TABLE_READ_RESP
 *
 * This message is generated in response to a table read request message. Multiple responses
 * can be generated from a single request if the request covers multiple mac addresses.
 *
 *****************************************************************************************************/
struct MGB_DMS_MACR_TABLE_READ_RESP
{
  tuint mac_addr[3];                             /* The mac address corresponding to the UDP ports requested       */
  tuint flags;                                   /* The flags associated with this MAC address (MACR_CONFIG_TABLE) */
  tuint n_ports;                                 /* The number of ports which follow                               */
  tuint ports[MGB_MACR_MAC_TBL_MAX_READ_PORTS];  /* A list of ports which correspond to this mac address           */

} TNI_ATTR_PACK;





/*******************************************************************************************************
 * Error Indication codes
 *******************************************************************************************************/
enum {
 MGB_ERR_MACR_INVALID_PORT = 310,             /* Message received with an invalid physical port number  */
 MGB_ERR_MACR_INVALID_PERSISTENCE,            /* BW stats request had invalid persistence value         */
 MGB_ERR_MACR_INVALID_FUNCTION,               /* Invalid function field in received message             */
 MGB_ERR_MACR_INVALID_PROTOOCL,               /* Invalid IP protocol specified in a message             */
 MGB_ERR_MACR_INVALID_DUP_IP_CONFIG,          /* Duplicate IP config specified                          */
 MGB_ERR_MACR_INVALID_NO_FREE_MAC_IP,         /* No Free MAP/IP table for requested configuration       */
 MGB_ERR_MACR_INVALID_IP_PROTOCOL,            /* Invalid IP protocol type specified in message          */
 MGB_ERR_MACR_TABLE_INCONSISTENCY,            /* An internal inconsistency in the IP/MAC table found    */
 MGB_ERR_MACR_INVALID_NO_MAC_MATCH,           /* No match for the MAC address found                     */
 MGB_ERR_MACR_INVALID_NO_IP_MATCH,            /* No match for the IP address found                      */
 MGB_ERR_MACR_INVALID_NO_IP_MAC_MATCH,        /* No match for the IP/MAC address combination found      */
 MGB_ERR_MACR_INVALID_NO_FREE_MAC_TABLES,     /* No available MAC tables                                */
 MGB_ERR_MACR_INVALID_MAC_TABLE_CONFIG,       /* Invalid MAC table configuration parameters             */
 MGB_ERR_MACR_INVALID_TABLE_READ_SIZE_FAIL,   /* Too many table read elements requested                 */
 MGB_ERR_MACR_INVALID_PORT_RE_ENABLE,         /* Attemped to enable routing on an already enabled port  */
 MGB_ERR_MACR_INVALID_NO_FREE_CONTEXT,        /* No free context to enable routing on a port            */
 MGB_ERR_MACR_INVALID_CLOSE_PORT_NUM          /* Invalid logical port specified in close                */
};





#endif /* _MACRAPI_H */


