#ifndef __MGDEFS_H__
#define __MGDEFS_H__
/******************************************************************************
 * FILE PURPOSE: Structures and includes available for module-specific defs
 ******************************************************************************
 * FILE NAME:   mgdefs.h
 *
 * DESCRIPTION: The structures and include files here define structure and
 *              types that are available to all eco's.
 *
 * TABS: NONE
 *
 * $Id: $
 *
 * REVISION HISTORY:
 *
 * $Log: $
 *
 * (C) Copyright 2002 Texas Instruments Incorporated. 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#include <ti/mas/types/types.h>

/* Dual-port RAM must be an unsigned 16-bit integer type */
typedef tuint dprword;
#define TYP_DPRWORD_SIZE  TYP_TUINT_SIZE

/* Message Parameter Size in dprword's */
#define MGB_MSGPAR_SIZE   1 /* number of drpword's in one tuint parameter */
#define MGB_HEADER_SIZE   5 /* number of dprword's in generic header */

/* Maximum message specific content size (in # of parameters)*/
#define MGB_MSG_MAXNPAR ((DPR_MSGBUF_SIZE - MGB_HEADER_SIZE)/MGB_MSGPAR_SIZE)
#if (MGB_MSG_MAXNPAR * MGB_MSGPAR_SIZE + MGB_HEADER_SIZE != DPR_MSGBUF_SIZE)
# error MGB_MSG_MAXNPAR calculation is inconsistent
#endif
 
#endif  /* __MGDEFS_H__ */

/* nothing past this point */
