#ifndef _MICDSPHD_H
#define _MICDSPHD_H

/*****************************************************************************
 * FILE PURPOSE: MIC-DSP dual port ram (DPR) high density definitions.
 *****************************************************************************
 * FILE NAME: micdsphd.h
 *
 * DESCRIPTION: Defines the partition of the MIC-DSP DPR
 *
 *              NOTE 1: Both DSP and MIC use this file
 *              NOTE 2: All sizes are in 16 bit words
 *              NOTE 3: "dprword" must be defined by each the DSP and
 *                      MIC in a header file named: micdspsh.h
 *
 * USES: micdspsh.h - DSP and MIC have their own seperate file which
 *                    defines data types shared between MIC and DSP.
 *                    Must define the following data type:
 *                         dprword: an unsigned 16 bit integer
 *       dprconfig.h - Shared by DSP and MIC. This is a build specific file
 *                    which defines the FIFO sizes. 
 *
 * TABS: NONE
 *
 * (C) Copyright 2000, Texas Instruments Inc. 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#include <ti/mas/iface/ifeco/mgdefs.h>

/* Dummy Define for a Micro Macro */
#ifndef TNI_ATTR_PACK
#define TNI_ATTR_PACK
#endif

/* the HPI-CA (hpi communications area) structure */
typedef struct {
   volatile   dprword    magic_versionId;     /* 8 MSB magic, 8 LSB version */
   dprword    heartBeat;
   dprword    inPointerRx;         /* HW-A writes, DSP reads     */
   dprword    outPointerRx;        /* DSP writes, HW-A reads     */
   dprword    inPointerTx;         /* DSP writes, HW-A reads     */
   dprword    outPointerTx;        /* HW-A writes, DSP reads     */
   dprword    rxSa;
   dprword    rxEa;
   dprword    txSa;
   dprword    txEa;
   dprword    intNum;              /* HW-A to DSP external int N  */
   dprword    clockMul;            /* 5421, 5441 clock multiplier */
   dprword    dspCoreID;           /* HW-A writes at startup      */
   dprword    msgRouteTag;         /* To host message route tag   */
   dprword    debug[16];
} TNI_ATTR_PACK dprHpiCaHeader_t;



#endif /* _MICDSPHD_H */
