/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



#ifndef _PLRCFG_H
#define _PLRCFG_H
/******************************************************************************
 * FILE PURPOSE: PLR configuration and message file.
 ******************************************************************************
 * FILE NAME:   plrcfg.h
 *
 * DESCRIPTION: Contains messages shared by PLR and micro.
 *
 *              NOTE: This file may be used by both Micro and DSP software.
 *
******************************************************************************/

#include <ti/mas/iface/ifeco/mgdefs.h>

/* Dummy Define for a Micro Macro */
#ifndef TNI_ATTR_PACK
#define TNI_ATTR_PACK
#endif

#define FEC_MAX_FEC_AT_A_TIME     3   /* For Telogy FEC codes, at any given time,  
                                     the maximum number of linked list is 3. 
                                     If other FEC codes are used, this number
                                     needs to be reexaminated */

/*****************************************************************************
 * Used for configuring PLR.
 *****************************************************************************/
struct MGB_MDS_PLR_CONFIG {
tuint valid_params;
#define MGB_PLR_VALID_RED_ENABLE               0x0001
#define MGB_PLR_VALID_RED_PAYLOAD_TYPE         0x0002
#define MGB_PLR_VALID_RED_LEVEL_VOICE          0x0004
/* This applies to voice, sid, dtmf but not CAS */
#define MGB_PLR_VALID_RED_LEVEL_TTY            0x0010
#define MGB_PLR_VALID_FEC_ENABLE               0x0020
#define MGB_PLR_VALID_FEC_PAYLOAD_TYPE         0x0040
#define MGB_PLR_VALID_FEC_SSRC                 0x0080
#define MGB_PLR_VALID_RESERVED                 0x0100
#define MGB_PLR_VALID_FEC_2198_ENCAP           0x0200
#define MGB_PLR_VALID_FEC_CODE_BITMAP          0x0400
#define MGB_PLR_VALID_ENABLE_DIR               0x0800 /* If not set, then enable/disable
                                                         both tx and rx directions. */
#define MGB_PLR_VALID_FEC_2198_LEVEL           0x1000

/* Bit fields required by 1:N redundancy: describing size of words affected by each valid
 * params bit.
 */
#define MGB_PLR_CONFIG_VPBT1                   0x21110111
#define MGB_PLR_CONFIG_VPBT2                   0x00011610

tuint redEnable;
#define MGB_PLR_RED_DISABLE      0 
#define MGB_PLR_RED_ENABLE       1 

tuint redPayloadType;
tuint redLevelVoice;
tuint redLevelTTY;
  
tuint fecEnable;
#define MGB_PLR_FEC_DISABLE      0 
#define MGB_PLR_FEC_ENABLE       1 

tuint fecPayloadType;
tuint fecSSRC_MSW;
tuint fecSSRC_LSW;
tuint fec2198Encap;
#define MGB_PLR_FEC_2198_DISABLE      0 
#define MGB_PLR_FEC_2198_ENABLE       1

tuint fecCodeBitMap[6];

tuint enableDirection; 
#define MGB_PLR_TO_TELE           0x0001 /* Enable RX Direction */
#define MGB_PLR_TO_PKT            0x0002 /* Enable TX Direction */

tuint fec2198Level;

}TNI_ATTR_PACK ;

#endif /* _PLRCFG_H */
/* nothing past this point */

