/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



#ifndef _REMOTETID_H
#define _REMOTETID_H
/******************************************************************************
 * FILE PURPOSE: Interface for remote tid
 ******************************************************************************
 * FILE NAME:   remotetid.h
 *
 * DESCRIPTION: This file is used by both Micro and DSP software.
 *
******************************************************************************/

#include <ti/mas/iface/ifeco/mgdefs.h>

/* Dummy Define for a Micro Macro */
#ifndef TNI_ATTR_PACK
#define TNI_ATTR_PACK 
#endif

#define MGB_MDS_MAX_TID_MEM_RW_BLOCK_SIZE  128

/*****************************************************************************/
/*                   TID control operations - start                          */
/*****************************************************************************/

struct MGB_MDS_TID_FPGA_INIT {
    tuint  read_addr_msw;
    tuint  read_addr_lsw;
    tuint  write_addr_msw;
    tuint  write_addr_lsw;
    tuint  reg_addr_msw;
    tuint  reg_addr_lsw;
    tuint  access_addr_msw;
    tuint  access_addr_lsw;
    tuint  interrupt_mask_addr_msw;
    tuint  interrupt_mask_addr_lsw;
    tuint  interrupt_status_addr_msw;
    tuint  interrupt_status_addr_lsw;
    tuint  register_types;
    
    tuint  slot_0_1_flag;   
    tuint  slot_2_3_flag;   
    tuint  rd_write_op;
    tuint  complete_mask_val;   
} TNI_ATTR_PACK;

/* Register types : bit definitions */
#define MGB_MDS_TID_CONTROL_INT_MASK_REG_TYPE_MASK 0x3
#define MGB_MDS_TID_INT_MASK_REG_TYPE_NONE 0x0
#define MGB_MDS_TID_INT_MASK_REG_TYPE_DIRECT 0x1
#define MGB_MDS_TID_INT_MASK_REG_TYPE_INDIRECT 0x2

#define MGB_MDS_TID_CONTROL_INT_STATUS_REG_TYPE_MASK 0xc
#define MGB_MDS_TID_INT_STATUS_REG_TYPE_NONE 0
#define MGB_MDS_TID_INT_STATUS_REG_TYPE_DIRECT 0x4
#define MGB_MDS_TID_INT_STATUS_REG_TYPE_INDIRECT 0x8

/* Access register bit definitions */
#define MGB_MDS_TID_ACCESS_LAST_ACCESS_COMPLETE_MASK    0x80
#define MGB_MDS_TID_ACCESS_TYPE_MASK                                     0x40
#define MGB_MDS_TID_ACCESS_OPERATION_TYPE_MASK                0x10
#define MGB_MDS_TID_ACCESS_ADDR_MASK                                    0x0f

#define MGB_MDS_TID_ACCESS_TYPE_FPGA   0x40
#define MGB_MDS_TID_ACCESS_TYPE_TID      0x00

#define MGB_MDS_TID_ACCESS_OPERATION_TYPE_READ     0x10
#define MGB_MDS_TID_ACCESS_OPERATION_TYPE_WRITE   0x00

struct MGB_MDS_TID_GENERAL_ACK  {
    tuint  reserved1;
    tuint  reserved2; 
    tuint  reserved3; 
    tuint  reserved4; 
} TNI_ATTR_PACK;

struct MGB_MDS_TID_MEM_READ {
    tuint  slot;     /* TID slot */
    tuint  tcid;    /* tcid for request*/
    tuint  reg;    /* TID register */
    tuint  type;  /* Operation type */
    tuint  length;    /* for now defaults to 1 */
} TNI_ATTR_PACK;

/* Types applicable for both read and write types */
#define MGB_MDS_TID_OPERATION_TYPE_TID 0x0
#define MGB_MDS_TID_OPERATION_TYPE_FPGA_DIRECT 0x1
#define MGB_MDS_TID_OPERATION_TYPE_FPGA_INDIRECT 0x2

struct MGB_MDS_TID_MEM_WRITE {
    tuint  slot;     /* TID slot */
    tuint  tcid;    /* tcid for request*/
    tuint  reg;    /* TID register */
    tuint  type;  /* Operation type */
    tuint  length;    /* for now defaults to 1 */
    tuint  write_val[MGB_MDS_MAX_TID_MEM_RW_BLOCK_SIZE];
} TNI_ATTR_PACK;  

#define MGB_MDS_TID_WRITE_HEADER_SIZE  5



/*****************************************************************************/
/*                   TID control operations - start                          */
/*****************************************************************************/

struct MGB_DMS_TID_MEM_READ {
    tuint  slot;     /* TID slot */
    tuint  tcid;    /* tcid for request*/
    tuint  reg;    /* TID register */
    tuint  type; /* Type of memory write */
    tuint  length;    /* for now defaults to 1 */
    tuint  result;
    tuint  read_val[MGB_MDS_MAX_TID_MEM_RW_BLOCK_SIZE];
} TNI_ATTR_PACK;

#define MGB_DMS_TID_MEM_READ_RESULT_SUCCESS  0x0
#define MGB_DMS_TID_MEM_WRITE_RESULT_SUCCESS  0x0

#define MGB_DMS_TID_MEM_READ_RESULT_FAILURE  0xffff
#define MGB_DMS_TID_MEM_WRITE_RESULT_FAILURE  0xfffe

struct MGB_DMS_TID_MEM_WRITE {
    tuint  slot;     /* TID slot */
    tuint  tcid;    /* tcid for request*/
    tuint  reg;    /* TID register */
    tuint  type; /* Type of memory write */
    tuint  length;    /* for now defaults to 1 */
    tuint  result;
} TNI_ATTR_PACK;  

struct MGB_DMS_TID_INT_REQ {
    tuint  intSeqNumber;
    tuint  reg01;     /* Int registers 0 and 1 */
    tuint  reg23;     /* Int registers 2 and 3 */
    tuint  reg45;     /* Int registers 4 and 5 */
    tuint  reg67;     /* Int registers 6 and 7 */
    tuint  reserved1;   /* TBD */
    tuint  reserved2;   /* TBD */
    tuint  reserved3;   /* TBD */
} TNI_ATTR_PACK;  

/*****************************************************************************/
/*                   TID control operations - end                            */
/*****************************************************************************/


#endif /* _REMOTETID_H */
/* nothing past this point */
