#ifndef __RTTRACEAPI_H__
#define __RTTRACEAPI_H__
/******************************************************************************
 * FILE PURPOSE: Structures shared between DSP and host for realtime trace
 ******************************************************************************
 * FILE NAME:   rttraceapi.h
 *
 * DESCRIPTION: Defines shared structures for the realtime trace functionality.
 *
 * TABS: NONE
 *
 * $Id: $
 *
 * REVISION HISTORY:
 *
 * $Log: $
 *
 * (C) Copyright 2004 Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#include <ti/mas/iface/ifeco/mgdefs.h>

/* Dummy Define for a Micro Macro */
#ifndef TNI_ATTR_PACK
#define TNI_ATTR_PACK
#endif

#define MGB_RTTRACE_STREAM_ID_PCM_IN    0x0000 
#define MGB_RTTRACE_STREAM_ID_PCM_OUT   0x0001 
#define MGB_RTTRACE_STREAM_ID_PKT_IN    0x0002
#define MGB_RTTRACE_STREAM_ID_PKT_OUT   0x0003
#define MGB_RTTRACE_STREAM_ID_ECSOUT    0x0004 /* Linear output of ecan  */
#define MGB_RTTRACE_STREAM_ID_VPUEVT    0x0005 /* VPU events/actions     */
#define MGB_RTTRACE_STREAM_ID_VPUSEG    0x0006 /* VPU segment by segment */
#define MGB_RTTRACE_STREAM_ID_DSIG_IN   0x0007
#define MGB_RTTRACE_STREAM_ID_DSIG_OUT  0x0008

#define MGB_RTTRACE_STREAM_ID_RESERVED1 0x8000 /* Host msg tracing */
#define MGB_RTTRACE_STREAM_ID_RESERVED2 0x4000 /* Host msg tracing */

struct MGB_MDS_RTTRACE {
  tuint mask;		  /* specify which bits are vaild */
  tuint enable;      /* 0: disable, !0: enable per bitmap */
#define MGB_MDS_ENABLE_PCM_TRACE_RX    (1<<MGB_RTTRACE_STREAM_ID_PCM_IN)
#define MGB_MDS_ENABLE_PCM_TRACE_TX    (1<<MGB_RTTRACE_STREAM_ID_PCM_OUT)
#define MGB_MDS_ENABLE_PKT_TRACE_RX    (1<<MGB_RTTRACE_STREAM_ID_PKT_IN)
#define MGB_MDS_ENABLE_PKT_TRACE_TX    (1<<MGB_RTTRACE_STREAM_ID_PKT_OUT)
#define MGB_MDS_ENABLE_ECSOUT_TRACE    (1<<MGB_RTTRACE_STREAM_ID_ECSOUT)
#define MGB_MDS_ENABLE_VPUEVT_TRACE    (1<<MGB_RTTRACE_STREAM_ID_VPUEVT)
#define MGB_MDS_ENABLE_VPUSEG_TRACE    (1<<MGB_RTTRACE_STREAM_ID_VPUSEG)
#define MGB_MDS_ENABLE_DSIG_TRACE_RX   (1<<MGB_RTTRACE_STREAM_ID_DSIG_IN)
#define MGB_MDS_ENABLE_DSIG_TRACE_TX   (1<<MGB_RTTRACE_STREAM_ID_DSIG_OUT)
} TNI_ATTR_PACK;

/******************************************************************************
 *  RTTRACE Report
 *
 *  DSP to Host PCM/PKT trace report. Each report can consists of more than
 *  one segment
 *
 *  Eg:  
 *
 *     {
 *        MGB_DMS_RTTRACE_HDR
 *        MGB_DMS_RTTRACE_RECHDR 
 *        buffer1
 *        MGB_DMS_RTTRACE_RECHDR 
 *        buffer2
 *        MGB_DMS_RTTRACE_RECHDR 
 *        buffer3
 *        ...
 *     }
 *
 *****************************************************************************/
struct MGB_DMS_RTTRACE_HDR {
  tuint sqn_tsmsw;  /* MS 8 bits: Free-running sequence number               */
                     /* LS 8 bits: MSB of timestamp in 125us units            */
#define MGB_RTTRACE_SQN_MASK    0xFF00u
#define MGB_RTTRACE_SQN_SHIFT   8
#define MGB_RTTRACE_TSMSW_MASK  0x00FFu
#define MGB_RTTRACE_TSMSW_SHIFT 0
  tuint tslsw;      /* LSW of timestamp in 125us units (24 bits total)       */
} TNI_ATTR_PACK;

struct MGB_DMS_RTTRACE_RECHDR {
  tuint  streamId_chan;    /* MS 5 bits: Strm ID (See MGB_RTTRACE_STREAM_ID) */
                            /* LS 10 bits: Channel #                          */
#define MGB_RTTRACE_STREAMID_MASK  0xF800u
#define MGB_RTTRACE_STREAMID_SHIFT 11
#define MGB_RTTRACE_CHNUM_MASK     0x03FFu
#define MGB_RTTRACE_CHNUM_SHIFT    0
  tuint  ts_len;           /* MS 8 bits: Timestamp relative to 
                             * MGB_DMS_RTTRACE_HDR.timestamp                  */
                            /* LS 8 bits: Data record length in bytes         */
#define MGB_RTTRACE_TS_MASK        0xFF00u
#define MGB_RTTRACE_TS_SHIFT       8
#define MGB_RTTRACE_LEN_MASK       0x00FFu
#define MGB_RTTRACE_LEN_SHIFT      0
} TNI_ATTR_PACK;

struct MGB_DMS_RTTRACE {
  struct MGB_DMS_RTTRACE_HDR    hdr;    /* Header */
  struct MGB_DMS_RTTRACE_RECHDR rechdr; /* Record header */
  tuint data[1]; /* Variable len buf per length in ts_len */
} TNI_ATTR_PACK;

#endif  /* __RTTRACEAPI_H__ */

/* nothing past this point */
