/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



#ifndef _TTUMSG_H
#define _TTUMSG_H
/******************************************************************************
 * FILE PURPOSE: Any Message Related to TTU   
 ******************************************************************************
 * FILE NAME:   ttumsg.h
 *
 * DESCRIPTION: This file is used by both Micro and DSP software.
 *
******************************************************************************/

#include <ti/mas/iface/ifeco/mgdefs.h>

/* Dummy Define for a Micro Macro */
#ifndef TNI_ATTR_PACK
#define TNI_ATTR_PACK
#endif

/***********************************************************************
 * Start of data structures definition for TTU_CONFIG message          *
 ***********************************************************************/

typedef struct {
    tuint params;
# define MGB_TTU_BDT_45BPS  0x0000 /* is set use 50 bps, otherwise 45 bps */
# define MGB_TTU_BDT_50BPS  0x0001 /* is set use 50 bps, otherwise 45 bps */

# define MGB_TTU_BDT_RESVD  0xFFFE /* reserved bits, must be set to 0     */
  } TNI_ATTR_PACK MGB_MDS_TTU_CFG_BDT;

typedef union {
  MGB_MDS_TTU_CFG_BDT  bdt;
} TNI_ATTR_PACK MGB_MDS_TTU_CFG_SIDE;

typedef struct {
  MGB_MDS_TTU_CFG_SIDE  right;
  MGB_MDS_TTU_CFG_SIDE  left;
} TNI_ATTR_PACK MGB_MDS_TTU_CFG_PARAMS;


typedef struct {
  tuint ctrl_msg;
# define MGB_TTU_CTM_GEN_ENQUIRY  0x0001 /* To generate enqiry burst*/
 } TNI_ATTR_PACK MGB_MDS_TTU_CTRL_CTM;

typedef union {
  MGB_MDS_TTU_CTRL_CTM  ctm;
} TNI_ATTR_PACK MGB_MDS_TTU_CTRL_SIDE;

typedef struct {
  MGB_MDS_TTU_CTRL_SIDE  right;
  MGB_MDS_TTU_CTRL_SIDE  left;
} TNI_ATTR_PACK MGB_MDS_TTU_CTRL_PARAMS;

typedef union {
  MGB_MDS_TTU_CFG_PARAMS   cfg;
  MGB_MDS_TTU_CTRL_PARAMS  ctrl;
} TNI_ATTR_PACK MGB_MDS_TTU_PARAMS;

struct MGB_MDS_TTU_CONFIG {
  tuint valid_params;
# define MGB_TTU_CONFIG_TDM  0x1
# define MGB_TTU_CONFIG_PKT  0x2
# define MGB_TTU_CONTROL_TDM 0x4
# define MGB_TTU_CONTROL_PKT 0x8

  tuint modes;
# define MGB_TTU_TDM_MASK   0xff00
# define MGB_TTU_TDM_SHFT   8
# define MGB_TTU_PKT_MASK   0x00ff
# define MGB_TTU_PKT_SHFT   0
  /* the following define modes of operation for the tdm/pkt  */
  /* sides                                                    */
# define MGB_TTU_MODE_NONE  0x00 /* by-pass                   */
/*# define MGB_TTU_MODE_AUTO  0x01 automoding                */
# define MGB_TTU_MODE_CTM   0x10 /* Cellular Text Modem (CTM) */
# define MGB_TTU_MODE_BDT   0x11 /* Baudot 45.45 bps          */
# define MGB_TTU_MODE_CERT  0x40 /* Cert                      */

# define MGB_TTU_MODE_RELAY 0x80 /* RFC 2793 - can be used in    */
                                 /* conjunction with other modes */
                                 /* (for now only with bypass)   */

  /* the following are optional parameters for modes that 
   * require parameters. The 1st entry must be included and is 
   * don't care if the 2nd function requires parameters.
   */
  MGB_MDS_TTU_PARAMS prms;
} TNI_ATTR_PACK;

struct MGB_DMS_TTU_GET_STATS {
 tuint   side;            /* TDM, PKT side */
#define MGB_TTU_STAT_TDM  0x1
#define MGB_TTU_STAT_PKT  0x2

 tuint   state;         
#define MGB_TTU_CTM_STATE_IDLE       1
#define MGB_TTU_CTM_STATE_PREPARE    2
#define MGB_TTU_CTM_STATE_CONNECTED  6

 tuint   tx_char_count;
 tuint   rx_char_count;
} TNI_ATTR_PACK;

#endif /*_TTUMSG_H */
