#ifndef _FMTYPES_INCLUDED
#define _FMTYPES_INCLUDED
/*****************************************************************************
 * FILE PURPOSE:    Generic Fax Modem Types
 *****************************************************************************
 * FILE NAME:       fmtypes.h
 *
 * DESCRIPTION:     This file contains definitions that specify the Fax
 *                  Modem command/status message interface (via Data Packet).
 *
 * NOTE:            This file is processor independent, thus no assumption
 *                  of word size should be made. The data is interpreted
 *                  as a byte stream.
 *
 * (C) Copyright 2002, Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

/****************************************************************************/
/*              General Definitions                                         */
/****************************************************************************/

#define DATAPKT_FAX_MAX_DATA_HDR_B      3   /* Maximum hdr for fax data     */
#define DATAPKT_FAX_MAX_DATA_PAYLOAD_B 64   /* Maximum fax payload (no hdr) */

/****************************************************************************/
/*              Fax Command Message IDs                                     */
/****************************************************************************/

#define DATAPKT_FAX_CMD_MODE            1   /* Fax modem mode command       */
#define DATAPKT_FAX_CMD_FRAME_COMPLETE  2   /* Close in-progress HDLC frame */
#define DATAPKT_FAX_CMD_DELAY           3   /* Delay processing of next msg */
#define DATAPKT_FAX_CMD_SYNC_REQ        4   /* Request sync acknowledgement */
#define DATAPKT_FAX_CMD_TONE_ON         5   /* Start tone generation        */
#define DATAPKT_FAX_CMD_TONE_OFF        6   /* Stop tone generation         */
#define DATAPKT_FAX_CMD_FILL_PATTERN    7   /* Modem underrun fill pattern  */
#define DATAPKT_FAX_CMD_DATA            8   /* Data to be modulated         */

/****************************************************************************/
/*              Fax Status Message IDs                                      */
/****************************************************************************/

#define DATAPKT_FAX_STATUS_PREAMBLE_DET 1   /* V.21 Flag detection          */
#define DATAPKT_FAX_STATUS_CARRIER_DET  2   /* Carrier detected             */
#define DATAPKT_FAX_STATUS_CARRIER_LOSS 3   /* Carrier loss detectected     */
#define DATAPKT_FAX_STATUS_TEP_DET      4   /* TEP tone detected            */
#define DATAPKT_FAX_STATUS_HS_TRAIN_DET 5   /* High-speed training detected */
#define DATAPKT_FAX_STATUS_FRAME_COMPL  6   /* End of current HDLC frame    */
#define DATAPKT_FAX_STATUS_SYNC_ACK     7   /* Sync acknowledgement         */
#define DATAPKT_FAX_STATUS_DATA         8   /* Demodulated data             */

/****************************************************************************/
/*              Fax Message Parameters                                      */
/****************************************************************************/

/* Fax Mode Command Parameters */
#define DATAPKT_FAX_MODE_BO_CMDBITS     0   /* Mode cmd bits byte offset    */
#define DATAPKT_FAX_MODE_HDLC_ON        0x80/* HDLC on mask                 */
#define DATAPKT_FAX_MODE_TEP_ON         0x40/* TEP on mask                  */
#define DATAPKT_FAX_MODE_LONG_TR        0x20/* long train mask              */
#define DATAPKT_FAX_MODE_RX_DIR         0x10/* Rx direction                 */
#define DATAPKT_FAX_MODE_TX_DIR         0x08/* Tx direction                 */
#define DATAPKT_FAX_MODE_IDLE           0x00/* Set modem to idle            */

#define DATAPKT_FAX_MODE_BO_MOD         1   /* Modulation byte offset       */
#define DATAPKT_FAX_MODE_MOD_V21_300    0   /* V.21 300 bps modulation      */
#define DATAPKT_FAX_MODE_MOD_V27_2400   1   /* V.27 2400 bps modulation     */
#define DATAPKT_FAX_MODE_MOD_V27_4800   2   /* V.27 4800 bps modulation     */
#define DATAPKT_FAX_MODE_MOD_V29_7200   3   /* V.29 7200 bps modulation     */
#define DATAPKT_FAX_MODE_MOD_V29_9600   4   /* V.29 9600 bps modulation     */
#define DATAPKT_FAX_MODE_MOD_V17_7200   5   /* V.17 7200 bps modulation     */
#define DATAPKT_FAX_MODE_MOD_V17_9600   6   /* V.17 9600 bps modulation     */
#define DATAPKT_FAX_MODE_MOD_V17_12000  7   /* V.17 12000 bps modulation    */
#define DATAPKT_FAX_MODE_MOD_V17_14400  8   /* V.17 14400 bps modulation    */

/* Frame Complete Command/Detection Parameters */
#define DATAPKT_FAX_FRAME_COMP_GOOD     0   /* End frame with good CRC      */
#define DATAPKT_FAX_FRAME_COMP_BAD      1   /* End frame with bad CRC       */

/* Tone On Command Parameters */
#define DATAPKT_FAX_TONE_ON_CED         0   /* Generate CED tone            */
#define DATAPKT_FAX_TONE_ON_CNG         1   /* Generate CNG tone            */

#endif  /* _FMTYPES_INCLUDED */
/* nothing after this point */
