#ifndef _PVPHEAD_INCLUDED
#define _PVPHEAD_INCLUDED
/******************************************************************************
 * FILE PURPOSE: Generic PVP header definitions.
 ******************************************************************************
 * FILE NAME:  pvphead.h 
 *
 * DESCRIPTION: Contains definitions and macros that deal with a generic PVP
 *              header.
 *
 * TABS: NONE
 *
 * $Id: pvphead.h 1.2 1998/04/09 19:38:59 lmirantes Exp $
 *
 * REVISION HISTORY:
 *
 * $Log: pvphead.h $
 * Revision 1.2  1998/04/09 19:38:59  lmirantes
 * Revision 1.1  1997/03/19 21:44:19  ffruth
 * Initial revision
 *
 * (C) Copyright 1997, Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

/*  -----------------------------------------------    */
/*     Generic PVP header and footer definitions       */
/*  -----------------------------------------------    */

/* PVP Generic Voice Packet Overhead  */
#define PVP_VOXPKT_HEADSIZE    8   /*  8 bytes of header  */
#define PVP_VOXPKT_FOOTSIZE    0   /*  0 bytes of footer  */

/* Byte offsets within the generic voice packet header  */
#define PVP_VOXHEAD_FLAGS      0
#define PVP_VOXHEAD_NUMDRP     1
#define PVP_VOXHEAD_NUMSTLDRP  2
#define PVP_VOXHEAD_SEQNUM     3
#define PVP_VOXHEAD_NOISE      4
#define PVP_VOXHEAD_RSRVD1     5
#define PVP_VOXHEAD_RSRVD2     6
#define PVP_VOXHEAD_RSRVD3     7

/*  The first header byte contains several bits  */
#define PVP_VOXHEAD_FBIT       0  /* "1" for first packet of a talk spurt */
#define PVP_VOXHEAD_MBIT       1  /* "1"- more packets to follow, "0"- last packet */
#define PVP_VOXHEAD_CBIT       2  /* "1"- complete VIF, "0" incomplete VIF  */
#define PVP_VOXHEAD_EBIT       3  /* "1"- enhancement packet, "0"- core or  */
                                  /*  (core+enhancement) packet             */
/* NOTE: C=1 and E=1 is an illegal combination   */

#define PVP_VOXHEAD_FBITM    0x01  /* masks for the first byte of flags  */
#define PVP_VOXHEAD_MBITM    0x02  
#define PVP_VOXHEAD_CBITM    0x04
#define PVP_VOXHEAD_EBITM    0x08

/* Generic packet sequence number is modulo-16  */
#define PVP_VSEQ_MASK   0x0F


#endif  /* _PVPHEAD_INCLUDED */
/* nothing after this point */
