#ifndef _VBMICDSP_INCLUDED
#define _VBMICDSP_INCLUDED
/******************************************************************************
 * FILE PURPOSE: Defines MIC-DSP Voice Data Buffer Structures
 *
 ******************************************************************************
 * FILE NAME:   vbmicdsp.h
 *
 * DESCRIPTION: Defines voice data buffer structure which is used to pass
 *              generic voice packet between MIC and DSP.
 *
 *              NOTE 1: Both DSP and MIC use this file.
 *              NOTE 2: All sizes are in 16-bit words.
 *
 * REQUIRES:  micdspsh.h - Both DSP and MIC have their own separate file which 
 *                         defines data types shared between MIC and DSP.
 *                         Must define the following data type:
 *                              dprword: an unsigned 16-bit integer
 *            micdspdp.h (DPR data types)
 *
 * TABS: NONE
 *
 * $Id: vbmicdsp.h 2.2.1.2 1998/09/25 10:02:52 qsu Exp $
 *
 * REVISION HISTORY:
 *
 * $Log: vbmicdsp.h $
 * Revision 2.2.1.2  1998/09/25 10:02:52  qsu
 * - For high density test. Option of linear or circular buffering in DPR added.
 * Revision 2.2.1.1  1998/09/21 08:57:38  qsu
 * - For high density test. New HPI.
 * Revision 2.2  1998/02/05 20:32:30  ffruth
 * - Changed max packets to 5.
 * Revision 2.1  1998/01/13 14:55:41  BOGDANK
 *     - packet count limit changed
 *    Max packet count changed.
 * Revision 2.0  1997/06/14 16:04:25  ORENE
 * Revision 1.3  1997/05/11  07:06:06  wchung
 * Made local and offnet call.
 *
 * Revision 1.1  1997/03/20 17:06:07  ffruth
 * Initial revision
 *
 *
 * (C) Copyright 1997, Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

  /* defines dprword */
#include <ti/mas/iface/ifeco/micdspdp.h>

/* Dummy Define for a Micro Macro */
#ifndef TNI_ATTR_PACK
#define TNI_ATTR_PACK
#endif

/* Access codes for the Echo field */
#define VDB_BUSY    0
#define VDB_IDLE    1

/* Overall structure of MIC-DSP Voice Data Buffers. It is composed of a
 *  header and a payload. The payload is described in the MIC-DSP ICD. */

/* Max and Min number of packets in the buffer (pktcnt) */
#define VDB_MINPKTCNT   1
#define VDB_MAXPKTCNT   5

/* Voice Data Buffer Header */
struct vdbHeader_stc {
  dprword echo;
  dprword length;
  dprword chnum;
  dprword pktcnt;
} TNI_ATTR_PACK;
typedef struct vdbHeader_stc  vdbHeader_t;

#define VDB_HEADER_SIZE    4  /* Header size in dprword's */
/* Payload Size in dprword's */
#define VDB_PAYLOAD_MAXSIZE    (DPR_VOXBUF_SIZE - VDB_HEADER_SIZE)

/* Voice Data Buffer */
struct vdb_stc {
  vdbHeader_t  header;
  dprword      payload[VDB_PAYLOAD_MAXSIZE];
} TNI_ATTR_PACK;
typedef struct vdb_stc  vdb_t;

/* Voice Data Buffer Header */
struct vdbHeaderFifo_stc {
  dprword length;
  dprword chnum;
  dprword pktcnt;
} TNI_ATTR_PACK;
typedef struct vdbHeaderFifo_stc  vdbHeaderFifo_t;

#define VDB_HEADER_SIZE_FIFO    3  /* Header size in dprword's for FIFO memory partition */

/* Voice Data Buffer */
struct vdbFifo_stc {
  vdbHeaderFifo_t  header;
  dprword          payload[VDB_PAYLOAD_MAXSIZE];
} TNI_ATTR_PACK;
typedef struct vdbFifo_stc  vdbFifo_t;

#endif  /* _VBMICDSP_INCLUDED */
/* nothing after this point */
