#ifndef _VCTYPES_H
#define _VCTYPES_H
/******************************************************************************
 * FILE PURPOSE: Generic Voice Coding Types.
 ******************************************************************************
 * FILE NAME:   vctypes.h
 *
 * DESCRIPTION: Contains definitions for the generic voice coding types.
 *              Defines VCT_ and EVCT_ constants.
 *
 *              NOTE: This file may be used by both Micro and DSP software.
 *
 * TABS: NONE
 *
 * $Id: vctypes.h 1.11 1999/11/19 22:56:56 DThomas Exp $
 *
 * REVISION HISTORY:
 *
 * $Log: vctypes.h $
 * Revision 1.11  1999/11/19 22:56:56  DThomas
 *  - Added GSM EFR.
 * Revision 1.10  1999/08/08 16:23:27  DThomas
 *  - Added voice type for G.729E.
 * Revision 1.9  1998/12/07 23:41:46  gsisli
 *   EVCT_G729AB and EVCT_G729A are both 0x44.
 * Revision 1.8  1998/11/06 22:43:31  gsisli
 *   G729AB is added as a new EVCT.
 * Revision 1.7  1997/09/03 16:03:48  BONAL
 *     G723 numbers are increased to have more space in between 
 *     definitions. 
 *     Some comment bug corrected.
 * Revision 1.6  1997/08/19 13:58:06  BONAL
 *    G.723 types corrected.
 * Revision 1.5  1997/08/19 13:54:55  BONAL
 *    Voice coding type for G.723 is added.
 * Revision 1.4  1997/05/12 10:35:14  bogdank
 *     - CSACELP types changed to G729
 *    CSACELP types changed to G729.
 * Revision 1.3  1997/01/30 12:31:04  BOGDANK
 *     - adding more CS-ACELP coding types, specifying better data/modem types
 *    Adding additional coding types for G.729.
 * Revision 1.2  1996/09/12 13:56:58  BOGDANK
 *    Adding EVCT_DATA for transparent mode PCM (data).
 * Revision 1.1  1996/09/10 10:58:01  BOGDANK
 * Initial revision
 *    Obtained from vctypes.h (1.5) in cominc.pj.
 *
 * (C) Copyright 1995, 1996, Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

/*--------------------------------------------------*/
/* Voice Coding Types (Figure 5/G.764) ('000nnnnn') */
/*--------------------------------------------------*/

/* Codings that are not listed are reserved for future use. */
#define EVCT_INVALID        0xFFu   /* Invalid Codec - used for initialization */
#define VCT_8BITS           0x00u   /* 8 bits/sample */
#define VCT_1BITS           0x01u   /* 1 bit/sample  */
#define VCT_2BITS           0x02u   /* 2 bits/sample */
#define VCT_3BITS           0x03u   /* 3 bits/sample */
#define VCT_4BITS           0x04u   /* 4 bits/sample */
#define VCT_5BITS           0x05u   /* 5 bits/sample */
#define VCT_6BITS           0x06u   /* 6 bits/sample */
#define VCT_7BITS           0x07u   /* 7 bits/sample */

#define VCT_8APCM           0x08u   /* 8 bit A-law PCM */
#define VCT_8MUPCM          0x09u   /* 8 bit mu-law PCM */
#define VCT_2ADPCM          0x0Au   /* 2 bits/sample ADPCM (G.726) */
#define VCT_3ADPCM          0x0Bu   /* 3 bits/sample ADPCM (G.726) */
#define VCT_4ADPCM          0x0Cu   /* 4 bits/sample ADPCM (G.726) */
#define VCT_5ADPCM          0x0Du   /* 5 bits/sample ADPCM (G.726) */

/* These codecs types specifies a Most Significant bits first packing. 
 * Mainly to be used with RTP when required packing is MS-First */
#define VCT_2ADPCM_MSBF     0x0Eu   /* 2 bits/samp ADPCM with MS-first packing */
#define VCT_3ADPCM_MSBF     0x0Fu   /* 3 bits/samp ADPCM with MS-first packing */
#define VCT_4ADPCM_MSBF     0x10u   /* 4 bits/samp ADPCM with MS-first packing */
#define VCT_5ADPCM_MSBF     0x11u   /* 5 bits/samp ADPCM with MS-first packing */

#define VCT_E4_2ADPCM       0x14u   /* (4,2) embedded ADPCM (G.727) */
#define VCT_E5_2ADPCM       0x15u   /* (5,2) embedded ADPCM (G.727) */

/*---------------------------------------------------------------------*/
/* Extended Voice Coding Types (Fax, Modem, Voice Coders not in G.764) */
/*---------------------------------------------------------------------*/

/* Voice Types ('010nnnnn') */
#define EVCT_LDCELP_16K     0x42u       /* LD-CELP 16K (G.728) */
#define EVCT_G729           0x43u       /* CS-ACELP 8K (G.729) */
#define EVCT_CSACELP        EVCT_G729   /* obsolete! do not use it! */
#define EVCT_G729A          0x44u       /* CS_ACELP 8K (G.729A) */
#define EVCT_G729AB         0x44u       /* CS_ACELP 8K with int. vad (G.729AB)*/
#define EVCT_G729E          0x45u       /* CS_ACELP 11.8K (G.729E) */
#define EVCT_G729G          EVCT_G729E  /* CS_ACELP 11.8K (G.729E) */
#define EVCT_E2_2ADPCM      0x48u       /* (2,2) embedded ADPCM (G.727) */
#define EVCT_E3_2ADPCM      0x49u       /* (3,2) embedded ADPCM (G.727) */
#define EVCT_GSMEFR         0x4Au       /* GSM EFR                      */
#define EVCT_GSMFR          0x4Bu       /* GSM FR                       */
#define EVCT_GSMHR          0x4Cu       /* GSM HR                      */
#define EVCT_G723_53        0x50u       /* G.723 at 5.3 kbits/s */
#define EVCT_G723_63        0x51u       /* G.723 at 6.3 kbits/s */

#define VCT_E8_6ADPCM       0x60u       /* ADPCM (G.722) at 64 Kbps */
#define VCT_E7_5ADPCM       0x61u       /* ADPCM (G.722) at 56 Kbps */
#define VCT_E6_4ADPCM       0x62u       /* ADPCM (G.722) at 48 Kbps */
#define EVCT_GSMAMR         0x63u
#define EVCT_GSM_WBAMR      0x64u
#define EVCT_EVRCFULL       0x70u       /* EVRC full rate (9.6 Kbps) */
#define EVCT_SMV            0x71u       /* SMV  */ 
#define EVCT_EVRCHALF       0x72u	    
#define EVCT_QCELP13        0x73u
#define EVCT_FR_AMR	    0x74u
#define EVCT_HR_AMR	    0x75u
#define EVCT_UMTS_AMR       0x76u
/*#define EVCT_UMTS_AMR_2   0x77u */
#define EVCT_UMTS_AMR_2     EVCT_GSMAMR /* Currently UMTS AMR 2 is GSM AMR */
#define EVCT_OHR_AMR        0x78u
#define EVCT_EVRCB          0x79u       /* EVRC-B Codec */
      
/* Fax Types ('1000nnnn') */
#define EVCT_FAX            0x80u       /* Fax */

/* Data Types ('1001nnnn') */
#define EVCT_DATA           0x90u   /* Data - transparent 8-bit PCM */

/* TEMPORARY PCM codec type for a channel that uses G711 Appendix 1 and 2 
 * TODO: This codec type should be deleted when mips agent changes are done.
 *       Mips agent should be changed to be independent of codec and PLC/NMU
 *       usage, and just get a peak mips number. 
 *       CORE should remove this codec type. */ 
#define VCT_PCM_APX_1_2     0xA0u 

/* Modem Relay Types ('1011nnnn') */
#define EVCT_MRU            0xB2u   /* Modem Relay Unit */
#define EVCT_LLMR           0xB7u   /* Link Layer Modem Relay */

/* Modem Types ('1011nnnn') */
#define EVCT_DATAMDM        0xB0u   /* Data Modem */

/* Non ITU Types ('1100nnnn') */
#define EVCT_CSACELP_IS641  0xC1u   /* CS-ACELP 8K (TIAEIA IS641) */
#define EVCT_ILBC_RATE_20MS 0xCBu   /* ILBC at 15.2 kbits/s */
#define EVCT_ILBC_RATE_30MS 0xCCu   /* ILBC at 13.33 kbits/s */

/* Audio Codec types1101nnnn*/
#define EADT_TRANSPARENT_DATA     0xD0u
#define EADT_MP3                  0xD1u   /* MP3 */

/* TELOGY Types ('111nnnnn') */
#define EVCT_GEN_SID        0xE0u   /* Generic SID for AAL2 Profile */
#define EVCT_TOIP           0xE8u   /* TOIP - RFC 2793 record for RTP Profile */

/* Video Coding Type Definition
 * The coding type overlaps with voice coding type.
 * The type will be identified based on the unique message ID for
 * Voice Vs Video
 */
#define EVCT_VIDEO_H264BP_ENC     0x01    /* H.264 Baseline Profile Encoder */
#define EVCT_VIDEO_H264BP_MP_DEC  0x02    /* H.264 BP/MP Decoder */
#define EVCT_VIDEO_MPEG4SP_ENC    0x03    /* MPEG4 Simple Profile Encoder */
#define EVCT_VIDEO_MPEG4SP_DEC    0x04    /* MPEG4 Simple Profile Decoder */
#define EVCT_VIDEO_H263P_ENC      0x05    /* H.263+ Encoder */
#define EVCT_VIDEO_H263P_DEC      0x06    /* H.263+ Decoder */
#define EVCT_VIDEO_BYPASS_ENC     0x07    /* Bypass Encoder - YUV */
#define EVCT_VIDEO_BYPASS_DEC     0x08    /* Bypass Decoder - YUV */
#define EVCT_VIDEO_H264MP_ENC     0x09    /* H.264 Main Profile Encoder */
#define EVCT_VIDEO_FREE_AVAIL     0x0A    /* Free/Available */
#define EVCT_VIDEO_MPEG2MP_DEC    0x0B    /* MPEG-2 Main Profile Decoder */
#define EVCT_VIDEO_H264HP_DEC     0x0C    /* H.264 High Profile Decoder */
#define EVCT_VIDEO_TSU_ONLY       0x0D    /* TSU only channel which interacts with encoder/decoder on remote core(s)*/

#define EVCT_VIDEO_OVLY_RAW_GRAPHICS 0x0E  /* Uncompressed overlay graphics */
#define EVCT_VIDEO_OVLY_TEXT         0x0F  /* Text overlay                  */

/* Coding Types 0xE0 - 0xFF are reserved for customer Codecs */
#define EVCT_VIDEO_CUSTOM_CODING_TYPES_BEGIN 0xE0u
#define EVCT_VIDEO_CUSTOM_CODING_TYPES_END   0xFFu

/* Audio Codec Types that are used to suppliment a video channel */
#define EVCT_AUDIO_NONE           0x00u
#define EVCT_AUDIO_MP3_DEC        0x01u
#define EVCT_AUDIO_AAC_ENC        0x02u

#endif /* _VCTYPES_H */
/* nothing past this point */
