#ifndef __VIMGMICDSP_H__
#define __VIMGMICDSP_H__
/* ========================================================================== */
/**
 *  @file   vimgmicdsp.h
 *
 *  path    ggmicdsp\inc\vimgmicdsp.h
 *
 *  @brief  This file defines the interfaces to configure the Video Framework
 *
 *  ============================================================================
 *  Copyright (c) Texas Instruments Incorporated 2002-2008
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#include <ti/mas/iface/ifeco/mgdefs.h>
#include <ti/mas/iface/ifovly/ifovly.h>
#include <ti/mas/iface/ifvppu/ifvppu.h>

/* Dummy Define for a Micro Macro */
#ifndef TNI_ATTR_PACK
#define TNI_ATTR_PACK
#endif

/*****************************************************************
 ** Messages 4225 to 4352 are reserved for Video                **
 *****************************************************************/
#define MGB_MD_VIDEO_MODE                       4225
#define MGB_MD_VIDEO_CODEC_GEN_CFG              4226
#define MGB_MD_VIDEO_OVLY_CFG                   4227
#define MGB_MD_VIDEO_CTRL                       4228
#define MGB_MD_VIDEO_SW_CFG                     4229
#define MGB_MD_VIDEO_FRC_CFG                    4230
#define MGB_MD_VIDEO_MMCU_CFG                   4231

#define MGB_MD_AUDIO_CODEC_GEN_CFG              4232

#define MGB_DM_GET_VPPU_STAT                    4250
#define MGB_DM_GET_VTK_STAT                     4251
#define MGB_DM_GET_FRC_STAT                     4252
#define MGB_DM_GET_YUV_STAT                     4253
#define MGB_MD_VIDEO_MSG_END                    4352

/*******************************************************************************************************
 * Error Indication codes
 *******************************************************************************************************/
/* Error codes 400 - 470 are reserved for Video GDK */

/* VIDEO */
#define MGB_ERR_INVD_MSG_CHST_VIDEO               400

enum {
 MGB_ERR_VIDEO_OVERLAY_CFG_MSG_REJECTED   = 401,
 MGB_ERR_VIDEO_MODE_MSG_REJECTED          = 402,
 MGB_ERR_VIDEO_CODEC_GEN_CFG_MSG_REJECTED = 403,
 MGB_ERR_VIDEO_CODEC_STATIC_CFG_REJECTED  = 404,
 MGB_ERR_VIDEO_CODEC_DYNAMIC_CFG_REJECTED = 405,
 MGB_ERR_VIDEO_CODEC_SPROP_PARAM_REJECTED = 406,
 MGB_ERR_VIDEO_INVALID_CODING_TYPE        = 407,
 MGB_ERR_VIDEO_INVD_CONNECT_REQUEST       = 408,
 MGB_ERR_VIDEO_INVD_STATS_REQUEST         = 409,
 MGB_ERR_INVALID_VIDEO_SW_CONFIG          = 410,
 MGB_ERR_VIDEO_CTRL_REJECTED              = 411,
 MGB_ERR_VIDEO_INVALID_MAX_PAYLOAD_SIZE   = 412,
 MGB_ERR_VIDEO_INVALID_TFTP_CONFIG        = 413,
 MGB_ERR_VIDEO_INVALID_MMCU_CONFIG        = 414,
 MGB_ERR_VIDEO_INVALID_MC_NCORES          = 415,
 MGB_ERR_VIDEO_MMCU_CFG_NOT_DONE          = 416,
 MGB_ERR_AUDIO_CODEC_STATIC_CFG_REJECTED  = 417,
 MGB_ERR_AUDIO_CODEC_DYNAMIC_CFG_REJECTED = 418
};

/***************** ifvtk_VIDEO_CODEC_GEN_CFG **********************************/
/*******************************************************************************
 * Description: ifvtk_VIDEO_CODEC_GEN_CFG Video Encoder/Decoder Generic Codec 
 *              Configuration parameters.
 *               The actual parameter values will vary based on individual
 *              Codec. Refer the Codec Interface file [TBD].The static
 *              configuration for CODEC would need to be sent only once after
 *              channel has transitioned to VIDEO mode while dynamic configuration  
 *              
 *              Note: if cfgType is ifvtk_VIDEO_CODEC_GEN_CFG_SPROP_PARAM the content
 *                    of cfgParam will be assumed to be a byte array. In all other cases
 *                    the content of cfgParam needs to be in 32 bit DSP endian
 *                    format
 ******************************************************************************/
struct ifvtk_VIDEO_CODEC_GEN_CFG{
    tuint                      cfgType;
#define ifvtk_VIDEO_CODEC_GEN_CFG_STATIC          1
#define ifvtk_VIDEO_CODEC_GEN_CFG_DYNAMIC         2
#define ifvtk_VIDEO_CODEC_GEN_CFG_SPROP_PARAM     3

    tuint                      numWords;
#define ifvtk_MAX_VIDEO_CODEC_CFG_LEN             128

    tuint                      cfgParam[ifvtk_MAX_VIDEO_CODEC_CFG_LEN];
}TNI_ATTR_PACK;

/***************** ifatk_AUDIO_CODEC_GEN_CFG **********************************/
/*******************************************************************************
 * Description: ifatk_AUDIO_CODEC_GEN_CFG Audio Encoder/Decoder Generic Codec 
 *              Configuration parameters.
 *               The actual parameter values will vary based on individual
 *              Codec. Refer the Codec Interface file [TBD].The static
 *              configuration for CODEC would need to be sent only once after
 *              channel has transitioned to VIDEO mode while dynamic configuration  
 *              
 *              Note: if cfgType is ifvtk_VIDEO_CODEC_GEN_CFG_SPROP_PARAM the content
 *                    of cfgParam will be assumed to be a byte array. In all other cases
 *                    the content of cfgParam needs to be in 32 bit DSP endian
 *                    format
 ******************************************************************************/
struct ifatk_AUDIO_CODEC_GEN_CFG{
    tuint                      cfgType;
#define ifatk_AUDIO_CODEC_GEN_CFG_STATIC          1
#define ifatk_AUDIO_CODEC_GEN_CFG_DYNAMIC         2

    tuint                      numWords;
#define ifatk_MAX_AUDIO_CODEC_CFG_LEN             128

    tuint                      cfgParam[ifatk_MAX_AUDIO_CODEC_CFG_LEN];
}TNI_ATTR_PACK;

/***************** MGB_MD_VIDEO_MODE ******************************************/
/*******************************************************************************
 * Description: MGB_MD_VIDEO_MODE message definition. Channel will be configured 
 *              based on the defIndex and codingPayloadType defined in 
 *              MGB_MD_VIDEO_PROFILE_DEFINE  message
 ******************************************************************************/
struct MGB_MDS_VIDEO_MODE {
  tuint                                validParams;
#define     MGB_MDS_VIDEO_MODE_VALID_RTP_CLOCK_RATE         0x0001
#define     MGB_MDS_VIDEO_MODE_VALID_YUV_REORDER_DEPTH      0x0002
#define     MGB_MDS_VIDEO_MODE_VALID_MAX_PAYLOAD_SIZE       0x0004
#define     MGB_MDS_VIDEO_MODE_VALID_MC_NCORES              0x0008
  tuint                                codingType;
                                                /* Coding type
                                                 *              See EVCT_VIDEO_XXX for 
                                                 *              valid Video Coding Type
                                                 */
  
  tuint                                payloadType;/* RTP Payload type */
  tuint                                imgWidth; /* TBD */
  tuint                                imgHeight;/* TBD */
  tuint                                rtpClockRate;
                                                        /* (Optional) Resolution of timestamp 
                                                         * field in the RTP header. 
                                                         * Default value if not configured
                                                         * is 90Khz
                                                         */
  tuint                                yuvReorderDepth; 
#define MGB_MDS_VIDEO_MODE_MIN_YUV_REORDER_DEPTH    3
#define MGB_MDS_VIDEO_MODE_MAX_YUV_REORDER_DEPTH    16
  tuint                                maxPayloadSize;  /* Max Video Payload size can be configured for TX
                                                           (to-network) direction
                                                         */

#define MGB_MDS_VIDEO_MODE_MAX_NUM_CORES            16
  tuint                                nCores;            /* Number of cores participating multi-core encoding
                                                            or multi-core decoding */
  tuint                                coreTeamMapping[MGB_MDS_VIDEO_MODE_MAX_NUM_CORES];/* Core IDs in multi-core encoding/decoding.
                                                             The first core ID is for the master core. */
  tuint                                chanIdOnCores[MGB_MDS_VIDEO_MODE_MAX_NUM_CORES];  /* Channel IDs on participating cores */
} TNI_ATTR_PACK;


/***************** MGB_MD_VIDEO_CTRL ******************************************/
/*******************************************************************************
 * Description: MGB_MD_VIDEO_CTRL message definition. Additional Video channel 
 *              configuration from what is controlled through VIDEO_MODE. These
 *              additional configuration can be received at anypoint after VIDEO_MODE
 *              message is received at the DSP
 ******************************************************************************/
struct MGB_MDS_VIDEO_CTRL {
  tuint                                validParams;
#define     MGB_MDS_VIDEO_CTRL_VALID_SPROP_TX_CFG              0x0001

  tuint                                spropTxCfg;     
#define     MGB_MDS_VIDEO_CTRL_SPROP_TX_CFG_REPEAT_NONE        0x1     /* SPROP/SPARAM send only once */
#define     MGB_MDS_VIDEO_CTRL_SPROP_TX_CFG_REPEAT_IFRAME      0x2     /* Repeat SPROP/SPARAM
                                                                        * every IFRAME
                                                                        */
} TNI_ATTR_PACK;

/***************** MGB_MD_VIDEO_SW_CFG ******************************************/
/*******************************************************************************
 * Description: MGB_MD_VIDEO_SW_CFG message definition. 
 ******************************************************************************/
struct MGB_MDS_VIDEO_SW_CFG {
  tuint                                validParams;
#define     MGB_MDS_VIDEO_SW_CFG_VALID_RES_CLASS       0x0001

  tuint                                resClass;
                                                /* Build ID based on the resolution
                                                 * configuration
                                                 */
#define     MGB_MDS_VIDEO_SW_CFG_RES_CLASS_LOW       0x0001 /* Configure support for 
                                                             * max CIF resolution in 
                                                             * the build 
                                                             */

#define     MGB_MDS_VIDEO_SW_CFG_RES_CLASS_SD        0x0002 /* Configure support for 
                                                             * max SD (D1) resolution in 
                                                             * the build 
                                                             */
#define     MGB_MDS_VIDEO_SW_CFG_RES_CLASS_MC        0x0003 /* Configure support for 
                                                             * multi-core encoder/decoder in 
                                                             * the build 
                                                             */
} TNI_ATTR_PACK;

/***************** MGB_MD_VIDEO_MMCU_CFG ******************************************/
/*******************************************************************************
 * Description: MGB_MD_VIDEO_MMCU_CFG message definition. 
 ******************************************************************************/
/* TBD: Enhance to enable stream selection */
struct MGB_MDS_VIDEO_MMCU_CFG {
  tuint             validParams;
#define     MGB_MDS_VIDEO_MMCU_CFG_VALID_CONTAINER       0x0001
#define     MGB_MDS_VIDEO_MMCU_CFG_VALID_STREAM_ID       0x0002
  tuint             container;
#define     MGB_MDS_VIDEO_MMCU_CONTAINER_AVI              0
#define     MGB_MDS_VIDEO_MMCU_CONTAINER_MOV              1
#define     MGB_MDS_VIDEO_MMCU_CONTAINER_MPEGTS           2
  tuint             stream_id;                         /* stream-id selection */
} TNI_ATTR_PACK;

/***************** MGB_MD_VIDEO_FRC_CFG ******************************************/
/*******************************************************************************
 * Description: MGB_MD_VIDEO_FRC_CFG message definition. 
 ******************************************************************************/
struct MGB_MDS_VIDEO_FRC_CFG {
  tuint                                validParams;
#define     MGB_MDS_VIDEO_FRC_CFG_VALID_MODE   0x0001

  tuint                                mode;         /* Frame Rate Control operation mode */
#define     MGB_MDS_VIDEO_FRC_CFG_MODE_DISABLE      0 /* Frame rate control feature is disabled */
                                                      /* Decoder leg frame always triggers encoder leg procesing */
#define     MGB_MDS_VIDEO_FRC_CFG_MODE_RTP_TS       1 /* Frame rate control enabled */
                                                      /* Frame rate algorithm is driven using RTP timestamps */
                                                      /* and configured decoder and encoder frame rates      */
#define     MGB_MDS_VIDEO_FRC_CFG_MODE_TRACK_INPUT  2 /* Output frame rate tracks input rate but does not exceed provisioned */
                                                      /* Frame dropping, done by FRC, is possible */
                                                      
                                                      /* Frame rate algorithm is driven using RTP timestamps */
                                                      /* and configured decoder and encoder frame rates      */
} TNI_ATTR_PACK;
/***************** ifvtk_GET_STAT ***************************************/
/*******************************************************************************
 * Description: These structures defines the statistics which can be retrieved
 *              from VTK module
 ******************************************************************************/

/******************************************************************************
 * VTK RX Statistics definition: This will be valid for Decoder Video CODEC
 * channel and will represent statistics from network to decoder.
 *****************************************************************************/
struct ifvtk_GET_RX_STAT {
   tuint                   codingType;         /* Will indicate current Decoder for
                                                 * RX statistics or Enoder for TX 
                                                 * statistics
                                                 */
   tuint                   imgWidth;           /* Image Width */
   tuint                   imgHeight;          /* Image Height */
   tuint                   numIframesMSW;      /* received I-frames */
   tuint                   numIframesLSW;      /* received I-frames */
   tuint                   numPframesMSW;      /* received P-frames */
   tuint                   numPframesLSW;      /* received P-frames */
   tuint                   numBframesMSW;      /* received B-frames */
   tuint                   numBframesLSW;      /* received B-frames */
   tuint                   maxIframeSizeMSW;   /* maximum I-frame size */
   tuint                   maxIframeSizeLSW;   /* maximum I-frame size */
   tuint                   maxPframeSizeMSW;   /* maximum P-frame size */
   tuint                   maxPframeSizeLSW;   /* maximum P-frame size */
   tuint                   maxBframeSizeMSW;   /* maximum B-frame size */
   tuint                   maxBframeSizeLSW;   /* maximum B-frame size */
   tuint                   numDecBytesMSW;     /* number of bytes decoder consumed */
   tuint                   numDecBytesLSW;     /* number of bytes decoder consumed */
   tuint                   bitRateMSW;         /* estimated RX average bps (Q4) */
   tuint                   bitRateLSW;         /* estimated RX average bps (Q4) */
   tuint                   lastGOP;            /* last inter I-frames gap (last GOP) */


   tuint                   numErrFramesMSW;    /* counter of undecodable frames */
   tuint                   numErrFramesLSW;    /* counter of undecodable frames */
   tuint                   decLastErrCodeMSW;  /* extended errors, decoder dependent */
   tuint                   decLastErrCodeLSW;  /* extended errors, decoder dependent */
}TNI_ATTR_PACK;

/******************************************************************************
 * VTK TX Statistics definition: This will be valid for Encoder Video CODEC
 * channel and will represent statistics from encoder to network.
 *****************************************************************************/
struct ifvtk_GET_TX_STAT 
{    
   tuint                   codingType;         /* Will indicate current Decoder for
                                                 * RX statistics or Enoder for TX 
                                                 * statistics
                                                 */
   tuint                   imgWidth;           /* Image Width */
   tuint                   imgHeight;          /* Image Height */
   tuint                   numIframesMSW;      /* Transmitted I-frames */
   tuint                   numIframesLSW;      /* Transmitted I-frames */
   tuint                   numPframesMSW;      /* Transmitted P-frames */
   tuint                   numPframesLSW;      /* Transmitted P-frames */
   tuint                   numBframesMSW;      /* Transmitted B-frames */
   tuint                   numBframesLSW;      /* Transmitted B-frames */
   tuint                   maxIframeSizeMSW;   /* maximum I-frame size */
   tuint                   maxIframeSizeLSW;   /* maximum I-frame size */
   tuint                   maxPframeSizeMSW;   /* maximum P-frame size */
   tuint                   maxPframeSizeLSW;   /* maximum P-frame size */
   tuint                   maxBframeSizeMSW;   /* maximum B-frame size */
   tuint                   maxBframeSizeLSW;   /* maximum B-frame size */
   tuint                   numEncBytesMSW;     /* number of encoded bytes */ 
   tuint                   numEncBytesLSW;     /* number of encoded bytes */ 
   tuint                   bitRateMSW;         /* estimated TX average bps (Q4) */
   tuint                   bitRateLSW;         /* estimated TX average bps (Q4) */
   tuint                   skippedFramesMSW;   /* skipped frames due to rate control */
   tuint                   skippedFramesLSW;   /* skipped frames due to rate control */
   tuint                   lastGOP;            /* last inter I-frames gap (last GOP) */
   tuint                   numErrFramesMSW;    /* counter of unencodable frames */
   tuint                   numErrFramesLSW;    /* counter of unencodable frames */
   tuint                   encLastErrCodeMSW;  /* extended errors, encoder dependent */
   tuint                   encLastErrCodeLSW;  /* extended errors, encoder dependent */
}TNI_ATTR_PACK;


typedef tuint  ifvtk_STAT_TYPE;
#define ifvtk_GET_STAT_TYPE_RX             0x1 /* RX: Decoder VTK channel */
#define ifvtk_GET_STAT_TYPE_TX             0x2 /* TX: Encoder VTK channel */
/******************************************************************************
 * VTK Statistics definition:
 *****************************************************************************/
union ifvtk_GET_STAT_INFO{
       struct ifvtk_GET_RX_STAT      rx;
       struct ifvtk_GET_TX_STAT      tx;
 }TNI_ATTR_PACK;

struct ifvtk_GET_STAT {
   ifvtk_STAT_TYPE            vtkType;      /* Identifies the type of VTK channel. 
                                             * If vtk_type is MGB_DMS_GET_VTK_TYPE_RX_T
                                             *      channel is configured as decoder and
                                             *      rx statistics will be valid
                                             * 
                                             * If vtk_type is MGB_DMS_GET_VTK_TYPE_TX_T
                                             *      channel is configured as encoder and
                                             *      tx statistics will be valid
                                             */
   union ifvtk_GET_STAT_INFO  info;   /* Statistics information depending on type */

}TNI_ATTR_PACK;

/******************************************************************************
 * FRC Statistics definition:
 *****************************************************************************/
struct iffrc_GET_STAT {
  tuint outputFrameRate;                  /* Output Frame Rate */
  tuint numFramesDroppedMSW;              /* Number of dropped frames */
  tuint numFramesDroppedLSW;   
  tuint numFramesRepeatedMSW;             /* Number of repeated frames */
  tuint numFramesRepeatedLSW;
  tuint numFramesUsedMSW;                 /* Number of frames consumed (passed through) */
  tuint numFramesUsedLSW;
} TNI_ATTR_PACK;

/******************************************************************************
 * YUV Statistics definition:
 *****************************************************************************/
struct ifyuv_GET_STAT {
  tuint yuvWidth;             
  tuint yuvHeight;
  tuint yuvReorderDepth;
  tuint numDroppedFramesMSW;  /* Number of dropped frames */
  tuint numDroppedFramesLSW;  /* Number of dropped frames */
} TNI_ATTR_PACK;

#endif  /* __VIMGMICDSP_H_ */

/* nothing past this point */
