/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



#ifndef _IFMMC_H
#define _IFMMC_H
#include <ti/mas/types/types.h>
#include <ti/mas/iface/ifmmc/ifmmcosal.h>

typedef struct ifmmcDemuxOutput_s {
  tuint                 ESID;
  ifvisys_MediaType_t   mediaType;
  ifvisys_BuffDesc_t    bitStream;
  tulong                timestamp;
} ifmmcDemuxOutput_t;

typedef struct ifmmcMuxInput_s {
  tuint                 ESID;
  ifvisys_MediaType_t   mediaType;
  ifvisys_BuffDesc_t    bitStream;
  tulong                timestampIncrement;
  ifvisys_FrameType_t   frameType;
} ifmmcMuxInput_t;
  
/* ifmmc */
typedef void (*ifmmcDemuxOpenFcn_t)(void *inst, ifmmcOsalFileHandle_t inStream);

typedef void (*ifmmcDemuxCloseFcn_t)(void *inst);

typedef tint  (*ifmmcDemuxControlFcn_t)(void *inst, void *ctrl);

typedef tlong (*ifmmcDemuxGetStreamInfoFcn_t)(void *inst, void *streamInfo);

typedef tint  (*ifmmcDemuxSelectStreamFcn_t)(void *inst, tint nStreams, tint *streams);

typedef tlong (*ifmmcDemuxGetFrame_t)(void *inst, ifmmcDemuxOutput_t *demuxOutput);

typedef struct {
  ifmmcDemuxOpenFcn_t           open;
  ifmmcDemuxCloseFcn_t          close;
  ifmmcDemuxControlFcn_t        control;
  ifmmcDemuxGetStreamInfoFcn_t  getStreamInfo;
  ifmmcDemuxSelectStreamFcn_t   selectStream;
  ifmmcDemuxGetFrame_t          getFrame;
} ifmmcDemuxAPI_t;


typedef void (*ifmmcMuxOpenFcn_t)(void *inst, void *cfg);
typedef void (*ifmmcMuxCloseFcn_t)(void *inst);
typedef tint (*ifmmcMuxSendHeaderFcn_t)(void *inst);
typedef tint (*ifmmcMuxSendFrameFcn_t)(void *inst, ifmmcMuxInput_t *muxInput);
typedef tulong (*ifmmcMuxShipoutFcn_t)(void *inst);
typedef tint (*ifmmcMuxControlFcn_t)(void *inst, void *ctrl);

typedef struct {
  ifmmcMuxOpenFcn_t         open;
  ifmmcMuxCloseFcn_t        close;
  ifmmcMuxControlFcn_t      control;
  ifmmcMuxSendHeaderFcn_t   sendHeader;
  ifmmcMuxSendFrameFcn_t    sendFrame;
  ifmmcMuxShipoutFcn_t      shipout;
} ifmmcMuxAPI_t;

#define ifmmc_NULL    0
#define ifmmc_DEMUX   1
#define ifmmc_MUX     2

typedef struct {
  const char  *name;
  tulong      instSize;
  tint        op;
  union {
    ifmmcDemuxAPI_t demux;
    ifmmcMuxAPI_t   mux;
  } u;
} ifmmcAPI_t;

#endif /* _IFMMC_H */
/* nothing past this point */
