/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



#ifndef _IFMMCOSAL_H
#define _IFMMCOSAL_H

/* ifosal */
typedef void* ifmmcOsalDynMemHandle_t;
typedef void* (*ifmmcOsalDynMemAllocFcn_t)(tuint ID, ifmmcOsalDynMemHandle_t *memHandle);
typedef tbool (*ifmmcOsalDynMemFreeFcn_t)(tuint ID, ifmmcOsalDynMemHandle_t *memHandle, void *ptr);

typedef struct {
  /* Memory Management */
  ifmmcOsalDynMemHandle_t    memHandle;
  ifmmcOsalDynMemAllocFcn_t  alloc;
  ifmmcOsalDynMemFreeFcn_t   free;
} ifmmcOsalDynMemContext_t;

typedef void* ifmmcOsalFileHandle_t;

typedef ifmmcOsalFileHandle_t (*ifmmcOsalFileOpenFcn_t)(void);
typedef void  (*ifmmcOsalFileCloseFcn_t)(ifmmcOsalFileHandle_t fileHandle);
typedef void  (*ifmmcOsalFileFlushFcn_t)(ifmmcOsalFileHandle_t fileHandle);
typedef tlong (*ifmmcOsalFileReadFcn_t)(ifmmcOsalFileHandle_t fileHandle, tword *buf, tlong size);
typedef tlong (*ifmmcOsalFileWriteFcn_t)(ifmmcOsalFileHandle_t fileHandle, tword *buf, tlong size);
typedef tlong (*ifmmcOsalFilePeekFcn_t)(ifmmcOsalFileHandle_t fileHandle, tlong pos, tword *buf, tlong size);
typedef void  (*ifmmcOsalFileSkipFcn_t)(ifmmcOsalFileHandle_t fileHandle, int64_t size);
typedef tbool (*ifmmcOsalFileEofFcn_t)(ifmmcOsalFileHandle_t fileHandle);

typedef struct {
  ifmmcOsalFileOpenFcn_t   fopen;
  ifmmcOsalFileCloseFcn_t  fclose;
  ifmmcOsalFileFlushFcn_t  fflush;
  ifmmcOsalFileReadFcn_t   fread; 
  ifmmcOsalFileWriteFcn_t  fwrite;
  ifmmcOsalFilePeekFcn_t   fpeek;
  ifmmcOsalFileSkipFcn_t   fskip;
  ifmmcOsalFileEofFcn_t    feof;
}ifmmcOsalFileContext_t;


#endif /* _IFMMCOSAL_H */
/* nothing past this point */
