# ==============================================================================
# File            : Makedocs.mk
# Description     : 
#
#   GNU makefile to generate IFNMU documentation from sources using Doxygen
#
# ==============================================================================

# The target for generating documents using doxygen is gendocs

RELEASE_DOC = ./docs/doxygen/release.chm

releasenotes : $(RELEASE_DOC)

$(RELEASE_DOC): ./docs/doxygen/release.h
	-@echo generating Release Notes ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen ../../swtools/docs/doxygen/releaseDoxyfile
	@xs -f ../../swtools/release.js

IFNMU_DOC = ./docs/doxygen/IFNMU.chm

all: $(IFNMU_DOC) 

gendocs $(IFNMU_DOC): ifnmutx.h ifnmurx.h
	-@echo generating IFNMU documentation ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen ./docs/doxygen/Doxyfile

# End of Makedocs.mk
