#ifndef _IFNMURX_H_
#define _IFNMURX_H_

/**
 *  @file   ifnmurx.h
 *  @brief  Configuration interface for Noise Matching Receive (from packet)
 *
 *  (C) Copyright 2007, Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
/** @defgroup IFNMURX */
/** @ingroup IFNMURX */
/* @{ */

#include <ti/mas/types/types.h>

/** @brief Setup and Run-time configuration */
typedef struct {

#define ifnmurx_CONFIG_VALID_NOISE_MODE      0x0001 /**< valid_params: noise_mode field is valid */
#define ifnmurx_CONFIG_VALID_NOISE_LP_ORDER  0x0002 /**< valid_params: noise_lp_order field is valid */
#define ifnmurx_CONFIG_VALID_NOISE_LEVEL     0x0004 /**< valid_params: noise_level field is valid */
      tuint valid_params; /**< valid parameters bit field */

#define ifnmurx_CONFIG_NOISE_MODE_ADAPTIVE_LEVEL 0 /**< noise_mode: level is adapted based on level 
                                                  * information in the received packet, spectrum 
                                                  * information if present, is ignored 
                                                  */
#define ifnmurx_CONFIG_NOISE_MODE_FIXED_LEVEL    1 /**< noise_mode: Generate fixed noise level as 
                                                  * specified in the idle_noise level parameter, no
                                                  * matter what was received in the packet. 
                                                  */
#define ifnmurx_CONFIG_NOISE_MODE_G711A2         2 /**< noise_mode: Generate noise using level and/or 
                                                  * spectrum information in receiveed package as per
                                                  * G711 Appendix II reference algorithm.
                                                  */

#define ifnmurx_CONFIG_NOISE_MODE_LAST           2 /**< noise_mode: for error checking only, set to 
                                                  * maximum of allowable noise modes 
                                                  */
      tuint noise_mode; /**< type of algorithm for noise matching */

#define ifnmurx_CONFIG_MAX_LP_ORDER 10 /**< noise_lp_order: Maximum allowed LP order, minimum is 0 */
      tuint noise_lp_order;   /**< noise LP order for G.711 Appendix II, if receiving packet with 
                               * larger than this order, remaining coefficients (bytes) should be ignored.
                               * Should be able to handle packets containing less than this spectral coefficients.
                               */

      tint idle_noise_level;  /**< level for generating noise at fixed level 
                               * when specifying fixed level noise mode, in dBm. It is also
                               * used for Level Matching by the receiver to generate this level of noise 
                               * until it gets the first packet payload from the transmitter and it 
                               * is asked to generate noise (this is typical of a situation when
                               * a call is established.
                               */

} ifnmurxConfig_t;

/* @} */ /* ingroup */

#endif /* _IFNMURX_H_ */
/* nothing past this point */
