#ifndef _IFNMUTX_H_
#define _IFNMUTX_H_

/**
 *  @file   ifnmutx.h
 *  @brief  Configuration interface for Noise Matching Receive (from packet)
 *
 *  (C) Copyright 2007, Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
/** @defgroup IFNMUTX */
/** @ingroup IFNMUTX */
/* @{ */

#include <ti/mas/types/types.h>

/** @brief Setup and Run-time configuration */
typedef struct {

#define ifnmutx_CONFIG_VALID_NOISE_MODE      0x0001 /**< valid_params: noise_mode field is valid */ 
#define ifnmutx_CONFIG_VALID_NOISE_LP_ORDER  0x0002 /**< valid_params: noise_lp_order field is valid */
      tuint valid_params;

#define ifnmutx_CONFIG_NOISE_MODE_NONE    0 /**< noise_mode: Do not estimate noise level, the level in the 
                                           * packat is fixed low level noise determined by the algorithm 
                                           */
#define ifnmutx_CONFIG_NOISE_MODE_LEVEL   1 /**< noise_mode: Estimate level and send estimated level in the output */
#define ifnmutx_CONFIG_NOISE_MODE_G711A2  2 /**< noise_mode: Estimate level and spectrum per G.711 Appendix II reference
                                           * implementation and algorithm specific DTX logic 
                                           * (this is not specified in G.711 Appendix II)
                                           */
#define ifnmutx_CONFIG_NOISE_MODE_LAST    2 /**< noise_mode: for error checking only, set to 
                                           * maximum of allowable noise modes 
                                           */
      tuint noise_mode; /**< type of algorithm for noise matching */

#define ifnmutx_CONFIG_MAX_LP_ORDER 10 /**< noise_lp_order: Maximum allowed LP order, minimum is 0 */
      tuint noise_lp_order; /**< noise LP order for G.711 Appendix II */ 

} ifnmutxConfig_t; 

/* @} */ /* ingroup */

#endif /* _IFNMUTX_H_ */
/* nothing past this point */
