#ifndef _IFOVLY_H
#define _IFOVLY_H

/**
 *  @file   ifovly.h
 *  @brief  Configuration interface for Graphics/Text Overlay (OVLY)
 *
 *  (C) Copyright 2009, Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
/** @defgroup IFOVLY */
/** @ingroup IFOVLY */
/* @{ */

#include <ti/mas/types/types.h>

#ifndef TNI_ATTR_PACK
#define TNI_ATTR_PACK
#endif

/** @brief Setup and Run-time configuration */
struct MGB_MDS_VIDEO_OVLY_CFG {
#define MGB_VIDEO_OVLY_TYPE_PARAMS_CTRL_CODE  0x0001 /**< CTRL_CODE is valid */
#define MGB_VIDEO_OVLY_TYPE_PARAMS_X_POS      0x0002 /**< X_POS is valid */
#define MGB_VIDEO_OVLY_TYPE_PARAMS_Y_POS      0x0004 /**< Y_POS is valid */
#define MGB_VIDEO_OVLY_TYPE_PARAMS_TIMER      0x0008 /**< TIMER is valid */
#define MGB_VIDEO_OVLY_TYPE_PARAMS_YUV_FG     0x0010 /**< YUV_FG is valid */
#define MGB_VIDEO_OVLY_TYPE_PARAMS_YUV_BG     0x0020 /**< YUV_BG is valid */
#define MGB_VIDEO_OVLY_TYPE_PARAMS_CHAR_ARRAY 0x0040 /**< CHAR_ARRAY is valid */
#define MGB_VIDEO_OVLY_TYPE_PARAMS_OVLY_DEMO  0x8000 /**< OVLY_DEMO is valid */
      tuint valid_params;              /**< valid params bit mask */ 
#define MGB_VIDEO_OVLY_TYPE_RESUME  0  /**< Resume the content updating */
#define MGB_VIDEO_OVLY_TYPE_STOP    1  /**< Pause the content updating */
#define MGB_VIDEO_OVLY_TYPE_HOST    2  /**< Host will provide the text (char array) */
      tuint ctrl_code;

      tuint ovly_res_demo;             /**< Internal Reserved Demo configuration
                                         * valid only when API is called for
                                         * a video encoder channels and not
                                         * dedicated overlay channels
                                         * Bits 0-3: 
                                         *      Value 0x0: Disable all the features
                                         *            0x1: Display Texas Instruments
                                         *            0x2: Display TI LOGO
                                         *            0x4: Draw diag line across display 
                                         *            0x8: Display Core anc CHannel ID                                         
                                         */

#define MGB_VIDEO_OVLY_TYPE_XYOFFSET_QFORMAT (15)      
      tuint x_offset;        /**< X-position, relative position, Q15 */
      tuint y_offset;        /**< Y-position, relative position, Q15 */
      tuint timer;           /**< Timed event - 0 means indefinite   */

      tuint yuv_fg_msw;      /**< YUV foreground, upper 8 bits is alpha channel, lower 8 bits is Y-plane */
      tuint yuv_fg_lsw;      /**< YUV foreground, upper 8 bits is U-plane, lower 8 bits is V-plane */
      tuint yuv_bg_msw;      /**< YUV background, upper 8 bits is alpha channel, lower 8 bits is Y-plane */
      tuint yuv_bg_lsw;      /**< YUV background, upper 8 bits is U-plane, lower 8 bits is V-plane */

      tuint char_array[1];   /**< Packed character string (null-terminated), from host (BE order) */
} TNI_ATTR_PACK;

typedef struct MGB_MDS_VIDEO_OVLY_CFG ovlyCtrlTTxt_t;

/* @} */ /* ingroup */

#endif /* _IFOVLY_H */

/* nothing past this point */
