# ==============================================================================
# File            : Makedocs.mk
# Description     : 
#
#   GNU makefile to generate IFPKT documentation from sources using Doxygen
#
# ==============================================================================

# The target for generating documents using doxygen is gendocs

RELEASE_DOC=./docs/doxygen/release.chm

releasenotes : $(RELEASE_DOC)

$(RELEASE_DOC): ./docs/doxygen/release.h
	-@echo generating Release Notes ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen ../../swtools/docs/doxygen/releaseDoxyfile
	@xs -f ../../swtools/release.js
	
IFPKT_DOC=./docs/doxygen/IFPKT.chm

release: $(IFPKT_DOC)

gendocs $(IFPKT_DOC): datapkt.h datapktfax.h ifpkt.h xferpkt.h
	-@echo generating IFPKT documentation ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen.exe ./docs/doxygen/Doxyfile

# End of Makedocs.mk
