#ifndef _XFERPKT_H
#define _XFERPKT_H
/* ========================================================================== */
/**
 *  @file   xferpkt.h
 *
 *  path    /dsps_gtmas/ti/mas/ifpkt/xferpkt.h
 *
 *  @brief  This file defines the data high-level packet transport formats and
 *          and definitions used for communication of packet data between
 *          processing components.  The file contains definitions of enumeration for
 *          supported packet types and the transfer packet data structure definition.
 *          This file should be included by software components that pass packets as
 *          their output to another component or receive packets as input from other
 *          components
 *
 *  ============================================================================
 *  Copyright (c) Texas Instruments Incorporated 2002-2007
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#include <ti/mas/types/types.h>


/** @defgroup PacketTransportDefs Packet Transport Format Definitions
 *            Definition of generic packet transport structures and definitions used for the
 *            exchange of packet data between software components.
 */
/** @ingroup PacketTransportDefs */
/* @{ */

/**
 *
 *  @brief  Packet Type Definitions 
 *
 *          xferpktType_t defines the list of supported packet types that are transported
 *          in the system.  Each packet types has a defined packet structure and format.
 *
 */
typedef enum {
  xferpkt_TYPE_NULL=-1,       /**< Don't care */
  xferpkt_TYPE_AAL1=17,       /**< AAL1 packets */
  xferpkt_TYPE_AAL2=18,       /**< AAL2 packets */
  xferpkt_TYPE_FRF11=-2,      /**< FRF11 packets */
  xferpkt_TYPE_S3=-3,         /**< S3 packets */
  xferpkt_TYPE_XPT=-4,        /**< XPT packets */
  xferpkt_TYPE_RTP=16,        /**< RTP packets */
  xferpkt_TYPE_RTCP=-5,       /**< RTCP packets */
  xferpkt_TYPE_HDLC=9,        /**< HDLC packets */
  xferpkt_TYPE_ANNOUNCE=10,   /**< Announce packets */
  xferpkt_TYPE_FAX=16,        /**< FAX packets */
  xferpkt_TYPE_CLEARDATA=16,  /**< Digital Data packets */
  xferpkt_TYPE_ALIVE=11,      /**< keep alive packets */
  xferpkt_TYPE_FEC=19,        /**< FEC packet */
  xferpkt_TYPE_MSG_LOW=20,    /**< Low priority message packet */
  xferpkt_TYPE_MSG_NORMAL=21, /**< Normal priority message packet */
  xferpkt_TYPE_MSG_HIGH=22,   /**< High priority message packet */
  xferpkt_TYPE_NONVOICE=23,   /**< Non Voice Pkts*/
  xferpkt_TYPE_PLR_RECOV=256  /**< PLR recovered packet */
} xferpktType_t;


/**
 *
 *  @brief  Generic packet transport data structure 
 *
 *          xferpktInfo_t defines the generic data structure for components that
 *          have packets as their inputs or output.
 *
 *          The interface allows for the transport of multiple packets or segments in a single
 *          structure.  This is accomplished by passing pointers to an array containing a set of
 *          packet pointer as well as a pointer to an array containing a set of associated packet
 *          lengths (in bytes).  The variable 'npkts' identifies the number of packets being
 *          transported.  When transporting multiple packets it is assumed that all packets are
 *          of the same type.
 *
 *          The variable 'srcPort' is used ... 
 *
 */
typedef struct {
  xferpktType_t type;       /**< Defines the packet type being transported (see @ref xferpktType_t 
                                 for the list of valid packet types) */
  tuint         srcPort;    /**< Defines the source port where the packet originated from */      
  tint          npkts;      /**< Defines the number transmission segments being trasnported */
  tint          *pktSize;   /**< Pointer to segment size array. */
  void          **pktIn;    /**< Pointer to segment entry array */
  void          *suppInfo;  /**< Pointer to optional supplemental data 
                             *   may be uninitialized between modules that dont need it;
                             *   must be initialized for modules that need it.
                             */


} xferpktInfo_t;
/* @} */ /* ingroup */

#endif /* _XFERPKT_H */

/* nothing past this point */
