/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



#ifndef _IFPLR_H
#define _IFPLR_H

/** @defgroup ifplr_module IFPLR Definitions
 *  
 *  @brief    State definitions of PLR RX state machine 
 *
 *  @{
 *  @name     PLR RX State Machine Defines
 */
/*  @{ */
#define ifplr_RED_RX_DISABLED  0
#define ifplr_RED_RX_INITRED   1
#define ifplr_RED_RX_SEQRED    2
#define ifplr_RED_RX_JUMPRED   3
#define ifplr_RED_RX_LATERED   4

#define ifplr_GET_FEC_PAYLOAD_TYPE   0 
#define ifplr_GET_RED_PAYLOAD_TYPE   1

#define ifplr_PLR_TX_DIRECTION  0
#define ifplr_PLR_RX_DIRECTION  1

#define ifplr_FEC_2198_PRIMARY_MEDIA   0x0FEC
#define ifplr_FEC_TX_2198_ENCAPSULATE  0x0FEC
#define ifplr_FEC_RX_2198_ENCAPSULATE  0x1FEC

#define ifplr_FEC_TX_2_STREAMS         0x2FEC
#define ifplr_FEC_BAD_2198ENCAP        0xFFFF /**< indicating received 2198 encap pkt is bad */
/*  @} */
/** @} */

#endif /* _IFPLR_H */
/* nothing after this point */
