# ==============================================================================
# File            : Makedocs.mk
# Description     : 
#
#   GNU makefile to generate IFRCU documentation from sources using Doxygen
#
# ==============================================================================

# The target for generating documents using doxygen is gendocs

RELEASE_DOC=./docs/doxygen/release.chm

releasenotes : $(RELEASE_DOC)

$(RELEASE_DOC): ./docs/doxygen/release.h
	-@echo generating Release Notes ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen ../../swtools/docs/doxygen/releaseDoxyfile
	@xs -f ../../swtools/release.js


IFRCU_DOC=./docs/doxygen/IFRCU.chm

all: $(IFRCU_DOC)
gendocs $(IFRCU_DOC): ifrcu.h ./docs/doxygen/doxygen.h
	-@echo generating IFRCU documentation ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen.exe ./docs/doxygen/Doxyfile


# End of Makedocs.mk
