# ==============================================================================
# File            : Makedocs.mk
# Description     : 
#
#   GNU makefile to generate IFRFC documentation from sources using Doxygen
#
# ==============================================================================

# The target for generating documents using doxygen is gendocs

RELEASE_DOC=./docs/doxygen/release.chm

releasenotes : $(RELEASE_DOC)

$(RELEASE_DOC): ./docs/doxygen/release.h
	-@echo generating Release Notes ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen ../../swtools/docs/doxygen/releaseDoxyfile
	@xs -f ../../swtools/release.js
IFRFC_DOC=./docs/doxygen/IFRFC.chm

all: $(IFRFC_DOC) 

gendocs $(IFRFC_DOC): ifrfc.h
	-@echo generating IFRFC documentation ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen.exe ./docs/doxygen/doxyfile

# End of Makedocs.mk
