#ifndef _IFTEXTRFC_H
#define _IFTEXTRFC_H

/**
 *  @file   iftextrfc.h
 *  @brief  Configuration interface for IETF RFCs
 *
 *  (C) Copyright 2009, Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
/** @defgroup IFTEXTRFC */
/** @ingroup IFTEXTRFC */
/* @{ */

/** \def RFC_FIFO_TEXT_HDR_SZ_BYTES
 *  \brief Macro defining the RFC text header size in bytes
 */
#define RFC_FIFO_TEXT_HDR_SZ_BYTES     10

/** \struct rfcRxTText_s 
 *  \brief RFC text frame header
 *
 *   This structure contains the text frame attributes which is 
 *   received inband. Output buffer from API rfcRxGetFrame()
 *   would be of type rfcFifoTextInfo_t in the case of Text 
 *   overlay channel
 */
typedef struct rfcRxTText_s {
    tuint       valid_bitmap;            /**< bitmap to indicate which fields are valid in the structure */
#define RFC_FIFO_VALID_TEXT_TYPE   0x1 
#define RFC_FIFO_VALID_TEXT_DUR    0x2
    tuint       text_type;               /**< type or duration */
#define RFC_FIFO_TEXT_TYPE_UTF_8     0        
    tulong     text_dur;                 /**< Duration for overlay text in RTP timestamp units */
    tuint      text_len;                 /**< Length in number of bytes */
    tword      textp[1];
} rfcRxTText_t;

/* @} */ /* ingroup */

#endif

/* nothing past this point */
