/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



#ifndef _IFDTMF_H
#define _IFDTMF_H
/**
 *  @file ifdtmf
 *
 *  path  ti/mas/iface/ifsys/ifdtmf.h
 *
 *  @brief  Interface for DTMF. This file is used by both Micro and DSP software.
 */

/** @defgroup ifdtmf Interface for DTMF
 *
 *  @brief    when ifdtmf_DIGIT_ACTIONS_M_BIT_PKT_OPT is set:
 *            - 0: M-bit packet carries TS=T1; D=0 
 *            - 1: M-bit packet carries TS=T0; D= @ref ifdtmf_DIGIT_INIT_DURATION_30ms
 *
 *  @note     Refer QRS 4543 for definition of T0 and T1.
 *
 *  @{
 */
/*  @{ */
#define ifdtmf_DIGIT_ACTIONS_M_BIT_PKT_T1_D0    0
#define ifdtmf_DIGIT_ACTIONS_M_BIT_PKT_T0_D30   1

#define ifdtmf_DIGIT_INIT_DURATION_30ms         240  /* Initial packet duration: 30ms */   
/*  @} */
/** @} */
#endif /* _IFDTMF_H */
/* nothing past this point */
