#ifndef _IFVPPU_H
#define _IFVPPU_H

/**
 *  @file   ifvppu.h
 *  @brief  Configuration interface for Video Protocol and Playout Unit (VPPU)
 *
 *  (C) Copyright 2009, Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
/** @defgroup IFVPPU */
/** @ingroup IFVPPU */
/* @{ */

#include <ti/mas/types/types.h>

#ifndef TNI_ATTR_PACK
#define TNI_ATTR_PACK
#endif

/** @brief Setup and Run-time configuration */
/***************** ifvppu_GET_VPPU_STAT ***************************************/

typedef tuint  ifvppu_STAT_TYPE;
#define ifvppu_GET_TYPE_RX             0x1 /**< RX: Decoder VPPU channel */
#define ifvppu_GET_TYPE_TX             0x2 /**< TX: Encoder VPPU channel */

/*******************************************************************************
 * Description: These structures defines the statistics which can be retrieved
 *              from VPPU module
 ******************************************************************************/
struct ifvppu_GET_RX_STAT {
   tuint  codingType;               /**< Will indicate current Decoder for RX statistics or 
                                       Encoder for TX statistics                                */
   tuint  dupSeqNumDrops;           /**< Packets dropped due to duplicate seq numbers             */
   tuint  numLostPkts;              /**< Packets lost in the network                              */
   tuint  numStreamSwitches;        /**< Number of times stream switched (sudden jump in seq_num) */
   tuint  numPktsDroppedMSW;        /**< Packets dropped due to purge of FIFO/frame(s)            */
   tuint  numPktsDroppedLSW;        /**< Packets dropped due to purge of FIFO/frame(s)            */
   tuint  numOutofOrderPktsMSW;     /**< Number of out-of-order packets                           */
   tuint  numOutofOrderPktsLSW;     /**< Number of out-of-order packets                           */
   tuint  rxNetPktsMSW;             /**< Number of packets received by VPPU                       */
   tuint  rxNetPktsLSW;             /**< Number of packets received by VPPU                       */
   tuint  rxNetFramesRecvdMSW;      /**< # of frames sent to decoder                              */
   tuint  rxNetFramesRecvdLSW;      /**< # of frames sent to decoder                              */
   tuint  rxNetFramesRFCdoneMSW;    /**< # of frames RFC processing done                          */
   tuint  rxNetFramesRFCdoneLSW;    /**< # of frames RFC processing done                          */
   tuint  minFrameInterArrivalTimeMSW; /**< minimum Frame InterArrival Time                       */
   tuint  minFrameInterArrivalTimeLSW; /**< minimum Frame InterArrival Time                       */
   tuint  maxFrameInterArrivalTimeMSW; /**< maximum Frame InterArrival Time                       */
   tuint  maxFrameInterArrivalTimeLSW; /**< maximum Frame InterArrival Time                       */
   tuint  maxPktsRcvdPerSecond;     /**< packet burst detector                                    */
   tuint  currNumPendingFrames;     /**< Current depth of FIFO - in frames                        */
   tuint  maxNumPendingFrames;      /**< Maximum depth to which fifo reached - in frames          */
   tuint  currNumPendingPackets;    /**< Current depth of FIFO - in packets                       */
   tuint  maxNumPendingPackets;     /**< Maximum depth to which fifo reached - in packets         */
   tuint  playout_fps;              /**< FPS indicated by RTP timestamp                           */
   tuint  wire_fps;                 /**< FPS observed on wire (arrival from network)              */
   tuint  lastSeqNum;               /**< last received seq Number                                 */
   tuint  lastTimeStampMSW;         /**< last received RTP Timestamp                              */
   tuint  lastTimeStampLSW;         /**< last received RTP Timestamp                              */
} TNI_ATTR_PACK;

struct ifvppu_GET_TX_STAT {
   tuint  codingType;               /**< Will indicate current Decoder for RX statistics or 
                                       Encoder for TX statistics                                */
   tuint  numTxFramesMSW;           /**< Number of Tx Frames sent to network                      */
   tuint  numTxFramesLSW;           /**< Number of Tx Frames sent to network                      */
   tuint  txNetPktsMSW;             /**< Number of RTP packets sent to network                    */
   tuint  txNetPktsLSW;             /**< Number of RTP packets sent to network                    */
   tuint  wire_fps;                 /**< FPS sent out to network                                  */
   tuint  wire_fps_jitter;          /**< average TX frame jitter (ms)                             */
   tuint  lastSeqNum;               /**< last sentout seq Number                                  */
   tuint  lastTimeStampMSW;         /**< last sentout RTP Timestamp                               */
   tuint  lastTimeStampLSW;         /**< last sentout RTP Timestamp                               */
} TNI_ATTR_PACK;

union ifvppu_GET_STAT_INFO{
       struct ifvppu_GET_RX_STAT      rx;
       struct ifvppu_GET_TX_STAT      tx;
 }TNI_ATTR_PACK;

struct ifvppu_GET_STAT {
   ifvppu_STAT_TYPE                vppuType;/**< Identifies the type of VPPU channel. 
                                             * If vppu_type is MGB_DMS_GET_VPPU_TYPE_RX_T
                                             *      channel is configured as decoder and
                                             *      rx statistics will be valid
                                             * 
                                             * If vppu_type is MGB_DMS_GET_VPPU_TYPE_TX_T
                                             *      channel is configured as encoder and
                                             *      tx statistics will be valid
                                             */
   union ifvppu_GET_STAT_INFO       info;   /**< Statistics information depending on type */
}TNI_ATTR_PACK;

/* @} */ /* ingroup */

#endif /* _IFVPPU_H */
/* nothing past this point */
