
RTSC_TARGETS = c66le_elf vc98

TS_TARGETS = $(findstring $(XDCARGS),$(RTSC_TARGETS))
TARGETS_TS = $(findstring $(RTSC_TARGETS),$(XDCARGS))

ifneq (,$(findstring debug, $(XDCARGS)))
 DEBUG=yes
else
 DEBUG=no
endif
export DEBUG

# PHONY Targets
.PHONY: all clean cleanall 

# FORCE Targets
FORCE: 

all: .executables 
.executables: .libraries
.libraries: .interfaces
.interfaces:

git.interfaces:
	-@echo Cloning containers from GIT...
#	gmake -C src\ts -f src\ts\makefile clean
	touch $@

git.libraries:
	-@echo Building Container library...
	@echo Targets: $(TS_TARGETS)
	@echo Targets: $(TARGETS_TS)
	-@echo XDCARGS = $(XDCARGS)
	@env > rtsc_env.txt
ifneq (,$(findstring vc98, $(XDCARGS)))
	@echo Compiling TS for VC98 Target... 
	gmake -C src\ts -f Makefile vc98
	if [ ! -d vc98 ]; then mkdir -p vc98 ; fi;
	@cp src/ts/lib/ts.a86 vc98
endif
ifneq (,$(findstring c66le_elf, $(XDCARGS)))
	@echo Compiling TS for C66x LE ELF...
	gmake -C src\ts -f Makefile c66x
	if [ ! -d ce66 ]; then mkdir -p ce66 ; fi;
	@cp src/ts/lib/ts.ae66 ce66
endif
#	touch $@


.interfaces: git.interfaces

.libraries: git.libraries

#git.all: vc98/mmcu_c.a86 src/ts/lib/ts.lib
#	$(ARIN) -out:vc98/mmcu_c.a86 src/ts/lib/ts.lib
#	touch $@


clean::
	-@rm git.interfaces
	-@rm git.all
	gmake -C src/ts -f Makefile clean

