# ==============================================================================
# File            : Makedocs.mk
# Description     : 
#
#   GNU makefile to generate MMCU documentation from sources using Doxygen
#
# ==============================================================================

# The target for generating documents using doxygen is gendocs

RELEASE_DOC=./docs/doxygen/release.chm

releasenotes : $(RELEASE_DOC)

$(RELEASE_DOC): ./docs/doxygen/release.h
	-@echo generating Release Notes ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen ../swtools/docs/doxygen/releaseDoxyfile
	@xs -f ../swtools/release.js

MMCUAPI_DOC=./docs/doxygen/MMCUAPI.chm
MMCU_DOC=./docs/doxygen/MMCU.chm

release : $(MMCUAPI_DOC) $(MMCU_DOC)

gendocs $(MMCU_DOC): mmcu.h ./docs/doxygen/doxygen.h
	-@echo generating MMCU documentation ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen.exe ./docs/doxygen/Doxyfile

genapidocs $(MMCUAPI_DOC): mmcu.h ./src/mmculoc.h ./docs/doxygen/doxygen.h ./src/ts/tsdemux.h
	-@echo generating MMCU API documentation ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen.exe ./docs/doxygen/APIDoxyfile

# End of Makedocs.mk
