# ==============================================================================
# File            : MakedocsBundle.mk
# Description     : 
#
#   GNU makefile to generate MMCU bundle documentation from sources using Doxygen
#
# ==============================================================================


# Common paths
MASPATH = ../..
DOXPATH = docs/doxygen
DOXHTML = $(DOXPATH)/html
ECOHTML = $(DOXPATH)/html

# Document targets 
USAGE_DOC = ./docs/MMCU_Users_Manual.chm
RELEASE_DOC_BUNDLE=./$(DOXPATH)/release.chm

releasenotes : $(RELEASE_DOC_BUNDLE)

release: $(USAGE_DOC)

$(RELEASE_DOC_BUNDLE): ./docs/doxygen/release.h
	-@echo generating Bundle Release Notes ...
	if test ! -d ./docs/doxygen/tmp; then mkdir ./docs/doxygen/tmp; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/tmp
	doxygen ../../swtools/docs/doxygen/bundlerelDoxyfile
	@xs -f ../../swtools/bundlerelease.js
	$(RMDIR) ./docs/doxygen/tmp
	
	
$(USAGE_DOC): ./$(DOXPATH)/doxygen.h
	-@echo Generating MMCU Usage documentation ...
	if test ! -d $(DOXHTML); then mkdir $(DOXHTML); fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* $(DOXHTML)

	@echo Pulling in MMCU Documentation ...
	@cp -fru $(MASPATH)/mmcu/$(ECOHTML) $(DOXHTML)/mmcu_html

	doxygen ./$(DOXPATH)/Doxyfile
	xs -f ../../swtools/redirect.js ./doxygen/html/index.html > ./docs/MMCU_Users_Manual.html 


# End of Makedocs.mk
