/*
 * This is a template header file which doxygen parses to generate the main
 * documentation page
 */

/**
 * @mainpage @COMP (@COMP_LONG) Package
 *
 * @HLINE
 *
 * @section content Page Contents
 *  
 *  <ol>
 *    <li> @ref describe 
 *    <li> @ref integrate
 *    <li> @ref limit
 *    <li> @ref standard
 *    <li> @ref depend
 *  </ol>
 *  
 * @HLINE
 *
 *
 * @section describe Description
 *  
 *  Media is rarely stored as a single elementary audio or video stream. 
 *  Instead, multiple elementary streams are muxed into a container stream with 
 *  information for presenting the streams. This information includes details 
 *  on the format of the elementary streams along with timing information for 
 *  synchronizing the streams. There are also a variety of container formats 
 *  that define how the elementary streams are muxed.
 *
 *  The MMCU (MultiMedia Container Unit) provides a uniform set of APIs for muxing and demuxing  
 *  elementary streams to and from various container stream formats.
 *  
 *  
 * @HLINE
 * 
 *
 * @section integrate Integration
 *
 *  Information on building and integrating @COMP is found on the following pages:
 *
 *  <ul>
 *    <li> Build Procedure
 *      <ol>
 *        <li> @subpage building_xdc
 *      </ol>
 *    <li> @subpage integrate_details
 *    <li> @ref mmcu_module
 *  </ul>
 *  
 * @HLINE
 * 
 *
 * @section limit Limitations
 *   
 *  Currently, MMCU only supports demuxing media streams.
 * 
 *
 *  
 * @HLINE
 * 
 *
 * @section standard Standards Compliance
 *
 *  - MPEG Transport Stream (demux only)
 *
 *
 *  
 * @HLINE
 *
 * 
 * @section depend Dependent Packages
 *
 *  The @COMP package depends on the following packages for build and/or integration:
 *
 *  <ol>
 *    <li> \c ti.mas.types (Common data type defintions)
 *    <li> \c ti.mas.util  (Common utilities)
 *    <li> \c ti.mas.pktutl 
 *    <li> \c ti.mas.iface.ifpkt
 *    <li> \c ti.mas.iface.ifvisys
 *    <li> \c ti.mas.iface.ifmmc
 *    <li> \c ti.mas.swtools (Build tools)
 *  </ol>
 *  
 */


/**
 * @page describe_details  Detailed @COMP Description
 *      
 */

 
/**
 * @page limit_details  Limitations
 *
 */

 
/**
 * @page standard_details  Standard Compliance
 *
 */


/**
 * @page building_xdc Build Procedure using XDC
 *
 *  @section tools Required Tools
 *
 *  The following tools are required to build the @COMP component.
 *  Download and install all tools to a single local (@c C:) directory, for 
 *  example @c c:\\tools.
 *
 *   <ol>
 *     <li> Code Generation 
 *       <ul>
 *         <li> CG Tools for C64x, C66x
 *       </ul>
 *     <li> XDC 
 *     <li> xDAIS 
 *   </ol>
 *
 * @note Version information can be found in the release notes.
 *
 *
 * @section config Configuration
 *
 * @subsection win32 Windows Environment
 *
 *  Once all tools are properly installed, the environment will need to be configured 
 *  to recognize the tool paths. A Windows batch file should be created to provide a
 *  consistent manner to achieve this. The example below can be used (cut & paste) to 
 *  create a @c setenv.bat batch file in the <tt>...\\ti\\mas\\swtools directory</tt>.
 *
 * @note The following example makes the assumptions:
 *
 *  <ol>
 *    <li> The XDC tools were installed in @c c:\\tools
 *    <li> The C64 / C66 code generation tools were installed in @c c:\\tools\\cgen7_2_02
 *    <li> The xDAIS developr's kit was installed in @c c:\\tools\\xdais_5_21
 *  </ol>
 *
 *  @note Please read the release notes for correct version information.
 *
 * @verbatim

    @echo off
    rem # *************************************************************************
    rem # *** Version information (ONLY EDIT THIS SECTION)
    rem # *************************************************************************
    set LOCAL_TOOLSDIR=tools
    set XDCBASE=xdctools_3_20_05_76
    set C64CODEGENBASE=cgen7_2_02
    set C66CODEGENBASE=cgen7_2_02
    set XDAISBASE=xdais_5_21

    rem # *************************************************************************
    rem # *** Set up tools directory
    rem # *************************************************************************
    set LOCAL_TOOLSDIR_DOS=c:\%LOCAL_TOOLSDIR%

    rem # *************************************************************************
    rem # ** Set code generation tools path
    rem # *************************************************************************
    set C64CODEGENTOOL=%LOCAL_TOOLSDIR_DOS%\%C64CODEGENBASE%
    set C66CODEGENTOOL=%LOCAL_TOOLSDIR_DOS%\%C66CODEGENBASE%

    rem # *************************************************************************
    rem # ** Set the PATH
    rem # *************************************************************************
    set PATH=%SystemRoot%;%SystemRoot%\system32
    set PATH=%PATH%;%LOCAL_TOOLSDIR_DOS%\%XDCBASE%

    rem # *************************************************************************
    rem # ** Create environment variables for XDC
    rem # *************************************************************************
    set XDCCGROOT=%LOCAL_TOOLSDIR_DOS%
    set xdc=\%LOCAL_TOOLSDIR%\%XDCBASE%\xdc.exe $*

    rem # *************************************************************************
    rem # ** Set the XDC PATH
    rem # *************************************************************************
    set XDCPATH=%LOCAL_TOOLSDIR_DOS%\%XDCBASE%\packages
    set XDCPATH=%XDCPATH%;%LOCAL_TOOLSDIR_DOS%\%XDAISBASE%\packages

    rem # *************************************************************************
    rem # ** Identify the config.bld file
    rem # *************************************************************************
    xs -f setconfig.js
    call tempcfg
    del tempcfg.bat

    rem # *************************************************************************
    rem # ** MSVC Codegen Tools
    rem # *************************************************************************
    @if not "%VS100COMNTOOLS%"=="" (
      set VC98TOOL=%VS100COMNTOOLS%/../../
      @call "%VS100COMNTOOLS%/vsvars32.bat"
    )
    
    rem # End of file
   @endverbatim
 *
 * @note The swtools component contains a similar batch file, named cygwinxdc.bat, 
 *       that was used to generate the @COMP component package. Calling 
 *       'cygwinxdc.bat bypass' on the command line will set up the environment, 
 *       however, it will be required to confirm that the path for the tools are 
 *       correct.
 *
 *
 * @subsection linux Linux Environment
 *
 *  TBD
 *
 *
 * @section compile Compilation using XDC
 *
 *  To build the @COMP package, ensure (again) that all packages provided with the 
 *  build have been extracted to a common working directory (as described in 
 *  @ref integrate_details). Change to the @c swtools directory and configure the build 
 *  environment by executing the @c setenv.bat batch file.  To build the @COMP using the 
 *  XDC tools, change to the @COMP directory and proceed.
 *
 *  With the environment configured, XDC may be employed to build the @COMP and its
 *  dependent packages. The four XDC commands below are all that is needed to
 *  clean and build any of the @COMP packages.  The first two commands provide a means
 *  to clean and build the @COMP package (alone).  Nothing further is needed unless 
 *  the source for a dependent packages has changed.
 *
 *  If the source for any of the dependent packages has changed, commands (3) and (4)
 *  below provide a mechanism to clean and build both the @COMP and all dependent packages.
 *
 * @note In the above, the @c \<WORK\>/ti/mas/ path is assumed and just the sub-directories 
 *       are specified (e.g., @c mmcu).  
 *
 *  The XDC environment provides several build options.
 *
 *  <ol>
 *    <li> <tt>xdc clean</tt>
 *      <ul>
 *        <li> Removes all generated @COMP build files
 *        <li> Analagous to "make clean"
 *      </ul>
 *
 *    <li> <tt>xdc XDCARGS="\<rtarg\> obj"</tt>
 *      <ul>
 *        <li> Builds the @COMP for the target specified by @c \<rtarg\> (see Table 1 in 
 *             @ref integrate_details)
 *      </ul>
 *
 *    <li> <tt>xdc XDCARGS="\<rtarg\> obj" -PD .</tt>
 *      <ul>
 *        <li> Builds the @COMP as in (2) above
 *        <li> The <tt>"-PD ."</tt> option ensures that all dependent packages are built as 
 *             well (if needed).
 *      </ul>
 *
 *    <li> <tt>xdc clean -PD .</tt>
 *      <ul>
 *        <li> Removes all generated @COMP build files as in (1) above
 *        <li> Removes all generated build files for all @COMP dependent packages
 *      </ul>
 *  </ol>
 *  
 * @HLINE
 *
 *
 *
 */


 
/**
 * @page integrate_details  @COMP Integration 
 *  
 * @HLINE
 *
 * @section content Page Contents
 *  
 *  <ul>
 *    <li> @ref tools
 *    <li> @ref pack
 *    <li> @ref include
 *    <li> @ref options
 *    <li> @ref linking
 *    <li> @ref context
 *  </ul>
 *  
 * @HLINE
 *
 *
 * @section tools XDC Build Tools
 *
 *  All Real-Time Software Component (RTSC) packages currently require the Expanded 
 *  C Package Build Tools (XDC) environment to build.  The XDC tools need to be 
 *  installed even for linking a RTSC library.  Directions for loading the proper XDC 
 *  tools can be found in @ref building_xdc.
 *
 * @HLINE
 *
 *
 * @section pack Packages
 *
 *  The list of dependent packages is provided below. See the release notes for
 *  version and compatibility information.
 *  
 *  <ol>
 *    <li> \c ti.mas.types 
 *    <li> \c ti.mas.util  
 *    <li> \c ti.mas.pktutl 
 *    <li> \c ti.mas.iface.ifpkt
 *    <li> \c ti.mas.iface.ifvisys
 *    <li> \c ti.mas.iface.ifmmc
 *    <li> \c ti.mas.swtools 
 *  </ol>
 *  
 *  
 *  Each package in the above table is provided as a zip-file and should be 
 *  expanded (unzipped) to a common working directory (@c \<WORK\>).  This will
 *  create the following directory structure under the common directory.
 *
 * @verbatim

  <WORK>/ti/mas/mmcu
               /pktutl
               /swtools
               /types
               /util
               /iface/ifpkt
                     /ifvisys
                     /ifmmc

   @endverbatim
 *  Please note that this directory structure and its content should be maintained to 
 *  allow subsequent compilation.
 *
 * @HLINE
 *
 *
 * @section include Include Requirements
 *
 *  The following header files must be included in any source file that references
 *  the @COMP API:
 *
 *   <ol>
 *     <li> @c \#include @c <ti/mas/types/types.h>
 *     <li> @c \#include @c <ti/mas/mmcu/mmcu.h>
 *   </ol>
 *
 *  The compile-time options below are required such that both @c \<WORK\> and XDC's 
 *  @c std.h reside in the compiler's include path.
 *
 *   <ol>
 *     <li> @c -i @c \<TOOLSXDC\>/packages
 *     <li> @c -i @c \<WORK\>
 *   </ol>
 *
 *  Where @c TOOLSXDC is the path to XDC tools and @c WORK is the path 
 *  to the working directory.  Note that the TOOLSXDC path includes everything up to and 
 *  including the XDC tools version (e.g., @c C:\\tools\\gen\\xdc\\xdctools_3_40_00_41).
 *
 * @HLINE
 *
 *
 * @section options Compile Options
 *
 *  When compiling source files that include RTSC package header files, the following 
 *  compiler options must be specified:
 *
 *   <ol>
 *     <li> @c -Dti_targets_\<xtarg\> 
 *     <li> @c -Dxdc_target_name__=\<xtarg\> 
 *     <li> @c -Dxdc_target_types__=ti/targets/std.h 
 *     <li> @c -Dxdc__nolocalnames 
 *   </ol>
 *
 *  Where @c \<xtarg\> represents the target platform using the XDC naming convention 
 *  (see Table 1 below).
 *
 * @HLINE
 *
 *
 * @section linking Linking
 *
 *  The following libraries must be linked:
 *
 *  <ol>
 *    <li> @c ti\\mas\\util\\c\<ltarg\>\\util_a.a\<ltarg\>
 *    <li> @c ti\\mas\\util\\c\<ltarg\>\\util_c.a\<ltarg\>
 *    <li> @c ti\\mas\\pktutl\\c\<ltarg\>\\pktutl_a.a\<ltarg\>
 *    <li> @c ti\\mas\\pktutl\\c\<ltarg\>\\pktutl_c.a\<ltarg\>
 *    <li> @c ti\\mas\\mmcu\\c\<ltarg\>\\mmcu_c.a\<ltarg\>
 *  </ol>
 *
 *
 * @HLINE
 *
 *
 *  <table>
 *     <caption align="bottom">Table 1.  Target Naming Conventions</caption>
 *     <tr>
 *       <td><B>Target</B></td>
 *       <td><B>RTSC Naming (\<rtarg\>)</B></td>
 *       <td><B>XDC Naming (\<xtarg\>)</B></td>
 *       <td><B>Library Naming (\<ltarg\>)</B></td>
 *       <td><B>Library Format</B></td>
 *     </tr>
 *     <tr>
 *       <td>C64x+ Little Endian</td>
 *       <td>@c c64Ple</td>
 *       <td>@c C64P</td>
 *       <td>@c 64P</td>
 *       <td>@c COFF</td>
 *     </tr>
 *     <tr>
 *       <td>C64x+ Big Endian</td>
 *       <td>@c c64Pbe</td>
 *       <td>@c C64P_big_endian</td>
 *       <td>@c 64Pe</td>
 *       <td>@c COFF</td>
 *     </tr>
 *     <tr>
 *       <td>C64x+ Little Endian</td>
 *       <td>@c c64Ple_elf</td>
 *       <td>@c C64P_elf</td>
 *       <td>@c e64P</td>
 *       <td>@c ELF</td>
 *     </tr>
 *     <tr>
 *       <td>C64x+ Big Endian</td>
 *       <td>@c c64Pbe_elf</td>
 *       <td>@c C64P_big_endian_elf</td>
 *       <td>@c e64Pe</td>
 *       <td>@c ELF</td>
 *     </tr>
 *     <tr>
 *       <td>C66x Little Endian</td>
 *       <td>@c c66le</td>
 *       <td>@c C66</td>
 *       <td>@c 66</td>
 *       <td>@c COFF</td>
 *     </tr>
 *     <tr>
 *       <td>C66x Big Endian</td>
 *       <td>@c c66be</td>
 *       <td>@c C66_big_endian</td>
 *       <td>@c 66e</td>
 *       <td>@c COFF</td>
 *     </tr>
 *     <tr>
 *       <td>C66x Little Endian</td>
 *       <td>@c c66le_elf</td>
 *       <td>@c C66_elf</td>
 *       <td>@c e66</td>
 *       <td>@c ELF</td>
 *     </tr>
 *     <tr>
 *       <td>C66x Big Endian</td>
 *       <td>@c c66be_elf</td>
 *       <td>@c C66_big_endian_elf</td>
 *       <td>@c e66e</td>
 *       <td>@c ELF</td>
 *     </tr>
 *     <tr>
 *       <td>X86 (Windows XP)</td>
 *       <td>@c vc98</td>
 *       <td>@c -</td>
 *       <td>@c 86</td>
 *       <td>@c -</td>
 *     </tr>
 *   </table> 
 *
 *  @HLINE
 *
 *
 * @section context Context Structure
 *
 *  Information on MMCU's context structure is found here: @ref mmcu_context.
 *
 */


/**
 * @page external_api @COMP External API
 *  
 * @HLINE
 *
 * @section content Page Contents
 *
 *  <ol>
 *    <li> @ref mmcu_api_create 
 *    <li> @ref mmcu_api_config
 *    <li> @ref mmcu_api_execute 
 *    <li> @ref mmcu_api_destroy
 *    <li> @ref output
 *  </ol>
 *
 * @HLINE
 *
 *
 * @subsection create @COMP Creation Functions
 *
 *  [Describe creation process]  
 *
 *  <ol>
 *    <li> List API functions
 *  </ol>
 *
 * @HLINE
 *
 *
 * @subsection config @COMP Configuration Functions
 *
 *  [Describe configuration process]  
 *
 *  <ol>
 *    <li> List API functions
 *  </ol>
 *
 * @HLINE
 *
 *
 * @subsection execute @COMP Execution Functions
 *
 *  [Describe execution process]  
 *
 *  <ol>
 *    <li> List API functions
 *  </ol>
 *
 * @HLINE
 *
 *
 * @subsection destroy @COMP Destruction Functions
 *
 *  [Describe destruction process]  
 *
 *  <ol>
 *    <li> List API functions
 *  </ol>
 *
 * @HLINE
 *
 *
 * @section output @COMP Return Codes
 *
 * @subsection output_err Error Codes
 *
 * @subsection output_exc Exception Codes
 *
 */


/**
 * @page Disclaimer
 *<center> <B>IMPORTANT NOTICE </B> </center>
 * Texas Instruments Incorporated and its subsidiaries (TI) reserve the right
 * to make corrections, modifications, enhancements, improvements, and other
 * changes to its products and services at any time and to discontinue any
 * product or service without notice. Customers should obtain the latest
 * relevant information before placing orders and should verify that such
 * information is current and complete. All products are sold subject to TIs
 * terms and conditions of sale supplied at the time of order acknowledgment.
 *
 * TI warrants performance of its hardware products to the specifications
 * applicable at the time of sale in accordance with TIs standard warranty.
 * Testing and other quality control techniques are used to the extent TI
 * deems necessary to support this warranty. Except where mandated by
 * government requirements, testing of all parameters of each product is not
 * necessarily performed.
 *
 * TI assumes no liability for applications assistance or customer product
 * design. Customers are responsible for their products and applications
 * using TI components. To minimize the risks associated with customer
 * products and applications, customers should provide adequate design and
 * operating safeguards.
 *
 * TI does not warrant or represent that any license, either express or
 * implied, is granted under any TI patent right, copyright, mask work right,
 * or other TI intellectual property right relating to any combination,
 * machine, or process in which TI products or services are used. Information
 * published by TI regarding third-party products or services does not
 * constitute a license from TI to use such products or services or a warranty
 * or endorsement thereof. Use of such information may require a license from a
 * third party under the patents or other intellectual property of the third
 * party, or a license from TI under the patents or other intellectual property
 * of TI.
 *
 * Reproduction of information in TI data books or data sheets is permissible
 * only if reproduction is without alteration and is accompanied by all
 * associated warranties, conditions, limitations, and notices. Reproduction
 * of this information with alteration is an unfair and deceptive business
 * practice. TI is not responsible or liable for such altered documentation.
 *
 * Resale of TI products or services with statements different from or beyond
 * the parameters stated by TI for that product or service voids all express
 * and any implied warranties for the associated TI product or service and is
 * an unfair and deceptive business practice. TI is not responsible or liable
 * for any such statements.
 *
 *
 *
 *
 * Mailing Address: <BR>
 * Texas Instruments <BR>
 * Post Office Box 655303 <BR>
 * Dallas, Texas 75265 <BR>
 *
 *
 *
 * Copyright  2010 Texas Instruments Incorporated.
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 * Information in this document is subject to change without notice.
 * Texas Instruments may have pending patent applications, trademarks,
 * copyrights, or other intellectual property rights covering matter in this
 * document.  The furnishing of this document is given for usage with Texas
 * Instruments products only and does not give you any license to the
 * intellectual property that might be contained within this document.
 * Texas Instruments makes no implied or expressed warranties in this document
 * and is not responsible for the products based from this document.
 *
*/
