/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



/*
 * This is a little header file which doxygen parses to generate the main
 * documentation page
 */ 
  
/**
 *  @mainpage 
 *  <p align="center"> 
 *  <a href="#Introduction">Introduction</a>,
 *  <a href="#Documentation">Documentation</a>,
 *  <a href="#Whats_New">What's New</a>
 *  <a href="#Compatibility">Upgrade and Compatibility Information</a>,
 *  <a href="#Host_Support">Host Support</a>,
 *  <a href="#Device_Support">Device Support</a>,
 *  <a href="#Validation">Validation Information</a>,
 *  <a href="#mmcu_test">Unit Test</a>
 *  <a href="#Known_Issues">Known Issues</a>,
 *  <a href="#Version">Version Information</a>,
 *  <a href="#Support">Technical Support</a>
 *  </p>
 *
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--***********************************Introduction***************************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *
 *  <hr>
 *
 *  <h2><a name="Introduction">Introduction</a></h2>
 *
 *  The MMCU (MultiMedia Container Unit) provides a uniform set of APIs for muxing and demuxing  
 *  elementary streams to and from various container stream formats.
 *  
 *  <a href="#XDC_TOP">back to top</a>
 *
 *
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--***********************************Documentation**************************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *
 *  <hr>
 *
 *  <h2><a name="Documentation">Documentation</a></h2>
 *  <p>The following documentation is available: </p> 
 *  - <a href="docs/doxygen/MMCUAPI.chm">MMCU API Reference Guide</a>
 *  - <a href="docs/doxygen/MMCU.chm">MMCU Source Reference Guide (Source Release Only)</a>
 *
 *  <p>Release notes from previous releases are also available in the
 *  <a href="docs/relnotes_archive">relnotes_archive</a>
 *  directory.</p>
 *
 *  <a href="#XDC_TOP">back to top</a> 
 *
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--*************************************What's New***************************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *
 *  <hr>
 *
 *  <h2><a name="Whats_New">What's New</a></h2>
 *  
 *  <p> BSD copyright
 *  </p>
 *
 *  <a href="#XDC_TOP">back to top</a>
 *
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--************************Upgrade and Compatibility Information*************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *
 *  <hr>
 *
 *  <h2><a name="Compatibility">Upgrade and Compatibility Information</a></h2>
 *
 *  This <b>ti.mas.mmcu</b> version is incompatible with the last released version.
 *
 *  Please note that the package compatibility keys are independent of XDC product release numbers. 
 * 
 *  Package compatibility keys are intended to: 
 * 
 *   -# Enable tooling to identify incompatibilities between components, and 
 *   -# Convey a level of compatibility between different releases to set end user expectations. 
 * 
 * Package compatibility keys are composed of 4 comma-delimited numbers - M, S, R, P - where: 
 *
 * - <b>M = Major</b> - A difference in M indicates a break in compatibility. The package consumer is required to re-write its source code in order to use the package.
 * - <b>S = Source</b> - A difference in S indicates source compatibility. The package consumers source code doesn't require change, but does require a recompile. 
 * - <b>R = Radix</b> - A difference in R indicates an introduction of new features, but compatibility with previous interfaces is not broken. If libraries are provided by the package, an application must re-link with the new libraries, but is not required to recompile its source.
 * - <b>P = Patch</b> - A difference in P indicates that only bugs have been fixed in the latest package and no new features have been introduced. If libraries are provided by the package, an application must re-link with the new libraries, but is not required to recompile its source. 
 *
 *  <a href="#XDC_TOP">back to top</a>
 *
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--****************************************Host Support**********************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *
 *  <hr>
 *
 *  <h2><a name="Host_Support">Host Support</a></h2>
 *
 *  The current XDC toolset can be used to build components on the following hosts:
 *   - Windows XP 
 *
 *  <a href="#XDC_TOP">back to top</a>
 *
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--*****************************************Device Support*******************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *  <hr>
 *
 *  <h2><a name="Device_Support">Device Support</a></h2>
 *
 *  - C64P
 *
 *  <a href="#XDC_TOP">back to top</a>
 *
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--**********************************Validation Information******************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *
 *  <hr>
 *
 *  <h2><a name="Validation">Validation Information</a></h2>
 *
 *  This release was built and validated using the following components:
 *
 *  <p><b>Component Dependencies</b>
 *
 *   - ti.mas.types 5.5.4.0 (Common data type definitions)
 *   - ti.mas.swtools 5.0.0.0 (Internally used s/w tools)
 *   - ti.mas.util 4.7.4.0 (Common utilities)
 *   - ti.mas.pktutl 2.1.2.0 (Common packet utilities)
 *   - ti.mas.iface.ifpkt 3.1.1.0 
 *
 *  Compatibility information for MMCU version 1.0.0.1 and its associated dependent 
 *  packages is provided below in Table 1.  
 *
 *   <table>
 *     <caption align="bottom">Table 1.  MMCU Required Packages</caption>
 *     <tr>
 *       <td><B>Package</B></td>
 *       <td><B>File Name</B></td>
 *       <td><B>Compatibility Key</B></td>
 *     </tr>
 *     <tr>
 *       <td>@c ti.mas.mmcu</td>
 *       <td>@c ti_mas_mmcu_<fmt>_c<rtarg>_1_0_1_0.zip</td>
 *       <td>@c [1,0,0,1]</td>
 *     </tr>
 *     <tr>
 *       <td>@c ti.mas.types (dependent)</td>
 *       <td>@c ti_mas_types_<fmt>_c<rtarg>_5_5_3_0.zip</td>
 *       <td>@c [5,0,8,0]</td>
 *     </tr>
 *     <tr>
 *       <td>@c ti.mas.util (dependent)</td>
 *       <td>@c ti_mas_util_<fmt>_c<rtarg>_4_7_3_0.zip</td>
 *       <td>@c [4,0,9,0]</td>
 *     </tr>
 *     <tr>
 *       <td>@c ti.mas.pktutl (dependent)</td>
 *       <td>@c ti_mas_pktutl_<fmt>_c<rtarg>_2_0_1_0.zip</td>
 *       <td>@c [1,0,1,0]</td>
 *     </tr>
 *     <tr>
 *       <td>@c ti.mas.iface.ifpkt (dependent)</td>
 *       <td>@c ti_mas_iface_ifpkt_<fmt>_c<rtarg>_3_1_0_1.zip</td>
 *       <td>@c [3,0,1,1]</td>
 *     </tr>
 *     <tr>
 *       <td>@c ti.mas.swtools (build dependent)</td>
 *       <td>@c ti_mas_swtools_<fmt>_c<rtarg>_4_6_0_12.zip</td>
 *       <td>@c [2,0,4,0]</td>
 *     </tr>
 *   </table>
 *
 *  Note that @c \<fmt\> above represents the delivery format and will be 
 *  either @c src or @c obj and @c \<rtarg\> represents the 
 *  target platform using the RTSC naming convention (see Table 2 below).
 *
 *   <table>
 *     <caption align="bottom">Table 2.  Target Naming Conventions</caption>
 *     <tr>
 *       <td><B>Target</B></td>
 *       <td><B>RTSC Naming (\<rtarg\>)</B></td>
 *       <td><B>XDC Naming (\<xtarg\>)</B></td>
 *     </tr>
 *     <tr>
 *       <td>C64x Little Endian</td>
 *       <td>@c 64le</td>
 *       <td>@c C64</td>
 *     </tr>
 *     <tr>
 *       <td>C64x Big Endian</td>
 *       <td>@c 64be</td>
 *       <td>@c C64_big_endian</td>
 *     </tr>
 *     <tr>
 *       <td>C64x+ Little Endian</td>
 *       <td>@c 64Ple</td>
 *       <td>@c C64P</td>
 *     </tr>
 *     <tr>
 *       <td>C64x+ Big Endian</td>
 *       <td>@c 64Pbe</td>
 *       <td>@c C64P_big_endian</td>
 *     </tr>
 *     <tr>
 *       <td>C66x Little Endian</td>
 *       <td>@c 66le</td>
 *       <td>@c C66</td>
 *     </tr>
 *     <tr>
 *       <td>C66x Big Endian</td>
 *       <td>@c 66be</td>
 *       <td>@c C66_big_endian</td>
 *     </tr>
 *   </table> 
 *
 *  <p><b>Tool Dependencies for Source Release</b>
 *
 *  - XDC Tools version 3.20.05.76
 *  - xDAIS Developer's Kit version 5.21
 *  - RTSC Packaging Standard version 2.00.00
 *  - C64x Code Generation Tools version 7.2.02
 *
 *  <a href="#XDC_TOP">back to top</a>
 *
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--***********************************Unit Test******************************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *
 *  <hr>
 *
 *  <h2><a name="mmcu_test">Unit Test</a></h2>
 *
 *  This version of MMCU contains example code and a unit test for the C64x+ target. Support for a VC98 
 *  unit test is pending.
 *
 *  <a href="#XDC_TOP">back to top</a>
 *
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--***********************************Known Issues***************************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *
 *  <hr>
 *
 *  <h2><a name="Known_Issues">Known Issues</a></h2>
 *
 *  - (none).
 *
 *  <a href="#XDC_TOP">back to top</a>
 *
 *
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--**************************************** Versioning **********************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *
 *  <hr>
 *
 *  <h2><a name="Version">Versioning</a></h2>
 *
 *  This product's version follows a version format, <b>M.m.x.p</b>,
 *  where <b>M</b> is a single digit Major number, <b>m</b> is single digit minor number,
 *  <b>x</b> is single digit vertical number and <b>p</b> is a single digit patch number
 *
 *  <p>Please note that version numbers and compatibility keys are
 *  NOT the same. For an explanation of compatibility keys, please refer to
 *  the '<a href="#Compatibility">Upgrade and Compatibility Information</a>' section.
 *
 *  <a href="#XDC_TOP">back to top</a>
 *
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--*********************************** Technical Support ********************************************-->
 *  <!--**************************************************************************************************-->
 *  <!--**************************************************************************************************-->
 *
 *  <hr>
 *
 *  <h2><a name="Support">Technical Support</a></h2>
 *
 *  Contact local TI Field Application Engineer for technical support.
 *
 *  <a href="#XDC_TOP">back to top</a>
 *
 */
