/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



#include <ti/mas/mmcu/mmcu.h>
#include <ti/mas/mmcu/src/mmculoc.h>
//#include <ti/mas/mmcu/src/avi/avidemux.h>
//#include <ti/mas/mmcu/src/mpegts/mpegtsdemux.h>
//#include <ti/mas/mmcu/src/mov/movdemux.h>

#include <ti/mas/mmcu/src/ts/tsdemux.h>
#include <ti/mas/mmcu/src/ts/tsmux.h>

#include <ti/mas/types/types.h>
#include <string.h>


ifmmcAPI_t supportedMmcs[] = {
    //mmcAVI,
    //mmcMPEGTS,
    //mmcMOV,
    mmcTSDemux,
    mmcTSMux,
    nullMmc
};

tuint mmcGetMaxInstSize(void) 
{
  extern ifmmcAPI_t supportedMmcs[];
  ifmmcAPI_t *suppMmcs = supportedMmcs;
  tuint size = 0;

  while(strcmp(suppMmcs->name, "NULL") != 0) {
    if (size < suppMmcs->instSize) {
       size = suppMmcs->instSize;
    }
    suppMmcs++;
  }
  return(size);
}

ifmmcAPI_t *getMmcAPI(const char *mmcName)
{
  extern ifmmcAPI_t supportedMmcs[];
  ifmmcAPI_t *suppMmcs = supportedMmcs;

  while(strcmp(suppMmcs->name, mmcName) != 0) {
     suppMmcs++;
  }

  if(strcmp(suppMmcs->name, "NULL") == 0) {
     return(NULL);
  } else {
     return(suppMmcs);
  }
}

tuint htons(tuint hval)
{
  tuint   nval  = 0;
  tword   *pval = (tword *)&nval;

  pval[0] = (tword)((hval >> 8) & 0x00FF);
  pval[1] = (tword)(hval & 0x00FF);

  return (nval);
}

tulong htonl(tulong hval)
{
  tulong  nval  = 0;
  tuint   *pval = (tuint *)&nval;

  pval[0] = htons( (tuint) ((hval >> 16) & 0x0000FFFF) );
  pval[1] = htons( (tuint) (hval & 0x0000FFFF) );

  return (nval);
}


void tsGetTime(struct timeval *tv)
{
  tv->tv_usec  = 0;
  tv->tv_sec   = 0;
}

void *ts_new_buffer(void)
{
  void *buf = tsContext.memCxt.alloc(0,tsContext.memCxt.memHandle);
  memset(buf,0,sizeof(mmcuFifo_t));
  //return(calloc(1,sizeof(mmcuFifo_t)));
  return(buf);
}

void ts_delete_buffer(void *bufDesc)
{
  mmcuFifo_t *fifo = (mmcuFifo_t *)bufDesc;
  if(fifo) {
    mmcu_reset_fifo(fifo);
    tsContext.memCxt.free(0,tsContext.memCxt.memHandle,fifo);
  }
}


tsContext_t tsContext = 
{
  {
    NULL,   // memHandle
    NULL,   // alloc
    NULL,   // free
  },
  {
    ts_new_buffer,
    ts_delete_buffer,
    mmcu_reset_fifo,
    mmcu_get_buffer,
    mmcu_put_buffer,
    mmcu_read_buffer,
    mmcu_fskip,
    mmcu_feof
  },
  NULL,   // scratch
  tsGetTime,
  NULL,       // criticalBegin
  NULL        // criticalEnd
};

/* Nothing past this point */
