/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



#ifndef _TS_H
#define _TS_H
#include <ti/mas/types/types.h>
#include <ti/mas/iface/ifmmc/ifmmc.h>

// Stream IDs
#define ts_PROGRAM_STREAM_MAP      0xBC  /**< Program stream map ID */
#define ts_PRIVATE_STREAM_1        0xBD  /**< Private stream 1 ID */
#define ts_PADDING_STREAM          0xBE  /**< Padding stream ID */
#define ts_PRIVATE_STREAM_2        0xBF  /**< Private stream 2 ID */
#define ts_AUDIO_STREAM_MPEG1_2    0xC0  /**< Audio stream ID bitmask */
#define ts_VIDEO_STREAM_MPEG1_2    0xE0  /**< Video stream ID bitmask */
#define ts_ECM_STREAM              0xF0  /**< ECM stream ID */
#define ts_EMM_STREAM              0xF1  /**< EMM stream ID */
#define ts_PROGRAM_STREAM_DIR      0xFF  /**< Program stream dir (ection?, ectory?)ID */

enum tsMP2StreamType_t 
{
  ts_STREAM_TYPE_RESERVED        = 0,    /**<  */
  ts_STREAM_TYPE_MPEG1_VIDEO,            /**< MPEG1 video */
  ts_STREAM_TYPE_MPEG2_VIDEO,            /**< MPEG2 video */
  ts_STREAM_TYPE_MPEG1_AUDIO,            /**< MPEG1 audio */
  ts_STREAM_TYPE_MPEG2_AUDIO,            /**< MPEG2 audio */
  ts_STREAM_TYPE_PRIVATE,                /**< Private */
  ts_STREAM_TYPE_PES,                    /**< Packetized elementary stream */
  ts_STREAM_TYPE_MHEG,                   /**< MHEG */
  ts_STREAM_TYPE_DSMCC,                  /**< DSMCC */
  ts_STREAM_TYPE_AUX,                    /**< Auxilary */
  ts_STREAM_TYPE_AAC_AUDIO       = 15,   /**< AAC audio */
  ts_STREAM_TYPE_MPEG4_VIDEO     = 16,   /**< MPEG4 video */
  ts_STREAM_TYPE_H264_VIDEO      = 27,   /**< H264 video */
  ts_STREAM_TYPE_AC3_AUDIO       = 0x81, /**< AC3 audio */
  ts_STREAM_TYPE_PAT             = 256,  /**< Program association table */
  ts_STREAM_TYPE_CAT,                    /**< Conditional access table */
  ts_STREAM_TYPE_PMT,                    /**< Program map table */
  ts_STREAM_TYPE_NETWORK,                /**< Network */
  ts_STREAM_TYPE_NULL                    /**< Null */
};


/**
 *  @struct   timeval
 *
 *  @brief    This structure is used by @ref mmcuNew() to initialize the MMCU 
 *            buffers and assign an ID to the MMCU instance.
 */
struct timeval {
  int tv_usec;      /**< Microseconds */
  int tv_sec;       /**< Seconds      */
};

/**
 *  @struct   tsTimeObject_s
 *
 *  @brief    Time structure used to getting actual timing statistics.
 */
typedef struct tsTimeObject_s
{
	struct timeval original;    /**< Original time. */
	struct timeval previous;    /**< Previously set time. */
} tsTimeObject_t;


/**
 *  @struct   tsContext_s
 *
 *  @brief    Global context structure used for integrating into a variety of 
 *            enviroments. Includes operating system abstraction for dynamic 
 *            memory allocation and a FILE-like API for storing large buffers.
 *            Other global resources are also provided.
 */
typedef struct tsContext_s {
  ifmmcOsalDynMemContext_t memCxt;      /**< Dynamic memory allocation interface. */
  ifmmcOsalFileContext_t   fileCxt;     /**< FILE-like interface.                 */
  tword                   *scratch;     /**< Pointer to scratch memory.           */
  void (*getTime)(struct timeval *tv);  /**< Function pointer for obtaining the 
                                         *    system time.                        */
  void (*criticalBegin)(void);
  void (*criticalEnd)  (void);
} tsContext_t;

extern tsContext_t tsContext;           /**< Externally defined context structure.
                                         *    This must be populated with valid
                                         *    entries which dependent on the 
                                         *    operating environment.              */



// tsutils.c
/**
 *  @brief  Resets to current time.
 *
 *
 *  @param[in,out]  TimePtr    Pointer to a tsTimeObject_t.
 *
 */
int ts_reset_time( tsTimeObject_t *TimePtr );

/**
 *  @brief  Computes the amount of time since the tsTimeObject_t had been reset.
 *
 *
 *  @param[in,out]  TimePtr    Pointer to a tsTimeObject_t.
 *
 *  @return         Time delta in seconds.
 *
 */
float ts_get_delta_time(tsTimeObject_t *TimePtr);

/**
 *  @brief  Calculates the CRC value.
 *
 *
 *  @param[in]    SectionPtr    Pointer to beginning of memory on which to 
 *                              calculate the CRC value.
 *
 *  @param[in]    Length        Length in bytes of the memory section on which 
 *                              to calculate the CRC value.
 *
 *  @return       CRC value.
 *
 */
tulong ts_calculate_CRC(tword *SectionPtr, tulong Length);  //TSUtils.c

/* Externally defined */
tuint htons(tuint hval);
tulong htonl(tulong hval);

#endif /* _TS_H */
/* nothing past this point */
