/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



// ****************************************************************************
// TSDemux.c
// ****************************************************************************
//#include <ti/mas/mmcu/src/ts/c_include.h>
#include <string.h>
#include <ti/mas/mmcu/src/ts/tsdemux.h>

tlong tsDemux_get_PID_index(tsDemuxInst_t *inst, tlong PID);
tlong tsDemux_get_TS_payload(tword *TSDataPtr, tsDemuxInst_t *inst, tsDemuxPIDInfo_t *PIDQueuePtr, tlong PID, tlong BytesRemaining);
tlong tsDemux_get_TS_adaptation_field(tword *TSDataPtr, tsDemuxInst_t *inst, tsDemuxPIDInfo_t *PIDQueuePtr);
void tsDemux_update_TS_pkt_stats(tsDemuxInst_t *inst, tsDemuxPIDInfo_t *PIDQueuePtr);
tlong tsDemux_get_PSI_table_hdr(tword *TSDataPtr, tsDemuxInst_t *inst, tsDemuxPIDInfo_t *PIDQueuePtr, tsDemuxPSITable_t *TablePtr, tlong BytesRemaining);
tlong tsDemux_get_PSI_table( tsDemuxInst_t *inst, tsDemuxPSITable_t *TablePtr, tlong PID );
tlong tsDemux_is_PID_filtered(tsDemuxInst_t *inst, tlong PID);
tlong tsDemux_get_PMT(tword *TSDataPtr, tsDemuxInst_t *inst, tsDemuxPIDInfo_t *PIDQueuePtr, tlong PID, tlong BytesRemaining);
tlong tsDemux_filter_PID(tsDemuxInst_t *inst, tlong PID);
tlong tsDemux_add_program(tsDemuxPMTInfo_t *PMTInfoPtr,tlong Program);
tsDemuxPMTInfo_t *tsDemux_get_PMT_info(tsDemuxInst_t *inst, tlong PID);
tlong tsDemux_get_program_index(tsDemuxPMTInfo_t *PMTInfoPtr,tlong Program);
tlong tsDemux_get_PID_index_in_PMT(tsDemuxPMTProg_t *PMTProgPtr, tlong PID);
tlong tsDemux_get_TS_decriptor(tword *TSDataPtr, tsDemuxDescriptor_t *DescPtr, FILE *FilePtr);
tlong tsDemux_auto_select_program( tsDemuxInst_t *inst, tsDemuxPMTInfo_t *PMTQueuePtr );

tlong tsDemuxProcessTSPacket( tsDemuxInst_t *inst )
{
  /*
  tlong BufferLevel;
  */
	tlong TotalBytes, BytesRead, SyncFlag;
	tlong BytesUsed, HeaderBytes, Index;
	tint ShortWord;
	char Byte;
	tword *TSDataPtr;
	ifmmcOsalFileHandle_t DemuxBufferInfo;
	tsDemuxTSPktHdr_t *PktHeaderPtr;
	tsDemuxPIDInfo_t *PIDQueuePtr;
	tword TSData[2*188];

	PktHeaderPtr = (tsDemuxTSPktHdr_t *)&inst->PktHeader;
	PIDQueuePtr = (tsDemuxPIDInfo_t *)NULL;

  DemuxBufferInfo = inst->BufferInfo;

  BytesRead = tsContext.fileCxt.fread(DemuxBufferInfo, TSData, 188); 
	if(BytesRead == 0)
		return -1;
	TSDataPtr = (tword *)TSData;
	
	TotalBytes = 0;
	SyncFlag = FALSE;
	while(TotalBytes < 188)
	{
		Byte = *TSDataPtr++;
		TotalBytes++;
		if(Byte != 0x47)
			continue;
		SyncFlag = TRUE;
		
		memcpy( &ShortWord, TSDataPtr, 2 );
		ShortWord = htons( ShortWord );
		TSDataPtr += 2;
		TotalBytes += 2;
		PktHeaderPtr->TransportErrorIndicator = ShortWord >> 15;
		PktHeaderPtr->PayloadUnitStartIndicator = (ShortWord >> 14) & 1;
		PktHeaderPtr->TransportPriority = (ShortWord >> 13) & 1;
		PktHeaderPtr->PID = ShortWord & 0x1FFF;
    		
		Byte = *TSDataPtr++;
		TotalBytes++;
		PktHeaderPtr->TransportScrambingControl = Byte >> 6;
		PktHeaderPtr->AdaptationFieldControl = (Byte >> 4) & 0x3;
		PktHeaderPtr->ContinuityCounter = Byte & 0x0F;

		Index = tsDemux_get_PID_index(inst, PktHeaderPtr->PID);
		if(Index < 0)
			Index = inst->PIDQueueIndex - 1;
		PIDQueuePtr = (tsDemuxPIDInfo_t *)inst->PIDQueue[Index];

		if(PktHeaderPtr->TransportErrorIndicator == TRUE)
		{
			inst->TotalTEIPackets++;
			PIDQueuePtr->TEIPackets++;
		}
		if(PktHeaderPtr->TransportPriority == TRUE)
			PIDQueuePtr->PriorityPackets++;
		inst->HeaderBytes += 4;
		PIDQueuePtr->HeaderBytes += 4;
		BytesUsed = 0;
		switch(PktHeaderPtr->AdaptationFieldControl)
		{
			case 0:
				return tsDemux_INVALID_AF_CONTROL_VALUE;
			case 1:
				BytesUsed = tsDemux_get_TS_payload(TSDataPtr, inst, PIDQueuePtr, PktHeaderPtr->PID, 184);
				if(BytesUsed < 0)
				{
					TotalBytes += BytesUsed;
					goto EndOfPacket;
				}
				TSDataPtr += BytesUsed;
				break;
			case 2:
				BytesUsed = tsDemux_get_TS_adaptation_field(TSDataPtr, inst, PIDQueuePtr);
				if(BytesUsed < 0)
				{ 
					TotalBytes += BytesUsed;
					goto EndOfPacket;
				}
				TSDataPtr += BytesUsed;
				inst->HeaderBytes += BytesUsed;
				PIDQueuePtr->HeaderBytes += BytesUsed;
				if(inst->PATFound > 0)
					inst->PostPATPackets++;
				else
					inst->PrePATPackets++;
				PIDQueuePtr->TotalPackets++;
				break;
			case 3:
				HeaderBytes = tsDemux_get_TS_adaptation_field(TSDataPtr, inst, PIDQueuePtr);
				if(HeaderBytes < 0)
				{
					TotalBytes += BytesUsed;
					goto EndOfPacket;
				}
				TSDataPtr += HeaderBytes;
				inst->HeaderBytes += HeaderBytes;
				PIDQueuePtr->HeaderBytes += HeaderBytes;
				BytesUsed = tsDemux_get_TS_payload( TSDataPtr, inst, PIDQueuePtr, PktHeaderPtr->PID, 184 - HeaderBytes);
				TSDataPtr += BytesUsed;
				if(BytesUsed < 0)
				{
					TotalBytes += BytesUsed;
					goto EndOfPacket;
				}
				BytesUsed += HeaderBytes;
				break;
		}
		TotalBytes += BytesUsed;
	}
EndOfPacket:
	if(SyncFlag == TRUE)
	{
		inst->BytesProcessed += TotalBytes;
		tsDemux_update_TS_pkt_stats(inst, PIDQueuePtr);
		if(TotalBytes != 188)
		  TotalBytes += 0;
	}

	inst->TotalPackets++;

  if(PktHeaderPtr->PID == 0x1FFF)
    inst->TotalNullPackets++;

  return TotalBytes;
}

tuint tsDemux_get_PES_length(tword *PESHeader)
{
  tuint PacketLength = 0;

  if( (PESHeader[0] == 0) && 
      (PESHeader[1] == 0) && 
      (PESHeader[2] == 1) )
  {
    PacketLength = ( ((tuint)PESHeader[4] << 8) | (tuint)PESHeader[5] );
  }
  return (PacketLength);
}

tlong tsDemux_get_PES_payload(tword *TSDataPtr, tsDemuxInst_t *inst, tsDemuxPIDInfo_t *PIDQueuePtr, tlong PID, tlong BytesRemaining)
{
	tlong Delta, Status;
	tsDemuxPESInfo_t *PESMuxDmxInfoPtr;
	ifmmcOsalFileHandle_t PESBufferInfo;

	PESMuxDmxInfoPtr  = (tsDemuxPESInfo_t *)&PIDQueuePtr->u.PESInfo;
	PESBufferInfo     = PESMuxDmxInfoPtr->BufferInfo;

	if(PIDQueuePtr->TotalPackets == 0)
	{
		PIDQueuePtr->PID = PID;
	}
	else
	{
		Delta = inst->PktHeader.ContinuityCounter - PIDQueuePtr->ContinuityCtr;
		if(Delta != 1)
		{
			if((inst->PktHeader.ContinuityCounter == 0) && (Delta != -15))
				PIDQueuePtr->MissingPackets++;
		}
	}
	PIDQueuePtr->ContinuityCtr = inst->PktHeader.ContinuityCounter;

  if(PIDQueuePtr->Filter)
	{
		//if(inst->TotalPCRPackets == 0)
		//	goto EndOfPayload;
		if(PESMuxDmxInfoPtr->InitFlag == FALSE)
		{
			PESMuxDmxInfoPtr->InitFlag = TRUE;
			PESMuxDmxInfoPtr->BufferInfo = PESBufferInfo = tsContext.fileCxt.fopen();
      tsContext.fileCxt.fflush(PESBufferInfo);
		}
		if(inst->PktHeader.PayloadUnitStartIndicator == 1)
		{
      PESMuxDmxInfoPtr->PESSize = tsDemux_get_PES_length(TSDataPtr);

			tsContext.fileCxt.fwrite(PESBufferInfo, TSDataPtr, BytesRemaining);

			if(PESMuxDmxInfoPtr->Packets > 0)
			{
				Status = tsDemux_parse_PES_pkt( inst, PESMuxDmxInfoPtr ); 
			}

      PESMuxDmxInfoPtr->PESFrameInfo.PUSI_Time = ts_get_delta_time( &inst->StartTime );
			PESMuxDmxInfoPtr->PESFrameInfo.PUSI_PacketNumber = inst->TotalPackets;
			PESMuxDmxInfoPtr->PayloadSize = BytesRemaining;
			PESMuxDmxInfoPtr->Packets++;
		}
		else
		{
			if(PESMuxDmxInfoPtr->Packets > 0)
			{
				tsContext.fileCxt.fwrite(PESBufferInfo, TSDataPtr, BytesRemaining);
				PESMuxDmxInfoPtr->PayloadSize += BytesRemaining;
				PESMuxDmxInfoPtr->Packets++;
			}
		}

    if(PESMuxDmxInfoPtr->PESSize == PESMuxDmxInfoPtr->PayloadSize - 6) {
      Status = tsDemux_parse_PES_pkt( inst, PESMuxDmxInfoPtr );
      PESMuxDmxInfoPtr->Packets = 0;
    }
		//if(PESMuxDmxInfoPtr->PayloadSize > 0x800)
		//	PESMuxDmxInfoPtr->PayloadSize += 0;
	}
EndOfPayload:
	PIDQueuePtr->DataBytes += BytesRemaining;
	inst->DataBytes += BytesRemaining;
  return BytesRemaining;
}

tlong tsDemux_get_TS_payload(tword *TSDataPtr, tsDemuxInst_t *inst, tsDemuxPIDInfo_t *PIDQueuePtr, tlong PID, tlong BytesRemaining)
{
	tlong Result,BytesUsed,Bytes,Delta;
	tsDemuxPSITable_t *TablePtr;
	tsDemuxPSITableSection_t *TableSectPtr;
	tsDemuxTSPktHdr_t *PktHeaderPtr;

	PktHeaderPtr = (tsDemuxTSPktHdr_t *)&inst->PktHeader;

	BytesUsed = 0;
	switch(PID)
	{
		case 0:
			TablePtr = (tsDemuxPSITable_t *)&PIDQueuePtr->u.PATInfo.Table;
			if(PIDQueuePtr->u.PATInfo.TotalPackets == 0)
			{
				inst->PATFound = TRUE;
				PIDQueuePtr->u.PATInfo.PacketDelta.Min = 0x7FFFFFFF;
				PIDQueuePtr->PID = 0;
			}
			PIDQueuePtr->u.PATInfo.TotalPackets++;
			inst->PostPATPackets++;
			PIDQueuePtr->TotalPackets++;
			PIDQueuePtr->StreamType = ts_STREAM_TYPE_PAT;

			if(PktHeaderPtr->PayloadUnitStartIndicator == 1)
			{
				TablePtr->NewSectionFlag = TRUE;
				TablePtr->PUSI_Index = *TSDataPtr++;
				BytesRemaining--;
				BytesUsed++;
			}
			do
			{
				if(TablePtr->NewSectionFlag == TRUE)
				{
					TablePtr->NewSectionFlag = FALSE;

          Bytes = tsDemux_get_PSI_table_hdr(TSDataPtr, inst, PIDQueuePtr, TablePtr, BytesRemaining);
					if(Bytes < 0)
						return Bytes;
					TSDataPtr += Bytes;
					TableSectPtr = (tsDemuxPSITableSection_t *)&TablePtr->SectionInfo[TablePtr->Section];
					inst->StreamID = TableSectPtr->Extension;
				}
				else
				{
					TableSectPtr = (tsDemuxPSITableSection_t *)&TablePtr->SectionInfo[TablePtr->Section];
					Bytes = BytesRemaining;

          tsContext.fileCxt.fwrite(TableSectPtr->BufferInfo, TSDataPtr, BytesRemaining);
          TSDataPtr               += BytesRemaining;
          TableSectPtr->DataIndex += BytesRemaining;

					if(TableSectPtr->DataIndex == TableSectPtr->DataLength)
					{
						TablePtr->NewSectionFlag = TRUE;
						if(TablePtr->Section == TablePtr->LastSection)
							TablePtr->ProcessTableFlag = TRUE;
					}
				}
				if(TablePtr->ProcessTableFlag == TRUE)
				{
          Result = tsDemux_get_PSI_table( inst, TablePtr, PID );
					if(Result < 0)
						return Result;
					TablePtr->ProcessTableFlag = FALSE;
				}
				BytesUsed += Bytes;
				BytesRemaining -= Bytes;
			}while(BytesRemaining);
			break;
		case 1:
			BytesUsed += BytesRemaining;
			if(inst->PATFound != 0)
				inst->PostPATPackets++;
			else
				inst->PrePATPackets++;

			PIDQueuePtr->TotalPackets++;
			PIDQueuePtr->StreamType = ts_STREAM_TYPE_CAT;
			TSDataPtr += BytesRemaining;
			break;
		default:
			BytesUsed = BytesRemaining;
      if(inst->PATFound == TRUE)
			{
				inst->PostPATPackets++;
				if(tsDemux_is_PID_filtered(inst, PID) == TRUE)
				{
          if(PIDQueuePtr->StreamType < ts_STREAM_TYPE_PAT)
					{
						Bytes = tsDemux_get_PES_payload(TSDataPtr, inst, PIDQueuePtr, PID, BytesRemaining);
						if(Bytes < 0)
							return Bytes;
					}
					else if((PIDQueuePtr->StreamType == ts_STREAM_TYPE_PMT) || (PIDQueuePtr->StreamType == ts_STREAM_TYPE_NETWORK))
					{
            Bytes = tsDemux_get_PMT(TSDataPtr, inst, PIDQueuePtr, PID, BytesRemaining);
						if(Bytes < 0)
							return Bytes;
					}
					else
						Bytes = 0;
					BytesRemaining -= Bytes;
					PIDQueuePtr->TotalPackets++;
					TSDataPtr += BytesRemaining;
					return BytesUsed;
				}
			}
			else
				inst->PrePATPackets++;
			if(PIDQueuePtr->TotalPackets == 0)
			{
				PIDQueuePtr->PID = PID;
				if(PID == 0x1FFF)
				{
					PIDQueuePtr->StreamType = ts_STREAM_TYPE_NULL;
				}
			}
			else
			{
				Delta = PktHeaderPtr->ContinuityCounter - PIDQueuePtr->ContinuityCtr;
				if(Delta != 1)
				{
					if((PktHeaderPtr->ContinuityCounter == 0) && (Delta != -15))
						PIDQueuePtr->MissingPackets++;
				}
			}
			PIDQueuePtr->ContinuityCtr = PktHeaderPtr->ContinuityCounter;
			PIDQueuePtr->TotalPackets++;
			TSDataPtr += BytesRemaining;
			break;
	}
  return BytesUsed;
}

tlong tsDemux_get_TS_adaptation_field(tword *TSDataPtr, tsDemuxInst_t *inst, tsDemuxPIDInfo_t *PIDQueuePtr)
{
	tlong i, Index, LastIndex, BytesUsed, Length, ExtLength;
	long long DeltaPCR;
	unsigned long long BitRate;
	tlong Byte1, Byte2, Byte3;
	tulong LongWord;
	tuint ShortWord;
	char Byte;
	tulong Data1,Data2,Data3;
	tsDemuxTimestamp_t *PCRPtr, *LastPCRPtr;

	PIDQueuePtr->NumberOfAFs++;
	Length = *TSDataPtr++;
	if(Length == 0)
		return 1;
	BytesUsed = Length;
	Byte = *TSDataPtr++;
	PIDQueuePtr->AFPacketPtr.DiscontinuityIndicator = Byte >> 7;
	PIDQueuePtr->AFPacketPtr.RandomAccessIndicator = (Byte >> 6) & 1;
	PIDQueuePtr->AFPacketPtr.ESPriorityIndicator = (Byte >> 5) & 1;
	PIDQueuePtr->AFPacketPtr.PCRFlag = (Byte >> 4) & 1;
	PIDQueuePtr->AFPacketPtr.OPCRFlag = (Byte >> 3) & 1;
	PIDQueuePtr->AFPacketPtr.SplicingPointFlag = (Byte >> 2) & 1;
	PIDQueuePtr->AFPacketPtr.PrivateDataFlag = (Byte >> 1) & 1;
	PIDQueuePtr->AFPacketPtr.ExtensionFlag = Byte & 1;
	BytesUsed--;
	if(PIDQueuePtr->AFPacketPtr.PCRFlag == 1)
	{
	  inst->TotalPCRPackets++;

		Index = PIDQueuePtr->AFPacketPtr.PCRIndex;

		memcpy( &LongWord, TSDataPtr, 4 );
		LongWord = htonl( LongWord );
		TSDataPtr += 4;

		memcpy( &ShortWord, TSDataPtr, 2 );
		ShortWord = htons( ShortWord );
		TSDataPtr += 2;

		PCRPtr = (tsDemuxTimestamp_t *)&PIDQueuePtr->AFPacketPtr.PCR[Index];

		PCRPtr->Base = (unsigned long long)LongWord;
		PCRPtr->Base <<= 1;
		PCRPtr->Base |= (ShortWord >> 15) & 1;
		PCRPtr->Extension = ShortWord & 0x1FF;
		PCRPtr->Ctr = PIDQueuePtr->AFPacketPtr.PCRCount;
		PCRPtr->BytePos = inst->BytesProcessed;
		PCRPtr->PacketNumber = inst->TotalPackets;

		PCRPtr->ElapsedTime = ts_get_delta_time( &inst->StartTime);
		if(inst->TotalPCRPackets == 1)
			inst->PCRStart = *PCRPtr;

		if(PIDQueuePtr->AFPacketPtr.PCRCount > 0)
		{
			LastIndex = Index - 1;
			if(LastIndex < 0)
				LastIndex = 0;

			LastPCRPtr = (tsDemuxTimestamp_t *)&PIDQueuePtr->AFPacketPtr.PCR[LastIndex];
			DeltaPCR = PCRPtr->Base - LastPCRPtr->Base;
			BitRate = (PCRPtr->PacketNumber - LastPCRPtr->PacketNumber);
      if( DeltaPCR < 0 )
				DeltaPCR += (long long)0x200000000LL;

			if( BitRate > 0) 
			{
				BitRate *= 188 * 8 * 90000;
        if( DeltaPCR != 0 )
				  BitRate /= DeltaPCR;
				inst->BitRateViaPCR = (tulong)BitRate;
				if(inst->BitRateViaPCR < inst->MinBitRateViaPCR)
				{
					inst->MinBitRateViaPCR = inst->BitRateViaPCR;
				}
				if(inst->BitRateViaPCR > inst->MaxBitRateViaPCR)
				{
					inst->MaxBitRateViaPCR = inst->BitRateViaPCR;
				}
			}
		}

		PIDQueuePtr->AFPacketPtr.PCRCount++;
		PIDQueuePtr->AFPacketPtr.PCRIndex++;
		if(PIDQueuePtr->AFPacketPtr.PCRIndex >= tsDemux_PCR_OBJECTS_IN_QUEUE)
			PIDQueuePtr->AFPacketPtr.PCRIndex = 0;
		BytesUsed -= 6;
	}
	if(PIDQueuePtr->AFPacketPtr.OPCRFlag == 1)
	{
		Index = PIDQueuePtr->AFPacketPtr.OPCRIndex;

		memcpy( &LongWord, TSDataPtr, 4 );
		LongWord = htonl( LongWord );
		TSDataPtr += 4;

		memcpy( &ShortWord, TSDataPtr, 2 );
		ShortWord = htons( ShortWord );
		TSDataPtr += 2;

		PIDQueuePtr->AFPacketPtr.OPCR[Index].Base = LongWord;
		PIDQueuePtr->AFPacketPtr.OPCR[Index].Base <<= 1;
		PIDQueuePtr->AFPacketPtr.OPCR[Index].Base |= (ShortWord >> 15) & 1;
		PIDQueuePtr->AFPacketPtr.OPCR[Index].Extension = ShortWord & 0x7FFF;
		PIDQueuePtr->AFPacketPtr.OPCR[Index].Extension >>= 6;
		PIDQueuePtr->AFPacketPtr.OPCR[Index].BytePos = inst->BytesProcessed;
		PIDQueuePtr->AFPacketPtr.OPCR[Index].PacketNumber = inst->TotalPackets;
		PIDQueuePtr->AFPacketPtr.OPCRCount++;
		PIDQueuePtr->AFPacketPtr.OPCRIndex++;
		if(PIDQueuePtr->AFPacketPtr.OPCRIndex >= tsDemux_PCR_OBJECTS_IN_QUEUE)
			PIDQueuePtr->AFPacketPtr.OPCRIndex = 0;
		BytesUsed -= 6;
	}
	if(PIDQueuePtr->AFPacketPtr.SplicingPointFlag == 1)
	{
		PIDQueuePtr->AFPacketPtr.SpliceCountdown = *TSDataPtr++;
		BytesUsed--;
	}
	if(PIDQueuePtr->AFPacketPtr.PrivateDataFlag == 1)
	{
		PIDQueuePtr->AFPacketPtr.PrivateDataLength = *TSDataPtr++;
		for(i=0; i<PIDQueuePtr->AFPacketPtr.PrivateDataLength; i++)
			PIDQueuePtr->AFPacketPtr.PrivateData[i] = *TSDataPtr++;
		BytesUsed -= PIDQueuePtr->AFPacketPtr.PrivateDataLength + 1;
	}
	if(PIDQueuePtr->AFPacketPtr.ExtensionFlag == 1)
	{
		ExtLength = *TSDataPtr++;
		BytesUsed -= ExtLength + 1;
		Byte = *TSDataPtr++;
		PIDQueuePtr->AFPacketPtr.LTWFlag = (Byte >> 7) & 1;
		PIDQueuePtr->AFPacketPtr.PiecewiseRateFlag = (Byte >> 6) & 1;
		PIDQueuePtr->AFPacketPtr.SeamlessSpliceFlag = Byte & 0x3F;
		PIDQueuePtr->AFPacketPtr.SeamlessSpliceFlag >>= 5;
		ExtLength -= 2;
		if(PIDQueuePtr->AFPacketPtr.LTWFlag == 1)
		{
			memcpy( &ShortWord, TSDataPtr, 2 );
			ShortWord = htons( ShortWord );
			TSDataPtr += 2;
			PIDQueuePtr->AFPacketPtr.LTWValidFlag = ShortWord >> 15;
			PIDQueuePtr->AFPacketPtr.LTWOffset = ShortWord & 0x7FFF;
			ExtLength -= 2;
		}
		if(PIDQueuePtr->AFPacketPtr.PiecewiseRateFlag == 1)
		{
			Byte1 = *TSDataPtr++;
			Byte2 = *TSDataPtr++;
			Byte3 = *TSDataPtr++;
			PIDQueuePtr->AFPacketPtr.PiecewiseRate = (Byte1<<16) | (Byte2<<8) | Byte3;
			PIDQueuePtr->AFPacketPtr.PiecewiseRate &= 0x003FFFFF;
			ExtLength -= 3;
		}
		if(PIDQueuePtr->AFPacketPtr.SeamlessSpliceFlag == 1)
		{
			Data1 = *TSDataPtr++;
			PIDQueuePtr->AFPacketPtr.SpliceType = Data1 >> 4;
			PIDQueuePtr->AFPacketPtr.DTSNextAU.Base = (Data1>>3) & 0x1;
			PIDQueuePtr->AFPacketPtr.DTSNextAU.Base <<= 1;
			Data1 >>= 1;
			Data1 <<= 30;
			memcpy( &LongWord, TSDataPtr, 4 );
			Data2 = htonl( LongWord );
			TSDataPtr += 4;
			Data2 >>= 1;
			Data2 &= 0x7FFFFFFF;
			Data3 = Data2 >> 16;
			PIDQueuePtr->AFPacketPtr.DTSNextAU.Base |= Data1 | Data2 | Data3;
			ExtLength -= 5;
		}
		if(ExtLength > 0)
		{
			TSDataPtr += ExtLength;
		}
	}
	TSDataPtr += BytesUsed;
	PIDQueuePtr->StuffedBytes += BytesUsed;
	inst->StuffedBytes += BytesUsed;
	return Length + 1;
}

tlong tsDemux_get_PSI_table_hdr(tword *TSDataPtr, tsDemuxInst_t *inst, tsDemuxPIDInfo_t *PIDQueuePtr, tsDemuxPSITable_t *TablePtr, tlong BytesRemaining)
{
	tlong i,Version,BytesUsed,BytesLeft,BytesToProcess;
	tulong Data,SectionLength,Extension;
	tword HeaderData[8];
	tsDemuxPSITableSection_t *TableSectPtr;
	
	TablePtr->TableID = *TSDataPtr++;
	switch(TablePtr->TableID)
	{
		case 0:		// PAT
		case 1:		// CAT
		case 2:		// PMT
			HeaderData[0] = TablePtr->TableID;
			for(i=1; i<8; i++)
				HeaderData[i] = *TSDataPtr++;
			Data = (HeaderData[1]>>6) & 0x3;
			if(Data != 2)
				return tsDemux_PSI_TABLE_NOT_IN_LONG_FORM;
			SectionLength = (HeaderData[1] << 8) | HeaderData[2];
// Only retain lower 12 bits, upper 2 bits are reserved
			SectionLength &= 0x0FFF;
// Get Stream ID (PAT), Program Number (PMT)
			Extension = (HeaderData[3] << 8) | HeaderData[4];
// Remove lower 2 reserved bits
			Version = (HeaderData[5]>>1) & 0x1F;
			TablePtr->CurrentNextIndicator = HeaderData[5] & 0x1;
			TablePtr->Section = HeaderData[6];
			TablePtr->LastSection = HeaderData[7];
			TablePtr->Version = Version;
			if(TablePtr->LastSection >= tsDemux_MAX_TABLE_SECTS)
				return tsDemux_PSI_TABLE_MAX_SECTS_EXCEEDED;
			TableSectPtr = (tsDemuxPSITableSection_t *)&TablePtr->SectionInfo[TablePtr->Section];
			TableSectPtr->Extension = Extension;
			
      if(TableSectPtr->BufferInfo == NULL)
        TableSectPtr->BufferInfo = tsContext.fileCxt.fopen();

      tsContext.fileCxt.fflush(TableSectPtr->BufferInfo);
			tsContext.fileCxt.fwrite(TableSectPtr->BufferInfo, HeaderData, 8);

			TableSectPtr->DataIndex = 8;
			TableSectPtr->DataLength = SectionLength + 3;

			BytesToProcess = TableSectPtr->DataLength - 8;
			BytesLeft = BytesRemaining - 8;
			if(BytesToProcess > BytesLeft)
			{
				BytesToProcess = BytesLeft;
				BytesUsed = BytesRemaining;
			}
			else
			{
				BytesUsed = TableSectPtr->DataLength;
			}

      tsContext.fileCxt.fwrite(TableSectPtr->BufferInfo, TSDataPtr, BytesToProcess);
      TSDataPtr               += BytesToProcess;
      TableSectPtr->DataIndex += BytesToProcess;

			if(TableSectPtr->DataIndex == TableSectPtr->DataLength)
			{
				TablePtr->NewSectionFlag = TRUE;
				if(TablePtr->Section == TablePtr->LastSection)
					TablePtr->ProcessTableFlag = TRUE;
			}
			PIDQueuePtr->HeaderBytes += BytesUsed;
			inst->HeaderBytes += BytesUsed;
			break;
		case 0xFF:
			BytesUsed = BytesRemaining;
			BytesRemaining--;
			TSDataPtr += BytesRemaining;
			PIDQueuePtr->StuffedBytes += BytesUsed;
			inst->StuffedBytes += BytesUsed;
			break;
		default:
			BytesUsed = BytesRemaining;
			BytesRemaining--;
			TSDataPtr += BytesRemaining;
			break;
	}
	return BytesUsed;
}

tlong tsDemux_get_PSI_table( tsDemuxInst_t *inst, tsDemuxPSITable_t *TablePtr, tlong PID )
{
	tlong Index,BytesToProcess,BytesUsed,Program,PMT_PID,InfoLength,InfoBytes;
	tlong StreamType,ProgramNumber,ProgramIndex,ES_PIDIndex,PCR_PID,ES_PID;
	tlong FoundNewPCRFlag, LongWord;
	tint ShortWord;
	tulong CRC;
	tword *TableDataPtr;
  tword *TableData = (tword *)tsContext.scratch;
	tsDemuxPMTInfo_t *PMTQueuePtr;
	tsDemuxPMTProg_t *PMTProgPtr;
	tsDemuxPSITableSection_t *TableSectPtr;
	tsDemuxPIDInfo_t *PIDQueuePtr;

	TableSectPtr = (tsDemuxPSITableSection_t *)&TablePtr->SectionInfo[TablePtr->Section];
	BytesToProcess = TableSectPtr->DataIndex - 8;

  tsContext.fileCxt.fread(TableSectPtr->BufferInfo, TableData, TableSectPtr->DataIndex);
  TableDataPtr = &TableData[8];

	switch(TablePtr->TableID)
	{
// Program Assocation Table (PAT)
		case 0x00:
			while(BytesToProcess > 4)
			{
				BytesToProcess -= 4;
// Get program map Program Number
				memcpy( &LongWord, TableDataPtr, 4 );
				LongWord = htonl( LongWord );
				TableDataPtr += 4;
				Program = LongWord >> 13;
				Program >>= 3;
// Get program map PID
				PMT_PID = LongWord & 0x1FFF;

				Index = tsDemux_get_PID_index(inst, PMT_PID);
				if( (Index < 0) || (inst->PIDQueue[Index]->StreamType == 0) )
				{
					if(Index < 0)
						Index = inst->PIDQueueIndex - 1;
					tsDemux_filter_PID(inst, PMT_PID);

					PMTQueuePtr = (tsDemuxPMTInfo_t *)&((inst->PIDQueue[Index])->u.PMTInfo);

					tsDemux_add_program(PMTQueuePtr,Program);
					PMTQueuePtr->PID = PMT_PID;
					if(Program == 0)
					{
						inst->NetworkPID = PMT_PID;
						inst->PIDQueue[Index]->StreamType = ts_STREAM_TYPE_NETWORK;
					}
					else
					{
						inst->PIDQueue[Index]->StreamType = ts_STREAM_TYPE_PMT;
					}
					inst->PIDQueue[Index]->PID = PMT_PID;
				}
			}
			CRC = ts_calculate_CRC( &TableData[0], TableSectPtr->DataIndex - 4);
			memcpy( &LongWord, TableDataPtr, 4 );
			TableSectPtr->CRC = htonl( LongWord );
			TableDataPtr += 4;

      if( TableSectPtr->CRC && (CRC != TableSectPtr->CRC) ) {
				return tsDemux_BAD_CRC_CHECK;
      }

			break;
// Program Map Table (PMT)
		case 0x02:
			PMTQueuePtr = (tsDemuxPMTInfo_t *)tsDemux_get_PMT_info(inst, PID);
			if(PMTQueuePtr ==  NULL)
				return tsDemux_BAD_POINTER_TO_PMT_INDEX;
			ProgramNumber = PMTQueuePtr->Table.SectionInfo[PMTQueuePtr->Table.Section].Extension;
			ProgramIndex = tsDemux_get_program_index(PMTQueuePtr, ProgramNumber);
			if(ProgramIndex < 0)
			{
				ProgramIndex = PMTQueuePtr->ProgramNumberIndex - 1;
				return tsDemux_PMT_PROGRAM_NOT_FOUND_IN_PMT_QUEUE;
			}
			PMTProgPtr = (tsDemuxPMTProg_t *)&PMTQueuePtr->ProgramNumber[ProgramIndex];

			memcpy( &ShortWord, TableDataPtr, 2 );
			PCR_PID = htons( ShortWord );
			TableDataPtr += 2;
			PCR_PID &= 0x1FFF;

			PMTQueuePtr->ProgramNumber[ProgramIndex].PCR_PID = PCR_PID;
			FoundNewPCRFlag = FALSE;
			ES_PIDIndex = tsDemux_get_PID_index_in_PMT(PMTProgPtr, PCR_PID);
			if(ES_PIDIndex < 0)
			{
				FoundNewPCRFlag = TRUE;
				Index = tsDemux_get_PID_index(inst, PCR_PID);
				if(Index < 0)
					Index = inst->PIDQueueIndex - 1;
				inst->PIDQueue[Index]->PID = PCR_PID;
			}
			memcpy( &ShortWord, TableDataPtr, 2 );
			InfoLength = htons( ShortWord );
			TableDataPtr += 2;
			InfoLength &= 0xFFF;
			InfoBytes = InfoLength;
			while(InfoBytes > 0)
			{
				Index = tsDemux_get_PID_index(inst, PID);
				PIDQueuePtr = (tsDemuxPIDInfo_t *)inst->PIDQueue[Index];

        BytesUsed = tsDemux_get_TS_decriptor(TableDataPtr, &PIDQueuePtr->Descriptor, (FILE *)0);
        
				if(BytesUsed < 0)
					return BytesUsed;
				TableDataPtr += BytesUsed;
				InfoBytes -= BytesUsed;
			}
			BytesToProcess -= InfoLength + 4;
			while(BytesToProcess > 4)
			{
				StreamType = *TableDataPtr++;
			 	memcpy( &ShortWord, TableDataPtr, 2 );
				ES_PID = htons( ShortWord );
				TableDataPtr += 2;
				ES_PID &= 0x1FFF;

				ES_PIDIndex = tsDemux_get_PID_index_in_PMT(PMTProgPtr, ES_PID);
				if((ES_PIDIndex < 0) || (FoundNewPCRFlag == TRUE))
				{
					Index = tsDemux_get_PID_index(inst, ES_PID);
					if(Index < 0)
						Index = inst->PIDQueueIndex - 1;
					PIDQueuePtr = (tsDemuxPIDInfo_t *)inst->PIDQueue[Index];
					PIDQueuePtr->PID = ES_PID;
					PIDQueuePtr->StreamType = StreamType;
				}
			 	memcpy( &ShortWord, TableDataPtr, 2 );
				InfoLength = htons( ShortWord );
				TableDataPtr += 2;
				InfoLength &= 0x0FFF;
				InfoBytes = InfoLength;
				while(InfoBytes > 0)
				{
					Index = tsDemux_get_PID_index(inst, ES_PID);
					PIDQueuePtr = (tsDemuxPIDInfo_t *)inst->PIDQueue[Index];
          
          BytesUsed = tsDemux_get_TS_decriptor(TableDataPtr, &PIDQueuePtr->Descriptor, (FILE *)0);
          
					if(BytesUsed < 0)
						return BytesUsed;
					TableDataPtr += BytesUsed;
					InfoBytes -= BytesUsed;
				}
				BytesToProcess -= InfoLength + 5;
			}
			CRC = ts_calculate_CRC( &TableData[0], TableSectPtr->DataIndex - 4);
			memcpy( &LongWord, TableDataPtr, 4 );
			TableSectPtr->CRC = htonl( LongWord );
			TableDataPtr += 4;

			if( 0 && TableSectPtr->CRC && (CRC != TableSectPtr->CRC) )
				return tsDemux_BAD_CRC_CHECK;

			if( tsDemux_GET_FLAG(inst,tsDemux_AUTOSELECT_PROGRAM_FLAG) == TRUE) {
				tsDemux_auto_select_program( inst, PMTQueuePtr);
        tsDemux_SET_FLAG(inst,tsDemux_AUTOSELECT_PROGRAM_FLAG,FALSE);
      }
			break;
		default:
			break;
	}
	return tsDemux_SUCCESSFUL_RESULT;
}

tlong tsDemux_get_PMT(tword *TSDataPtr, tsDemuxInst_t *inst, tsDemuxPIDInfo_t *PIDQueuePtr, tlong PID, tlong BytesRemaining)
{
	tlong BytesUsed,Bytes;
	tsDemuxPSITable_t *TablePtr;
	tsDemuxPMTInfo_t *PMTQueuePtr;
	tsDemuxPSITableSection_t *TableSectPtr;

	BytesUsed = 0;
	PMTQueuePtr = (tsDemuxPMTInfo_t *)tsDemux_get_PMT_info(inst, PID);
	if(PMTQueuePtr ==  NULL)
		return tsDemux_BAD_POINTER_TO_PMT_INDEX;
	TablePtr = (tsDemuxPSITable_t *)&PMTQueuePtr->Table;

	if(inst->PktHeader.PayloadUnitStartIndicator == 1)
	{
		TablePtr->NewSectionFlag = TRUE;
		TablePtr->PUSI_Index = *TSDataPtr++;
		BytesRemaining--;
		BytesUsed++;
	}
	do
	{
		if(TablePtr->NewSectionFlag == TRUE)
		{
			TablePtr->NewSectionFlag = FALSE;
			Bytes = tsDemux_get_PSI_table_hdr(TSDataPtr, inst, PIDQueuePtr, TablePtr, BytesRemaining);
			TSDataPtr += Bytes;
			BytesRemaining -= Bytes;
			BytesUsed += Bytes;
			TableSectPtr = (tsDemuxPSITableSection_t *)&TablePtr->SectionInfo[TablePtr->Section];
		}
		else
		{
			TableSectPtr = (tsDemuxPSITableSection_t *)&TablePtr->SectionInfo[TablePtr->Section];

      tsContext.fileCxt.fwrite(TableSectPtr->BufferInfo, TSDataPtr, BytesRemaining);
      TSDataPtr               += BytesRemaining;
      TableSectPtr->DataIndex += BytesRemaining;
			BytesUsed               += BytesRemaining;
			BytesRemaining  = 0;
			if(TableSectPtr->DataIndex == TableSectPtr->DataLength)
			{
				TablePtr->NewSectionFlag = TRUE;
				if(TablePtr->Section == TablePtr->LastSection)
					TablePtr->ProcessTableFlag = TRUE;
			}
		}
		if(TablePtr->ProcessTableFlag == TRUE)
		{
			tsDemux_get_PSI_table( inst, TablePtr, PID );
			TablePtr->ProcessTableFlag = FALSE;
		}
	}while(BytesRemaining > 0);

	return BytesUsed;
}

tlong tsDemux_auto_select_program( tsDemuxInst_t *inst, tsDemuxPMTInfo_t *PMTQueuePtr )
{
	tlong Index,i;
  tint  AudioPID = 0, VideoPID = 0;
	tsDemuxPMTProg_t *PMTProgPtr;
	tsDemuxPIDInfo_t *PIDQueuePtr;

	Index = tsDemux_get_PID_index(inst, PMTQueuePtr->PID);
	PIDQueuePtr = (tsDemuxPIDInfo_t *)inst->PIDQueue[Index];
	if(PIDQueuePtr->StreamType == ts_STREAM_TYPE_PMT)
	{
// Select 1st Program in PMT
		PMTProgPtr = (tsDemuxPMTProg_t *)&PMTQueuePtr->ProgramNumber[0];
		for(i=0; i<PMTProgPtr->ES_PIDsIndex; i++)
		{
			Index = tsDemux_get_PID_index(inst, PMTProgPtr->ES_PID[i]);
			PIDQueuePtr = (tsDemuxPIDInfo_t *)inst->PIDQueue[Index];
			switch(PIDQueuePtr->StreamType)
			{
				case ts_STREAM_TYPE_MPEG1_VIDEO:
				case ts_STREAM_TYPE_MPEG2_VIDEO:
				case ts_STREAM_TYPE_H264_VIDEO:
        case ts_STREAM_TYPE_MPEG4_VIDEO:
					if(VideoPID == 0)
					{
            VideoPID = PMTProgPtr->ES_PID[i];
						tsDemux_filter_PID(inst, PMTProgPtr->ES_PID[i]);
					}
					break;
				case ts_STREAM_TYPE_MPEG1_AUDIO:
				case ts_STREAM_TYPE_MPEG2_AUDIO:
				case ts_STREAM_TYPE_AC3_AUDIO:
				case ts_STREAM_TYPE_AAC_AUDIO:
					if(AudioPID == 0)
					{
            AudioPID = PMTProgPtr->ES_PID[i];
						tsDemux_filter_PID(inst, PMTProgPtr->ES_PID[i]);
					}
					break;
			}
		}
		return PMTQueuePtr->PID;
	}
	else
		return 0;
}

tlong tsDemux_add_program(tsDemuxPMTInfo_t *PMTQueuePtr,tlong Program)
{
	tlong Index;

	for(Index=0; Index<PMTQueuePtr->ProgramNumberIndex; Index++)
	{
		if(Program == PMTQueuePtr->ProgramNumber[Index].Program)
		{
			return Index;
		}
	}
	PMTQueuePtr->ProgramNumber[PMTQueuePtr->ProgramNumberIndex++].Program = Program;
	return Index;
}


tsDemuxPMTInfo_t *tsDemux_get_PMT_info(tsDemuxInst_t *inst, tlong PID)
{
	tlong Index;
	tsDemuxPIDInfo_t *PIDQueuePtr;

	PIDQueuePtr = inst->PIDQueue[0];
	for(Index=0; Index<inst->PIDQueueIndex; Index++)
	{
		if(PID == inst->PIDQueue[Index]->PID)
			return &inst->PIDQueue[Index]->u.PMTInfo;
	}
	return NULL;
}


tlong tsDemux_get_program_index(tsDemuxPMTInfo_t *PMTQueuePtr,tlong Program)
{
	tlong Index;

	for(Index=0; Index<PMTQueuePtr->ProgramNumberIndex; Index++)
	{
		if(Program == PMTQueuePtr->ProgramNumber[Index].Program)
		{
			return Index;
		}
	}
	PMTQueuePtr->ProgramNumber[PMTQueuePtr->ProgramNumberIndex++].Program = Program;
	return -1;
}


tlong tsDemux_filter_PID(tsDemuxInst_t *inst, tlong PID)
{
	tlong Index;

	for(Index=0; Index<inst->PIDQueueIndex; Index++)
	{
		if(PID == inst->PIDQueue[Index]->PID)
		{
			if(inst->PIDQueue[Index]->Filter == FALSE) {
				inst->PIDQueue[Index]->Filter = TRUE;
				return TRUE;
			}else{
				return FALSE;
			}
		}
	}
	//Add PID to PIDQueue?
  return(FALSE);
}

tlong tsDemux_unfilter_PID(tsDemuxInst_t *inst, tlong PID)
{
	tlong Index;

	for(Index=0; Index<inst->PIDQueueIndex; Index++)
	{
		if(PID == inst->PIDQueue[Index]->PID)
		{
			if(inst->PIDQueue[Index]->Filter==FALSE) {
				return FALSE;
			}else{
				inst->PIDQueue[Index]->Filter = FALSE;
				return TRUE;
			}
		}
	}
	return FALSE;
}

tlong tsDemux_is_PID_filtered(tsDemuxInst_t *inst, tlong PID)
{
	tlong Index;

	for(Index=0; Index<inst->PIDQueueIndex; Index++)
	{
		if( (PID == inst->PIDQueue[Index]->PID) && (inst->PIDQueue[Index]->Filter != FALSE) )
		{
			return TRUE;
		}
	}
	return FALSE;
}


tlong tsDemux_get_PID_index(tsDemuxInst_t *inst, tlong PID)
{
	tlong Index;

	for(Index=0; Index<inst->PIDQueueIndex; Index++)
	{
		if(PID == inst->PIDQueue[Index]->PID)
		{
			return Index;
		}
	}
	inst->PIDQueue[inst->PIDQueueIndex] = (tsDemuxPIDInfo_t *)tsContext.memCxt.alloc(0,tsContext.memCxt.memHandle);
  memset(inst->PIDQueue[inst->PIDQueueIndex], 0, sizeof(tsDemuxPIDInfo_t));
	inst->PIDQueue[inst->PIDQueueIndex++]->PID = PID;
	return -1;
}

tlong tsDemux_add_PID(tsDemuxInst_t *inst, tlong PID)
{
	tlong Index;

	for(Index=0; Index<inst->PIDQueueIndex; Index++)
	{
		if(PID == inst->PIDQueue[Index]->PID)
		{
			return FALSE;
		}
	}
  inst->PIDQueue[inst->PIDQueueIndex] = (tsDemuxPIDInfo_t *)tsContext.memCxt.alloc(0,tsContext.memCxt.memHandle);
  memset(inst->PIDQueue[inst->PIDQueueIndex], 0, sizeof(tsDemuxPIDInfo_t));
	inst->PIDQueue[inst->PIDQueueIndex++]->PID = PID;
	return TRUE;
}

tlong tsDemux_get_PID_index_in_PMT(tsDemuxPMTProg_t *PMTProgPtr, tlong PID)
{
	tlong Index;

	for(Index=0; Index<PMTProgPtr->ES_PIDsIndex; Index++)
	{
		if(PID == PMTProgPtr->ES_PID[Index])
		{
			return Index;
		}
	}
	PMTProgPtr->ES_PID[PMTProgPtr->ES_PIDsIndex++] = PID;
	return -1;
}

void tsDemux_update_TS_pkt_stats(tsDemuxInst_t *inst, tsDemuxPIDInfo_t *PIDQueuePtr)
{
	tlong DeltaPacket;
	tsDemuxPktDelta_t *PacketDeltaPtr;

	PacketDeltaPtr = (tsDemuxPktDelta_t *)&PIDQueuePtr->PacketDelta;
	if(PIDQueuePtr->TotalPackets > 1)
	{
		DeltaPacket = inst->TotalPackets - PacketDeltaPtr->LastPacket;
		PacketDeltaPtr->Total += DeltaPacket;
		if(DeltaPacket < PacketDeltaPtr->Min)
			PacketDeltaPtr->Min = DeltaPacket;
		if(DeltaPacket > PacketDeltaPtr->Max)
			PacketDeltaPtr->Max = DeltaPacket;
		PacketDeltaPtr->Avg = PacketDeltaPtr->Total/(PIDQueuePtr->TotalPackets - 1);
	}
	else
	{
		PIDQueuePtr->PacketDelta.Min = 0x7FFFFFFF;
	}
	PacketDeltaPtr->LastPacket = inst->TotalPackets;
}

// ****************************************************************************
// Public APIs
// ****************************************************************************

void tsDemuxOpen(void *tsInst, ifmmcOsalFileHandle_t fileHandle)
{
  int i, Size, MuxIndex;
  tsDemuxInst_t *inst = (tsDemuxInst_t *)tsInst;

	if( inst == NULL )
		return;// -1;

	inst->MinPESPacketLength = 0x7FFFFFFF;
	tsDemux_SET_FLAG(inst,tsDemux_AUTOSELECT_PROGRAM_FLAG,FALSE);
	inst->MinBitRateViaPCR = 0xFFFFFFFF;
  
  inst->BufferInfo = fileHandle;
}

/* Need to decend further inot the structures... */
void tsDemuxClose(void *tsInst)
{
  tsDemuxInst_t *inst = (tsDemuxInst_t *)tsInst;
  ifmmcOsalFileHandle_t BufferInfo;
  tlong   i,j;
  
  for( i=0; i<inst->PIDQueueIndex; i++) {
    tsDemuxPIDInfo_t *PIDQueuePtr = inst->PIDQueue[i];

    if ( PIDQueuePtr->StreamType < ts_STREAM_TYPE_PAT) {
      if( (BufferInfo = PIDQueuePtr->u.PESInfo.BufferInfo) != NULL) {
        tsContext.fileCxt.fflush(BufferInfo);
        tsContext.memCxt.free(0,tsContext.memCxt.memHandle,BufferInfo);
        PIDQueuePtr->u.PESInfo.BufferInfo = NULL;
      }
    } else if ( PIDQueuePtr->StreamType == ts_STREAM_TYPE_PAT) {
      for( j=0; j<tsDemux_MAX_TABLE_SECTS; j++) {
        if( (BufferInfo = PIDQueuePtr->u.PATInfo.Table.SectionInfo[j].BufferInfo) != NULL) {
          tsContext.fileCxt.fflush(BufferInfo);
          tsContext.memCxt.free(0,tsContext.memCxt.memHandle,BufferInfo);
          PIDQueuePtr->u.PATInfo.Table.SectionInfo[j].BufferInfo = NULL;
        }
      }
    } else if ( PIDQueuePtr->StreamType == ts_STREAM_TYPE_PMT) {
      for( j=0; j<tsDemux_MAX_TABLE_SECTS; j++) {
        if( (BufferInfo = PIDQueuePtr->u.PMTInfo.Table.SectionInfo[j].BufferInfo) != NULL) {
          tsContext.fileCxt.fflush(BufferInfo);
          tsContext.memCxt.free(0,tsContext.memCxt.memHandle,BufferInfo);
          PIDQueuePtr->u.PMTInfo.Table.SectionInfo[j].BufferInfo = NULL;
        }
      }
    }
    tsContext.memCxt.free(0,tsContext.memCxt.memHandle,PIDQueuePtr);
    inst->PIDQueue[i] = NULL;
  }

  inst->PIDQueueIndex = 0;
}


tlong tsDemuxParseHeader(void *tsInst)
{
  tsDemuxInst_t *inst = (tsDemuxInst_t *)tsInst;
  tlong i, retval;

  while(!tsContext.fileCxt.feof(inst->BufferInfo))
  {
    if(inst->PATFound)
    {
      for( i=0; i<inst->PIDQueueIndex; i++)
      {
        tsDemuxPIDInfo_t *PIDQueuePtr = (tsDemuxPIDInfo_t *)inst->PIDQueue[i];
        if( PIDQueuePtr->StreamType == ts_STREAM_TYPE_PMT)
        {
          //Detect if PMT received and processed
          if(PIDQueuePtr->TotalPackets == 0)
            break;
        }
      }
      if( i == inst->PIDQueueIndex)
        return(0);
    }
    retval = tsDemuxProcessTSPacket(inst);
  }
  return (-1);
}

tint tsDemuxGetStreamInfo(void *tsInst, tsDemuxStreamInfo_t *streamInfo)
{
  tsDemuxInst_t *inst = (tsDemuxInst_t *)tsInst;
  tlong retval;
  tint  i, j, streamIdx = 0, PIDQueueIdx;

  retval = tsDemuxParseHeader(tsInst);
  if(retval < 0)
    return (retval);

  for ( i=0; i<inst->PIDQueueIndex; i++)
  {
    tsDemuxPIDInfo_t *PIDQueuePtr = inst->PIDQueue[i];

    if(PIDQueuePtr->StreamType == ts_STREAM_TYPE_PMT) {
      for(j=0; j < PIDQueuePtr->u.PMTInfo.ProgramNumber[0].ES_PIDsIndex; j++) 
      {
        streamInfo->esInfo[streamIdx].PID     = PIDQueuePtr->u.PMTInfo.ProgramNumber[0].ES_PID[j];
        streamInfo->esInfo[streamIdx].PMT_PID = PIDQueuePtr->PID;

        PIDQueueIdx = tsDemux_get_PID_index(inst, PIDQueuePtr->u.PMTInfo.ProgramNumber[0].ES_PID[j]);
        if(PIDQueueIdx < 0)
          PIDQueueIdx = inst->PIDQueueIndex;

        streamInfo->esInfo[streamIdx].StreamType = inst->PIDQueue[PIDQueueIdx]->StreamType;
        streamIdx++;
      }
    }
  }
  streamInfo->nStreams = streamIdx;
  return (0);
}

tint tsDemuxSelectStream(void *tsInst, tint nStreams, tuint *PIDs)
{
  tsDemuxInst_t *inst = (tsDemuxInst_t *)tsInst;
  tint  i;

  for( i=0; i<inst->PIDQueueIndex; i++) 
    inst->PIDQueue[i]->Filter = 0;

  for( i=0; i<nStreams; i++) 
    tsDemux_filter_PID(inst, PIDs[i]);

  return(0);
}

void tsDemuxGetSuppInfo(tsDemuxPIDInfo_t *PIDInfoPtr, tsDemuxFrameSuppInfo_t *suppInfo)
{
  tlong ObjectIndex;
  tsDemuxPESInfo_t *PESInfoPtr = &PIDInfoPtr->u.PESInfo;
    
  if(PESInfoPtr->PESFrameInfo.PTSFoundFlag == TRUE) {
    ObjectIndex = PESInfoPtr->PTSIndex - 1;
    if(ObjectIndex < 0)
      ObjectIndex = tsDemux_PTS_OBJECTS_IN_QUEUE - 1;
    PESInfoPtr->PESFrameInfo.PTSTimeStamp = PESInfoPtr->PTS[ObjectIndex].Base;
    PESInfoPtr->PESFrameInfo.PTSCount++;
  }else{
    PESInfoPtr->PESFrameInfo.PTSTimeStamp += PESInfoPtr->PESFrameInfo.TicksPerFrame;
  }
  if(PESInfoPtr->PESFrameInfo.DTSFoundFlag == TRUE) {
    ObjectIndex = PESInfoPtr->DTSIndex - 1;
    if(ObjectIndex < 0)
      ObjectIndex = tsDemux_DTS_OBJECTS_IN_QUEUE - 1;
    PESInfoPtr->PESFrameInfo.DTSTimeStamp = PESInfoPtr->DTS[ObjectIndex].Base;
    PESInfoPtr->PESFrameInfo.DTSCount++;
  }else{
    //PESInfoPtr->PESFrameInfo.DTSTimeStamp += PESInfoPtr->PESFrameInfo.TicksPerFrame;
    PESInfoPtr->PESFrameInfo.DTSTimeStamp = 0;
  }

  suppInfo->PID         = PIDInfoPtr->PID;
  suppInfo->streamType  = PIDInfoPtr->StreamType;
  suppInfo->PTS         = PESInfoPtr->PESFrameInfo.PTSTimeStamp;
  suppInfo->DTS         = PESInfoPtr->PESFrameInfo.DTSTimeStamp;
}

tlong tsDemuxGetFrame(void *tsInst, ifmmcDemuxOutput_t *demuxOutput)
{
  tsDemuxInst_t *inst = (tsDemuxInst_t *)tsInst;
  tsDemuxFrameSuppInfo_t suppInfo;
  tlong retval, i;

  demuxOutput->bitStream.size = 0;
  while(!tsContext.fileCxt.feof(inst->BufferInfo))
  {
    for( i=0; i<inst->PIDQueueIndex; i++) {
      tsDemuxPIDInfo_t *PIDQueuePtr = inst->PIDQueue[i];

      if( (PIDQueuePtr->Filter == TRUE) && 
          (PIDQueuePtr->StreamType < ts_STREAM_TYPE_PAT) &&
          (PIDQueuePtr->u.PESInfo.PESFrameInfo.FrameSize > 0) )
      {
        demuxOutput->bitStream.size = tsContext.fileCxt.fread( PIDQueuePtr->u.PESInfo.PESFrameInfo.BufferInfo,
                                                            demuxOutput->bitStream.ptr,
                                                            PIDQueuePtr->u.PESInfo.PESFrameInfo.FrameSize);
        PIDQueuePtr->u.PESInfo.PESFrameInfo.FrameSize = 0;
	      /* Process timestamp */
        tsDemuxGetSuppInfo(PIDQueuePtr, &suppInfo);
        demuxOutput->ESID = suppInfo.PID;

        switch (suppInfo.streamType) {
          case ts_STREAM_TYPE_MPEG1_VIDEO: 
          case ts_STREAM_TYPE_MPEG2_VIDEO: 
          case ts_STREAM_TYPE_MPEG4_VIDEO: 
          case ts_STREAM_TYPE_H264_VIDEO:
            demuxOutput->timestamp = suppInfo.DTS;
            demuxOutput->mediaType = ifvisys_MEDIA_TYPE_VIDEO;
            break;
          case ts_STREAM_TYPE_MPEG1_AUDIO:
          case ts_STREAM_TYPE_MPEG2_AUDIO:
          case ts_STREAM_TYPE_AAC_AUDIO:
          case ts_STREAM_TYPE_AC3_AUDIO:
            demuxOutput->timestamp = suppInfo.PTS;
            demuxOutput->mediaType = ifvisys_MEDIA_TYPE_AUDIO;
            break;
        }
        return(demuxOutput->bitStream.size);
      }
    }

    retval = tsDemuxProcessTSPacket( inst );
  }

  
  return(0);
}

/* nothing past this point */
