/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



// ****************************************************************************
// TSDescriptors.c
// ****************************************************************************
#include <string.h>
#include <ti/mas/mmcu/src/ts/tsdemux.h>

int tsDemux_get_TS_decriptor(tword *TSDataPtr, tsDemuxDescriptor_t *DescPtr, FILE *FilePtr)
{
	int i,Tag,Length,BytesUsed;
	int LongWord, Byte1, Byte2, Byte3;
	short ShortWord;
	char Byte;

	Tag = *TSDataPtr++;
	Length = *TSDataPtr++;
	BytesUsed = Length + 2;

	switch(Tag)
	{
		case 0:
		case 1:
			return tsDemux_BAD_DESCRIPTOR_TAG; 
			break;
// Video stream Descriptor
		case 2:
			if(DescPtr->VideoStreamDesc.Counter == 0)
			{
				DescPtr->TagArray[DescPtr->NumberOfDescriptors] = Tag;
				DescPtr->NumberOfDescriptors++;
			}
			Byte = *TSDataPtr++;
			DescPtr->VideoStreamDesc.MultipleFrameRateFlag = (Byte >> 7) & 1;
			DescPtr->VideoStreamDesc.FrameRateCode = (Byte >> 3) & 0x0F;
			DescPtr->VideoStreamDesc.MPEG2Flag = (Byte >> 2) & 1;
			DescPtr->VideoStreamDesc.ConstrainedParameterFlag = (Byte >> 1) & 1;
			DescPtr->VideoStreamDesc.StillPictureFlag = Byte & 1;
			DescPtr->VideoStreamDesc.ProfileLevelIndication = *TSDataPtr++;
			Byte = *TSDataPtr++;
			DescPtr->VideoStreamDesc.ChromaFormat = (Byte >> 6) & 3;
			DescPtr->VideoStreamDesc.FrameRateExtFlag = (Byte >> 5) & 1;
			DescPtr->VideoStreamDesc.FrameRateExtFlag >>= Byte & 0x1F;
			if(FilePtr != NULL)
			{
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," Video Stream Descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr,"Frame Rate Code = %d\r\n",DescPtr->VideoStreamDesc.MultipleFrameRateFlag);
				fprintf(FilePtr,"MPEG2 Flag = %d\r\n",DescPtr->VideoStreamDesc.MPEG2Flag);
				fprintf(FilePtr,"Constrained Parameter Flag = %d\r\n",DescPtr->VideoStreamDesc.ConstrainedParameterFlag);
				fprintf(FilePtr,"Still Picture Flag = %d\r\n",DescPtr->VideoStreamDesc.StillPictureFlag);
				fprintf(FilePtr,"Profile Level Indication = %d\r\n",DescPtr->VideoStreamDesc.ProfileLevelIndication);
				fprintf(FilePtr,"Chroma Format = %d\r\n",DescPtr->VideoStreamDesc.ChromaFormat);
				fprintf(FilePtr,"Frame Rate Ext Flag = %d\r\n",DescPtr->VideoStreamDesc.FrameRateExtFlag);
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," End of descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n\r\n");
			}
			DescPtr->VideoStreamDesc.Counter++;
			break;
// Audio stream Descriptor
		case 3:
			if(DescPtr->AudioStreamDesc.Counter == 0)
			{
				DescPtr->TagArray[DescPtr->NumberOfDescriptors] = Tag;
				DescPtr->NumberOfDescriptors++;
			}
			Byte = *TSDataPtr++;
			DescPtr->AudioStreamDesc.FreeFormat = (Byte >> 7) & 1;
			DescPtr->AudioStreamDesc.ID = (Byte >> 6) & 1;
			DescPtr->AudioStreamDesc.Layer = Byte & 0x3F;
			DescPtr->AudioStreamDesc.Layer >>= 4;
			if(FilePtr != NULL)
			{
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," Audio Stream Descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr,"Free Format = %d\r\n",DescPtr->AudioStreamDesc.FreeFormat);
				fprintf(FilePtr,"ID = %d\r\n",DescPtr->AudioStreamDesc.ID);
				fprintf(FilePtr,"Layer = %d\r\n",DescPtr->AudioStreamDesc.Layer);
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," End of descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n\r\n");
			}
			DescPtr->AudioStreamDesc.Counter++;
			break;
// Hierarchy Descriptor
		case 4:
			if(DescPtr->HeirarcyDesc.Counter == 0)
			{
				DescPtr->TagArray[DescPtr->NumberOfDescriptors] = Tag;
				DescPtr->NumberOfDescriptors++;
			}
			DescPtr->HeirarcyDesc.HiearchyType = *TSDataPtr++;
			DescPtr->HeirarcyDesc.HiearchyType &= 0xF;
			DescPtr->HeirarcyDesc.HiearchyLayerIndex = *TSDataPtr++;
			DescPtr->HeirarcyDesc.HiearchyLayerIndex &= 0x3F;
			DescPtr->HeirarcyDesc.HiearchyEmbeddedLayer = *TSDataPtr++;
			DescPtr->HeirarcyDesc.HiearchyEmbeddedLayer &= 0x3F;
			DescPtr->HeirarcyDesc.HiearchyPriority = *TSDataPtr++;
			DescPtr->HeirarcyDesc.HiearchyPriority &= 0x3F;
			if(FilePtr != NULL)
			{
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," Hierarchy Descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr,"Hiearchy Type = %d\r\n",DescPtr->HeirarcyDesc.HiearchyType);
				fprintf(FilePtr,"Hiearchy Layer Index = %d\r\n",DescPtr->HeirarcyDesc.HiearchyLayerIndex);
				fprintf(FilePtr,"Hiearchy Embedded Layer = %d\r\n",DescPtr->HeirarcyDesc.HiearchyEmbeddedLayer);
				fprintf(FilePtr,"Hiearchy Priority = %d\r\n",DescPtr->HeirarcyDesc.HiearchyPriority );
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," End of descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n\r\n");
			}
			DescPtr->HeirarcyDesc.Counter++;
			break;
// Registration Descriptor
		case 5:
			if(DescPtr->RegistrationDesc.Counter == 0)
			{
				DescPtr->TagArray[DescPtr->NumberOfDescriptors] = Tag;
				DescPtr->NumberOfDescriptors++;
			}

			memcpy(&DescPtr->RegistrationDesc.FormatID, TSDataPtr, 4);
			DescPtr->RegistrationDesc.FormatID = htonl(DescPtr->RegistrationDesc.FormatID);
			TSDataPtr += 4;
			Length -= 4;
			if(FilePtr != NULL)
			{
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," Registration Descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," End of descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n\r\n");
			}
			if(Length > 0)
			{
				if(DescPtr->RegistrationDesc.AdditionalInfoPtr == NULL)
          DescPtr->RegistrationDesc.AdditionalInfoPtr = (char *)tsContext.memCxt.alloc(0,tsContext.memCxt.memHandle);
				for(i=0; i<Length; i++)
					DescPtr->RegistrationDesc.AdditionalInfoPtr[i] = *TSDataPtr++;
			}
			DescPtr->RegistrationDesc.Counter++;
			break;
// Data stream alignment Descriptor
		case 6:
			if(DescPtr->DataStreamAlignDesc.Counter == 0)
			{
				DescPtr->TagArray[DescPtr->NumberOfDescriptors] = Tag;
				DescPtr->NumberOfDescriptors++;
			}
			DescPtr->DataStreamAlignDesc.AlignmentType = *TSDataPtr++;
			if(FilePtr != NULL)
			{
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," Data Stream Alignment Descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr,"Alignment Type = %d\r\n",DescPtr->DataStreamAlignDesc.AlignmentType);
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," End of descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n\r\n");
			}
			DescPtr->DataStreamAlignDesc.Counter++;
			break;
// Target background grid Descriptor
		case 7:
			if(DescPtr->TargetBackgroundGridDesc.Counter == 0)
			{
				DescPtr->TagArray[DescPtr->NumberOfDescriptors] = Tag;
				DescPtr->NumberOfDescriptors++;
			}

			memcpy(&LongWord, TSDataPtr, 4);
			LongWord = htonl(LongWord);
			TSDataPtr += 4;
			DescPtr->TargetBackgroundGridDesc.HorizontalSize = (LongWord >> 18) & 0x3FFF;
			DescPtr->TargetBackgroundGridDesc.VerticalSize = (LongWord >> 4) & 0x3FFF;
			DescPtr->TargetBackgroundGridDesc.PixelAspectRatio = LongWord & 0x0F;
			if(FilePtr != NULL)
			{
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," Target Background Grid Descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr,"Horizontal Size = %d\r\n",DescPtr->TargetBackgroundGridDesc.HorizontalSize);
				fprintf(FilePtr,"Vertical Size = %d\r\n",DescPtr->TargetBackgroundGridDesc.VerticalSize);
				fprintf(FilePtr,"Pixel Aspect Ratio = %d\r\n",DescPtr->TargetBackgroundGridDesc.PixelAspectRatio);
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," End of descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n\r\n");
			}
			DescPtr->TargetBackgroundGridDesc.Counter++;
			break;
// Video window Descriptor
		case 8:
			if(DescPtr->VideoWindowDesc.Counter == 0)
			{
				DescPtr->TagArray[DescPtr->NumberOfDescriptors] = Tag;
				DescPtr->NumberOfDescriptors++;
			}

			memcpy(&LongWord, TSDataPtr, 4);
			LongWord = htonl(LongWord);
			TSDataPtr += 4;
			DescPtr->VideoWindowDesc.HorizontalOffset = (LongWord >> 18) & 0x3FFF;
			DescPtr->VideoWindowDesc.VerticalOffset = (LongWord >> 4) & 0x3FFF;
			DescPtr->VideoWindowDesc.WindowPriority = LongWord & 0x0F;
			if(FilePtr != NULL)
			{
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," Video Window Descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr,"Horizontal Offset = %d\r\n",DescPtr->VideoWindowDesc.HorizontalOffset);
				fprintf(FilePtr,"Vertical Offset = %d\r\n",DescPtr->VideoWindowDesc.VerticalOffset);
				fprintf(FilePtr,"Window Priority = %d\r\n",DescPtr->VideoWindowDesc.WindowPriority);
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," End of descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n\r\n");
			}
			DescPtr->VideoWindowDesc.Counter++;
			break;
// Conditional access Descriptor
		case 9:
			if(DescPtr->CADesc.Counter == 0)
			{
				DescPtr->TagArray[DescPtr->NumberOfDescriptors] = Tag;
				DescPtr->NumberOfDescriptors++;
			}

			memcpy(&ShortWord, TSDataPtr, 2);
			DescPtr->CADesc.SystemID = htons(ShortWord);
			memcpy(&ShortWord, TSDataPtr, 2);
			DescPtr->CADesc.PID = htons(ShortWord);
			TSDataPtr += 4;
			DescPtr->CADesc.PID &= 0x1FFF;
			if(FilePtr != NULL)
			{
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," Conditional Access Descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr,"PID = %d\r\n",DescPtr->CADesc.PID);
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," End of descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n\r\n");
			}
			Length -= 4;
			if(Length > 0)
			{
				if(DescPtr->CADesc.PrivateDataPtr == NULL)
					DescPtr->CADesc.PrivateDataPtr = (char *)tsContext.memCxt.alloc(0,tsContext.memCxt.memHandle);
				for(i=0; i<Length; i++)
					DescPtr->CADesc.PrivateDataPtr[i] = *TSDataPtr++;
			}
			DescPtr->CADesc.Counter++;
			break;
// ISO 639 language Descriptor
		case 10:
			if(DescPtr->ISO639LanguageDesc.Counter == 0)
			{
				DescPtr->TagArray[DescPtr->NumberOfDescriptors] = Tag;
				DescPtr->NumberOfDescriptors++;
			}
			if(FilePtr != NULL)
			{
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," ISO 639 Language Descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n");
			}
			if(Length > 1)
			{
				if(DescPtr->ISO639LanguageDesc.LanguageCodePtr == NULL)
					DescPtr->ISO639LanguageDesc.LanguageCodePtr = (char *)tsContext.memCxt.alloc(0,tsContext.memCxt.memHandle);

				for(i=0; i<(Length - 1); i+=3)
				{
					DescPtr->ISO639LanguageDesc.LanguageCodePtr[i] = *TSDataPtr++;
					DescPtr->ISO639LanguageDesc.LanguageCodePtr[i+1] = *TSDataPtr++;
					DescPtr->ISO639LanguageDesc.LanguageCodePtr[i+2] = *TSDataPtr++;
				}
				Length -= 3;
			}
			DescPtr->ISO639LanguageDesc.AudioType = *TSDataPtr++;
			if(FilePtr != NULL)
			{
				fprintf(FilePtr,"Audio Type = %d\r\n",DescPtr->ISO639LanguageDesc.AudioType);
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," End of descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n\r\n");
			}
			DescPtr->ISO639LanguageDesc.Counter++;
			break;
// System clock Descriptor
		case 11:
			if(DescPtr->SystemClockDesc.Counter == 0)
			{
				DescPtr->TagArray[DescPtr->NumberOfDescriptors] = Tag;
				DescPtr->NumberOfDescriptors++;
			}
			Byte = *TSDataPtr++;
			DescPtr->SystemClockDesc.ExternalClockRefIndicator = (Byte >> 6) & 0x03;
			DescPtr->SystemClockDesc.ExternalClockRefIndicator >>= 1;
			DescPtr->SystemClockDesc.ClockAccuracyInteger = Byte & 0x3F;
			DescPtr->SystemClockDesc.ClockAccuracyExponent = *TSDataPtr++;
			DescPtr->SystemClockDesc.ClockAccuracyExponent >>= 5;
			if(FilePtr != NULL)
			{
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," System Clock Descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr,"External Clock Ref Indicator = %d\r\n",DescPtr->SystemClockDesc.ExternalClockRefIndicator);
				fprintf(FilePtr,"Clock Accuracy Integer = %d\r\n",DescPtr->SystemClockDesc.ClockAccuracyInteger);
				fprintf(FilePtr,"Clock Accuracy Exponent = %d\r\n",DescPtr->SystemClockDesc.ClockAccuracyExponent);
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," End of descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n\r\n");
			}
			DescPtr->SystemClockDesc.Counter++;
			break;
// Multiplex buffer utilization Descriptor
		case 12:
			if(DescPtr->MultiplexBufferUtilsDesc.Counter == 0)
			{
				DescPtr->TagArray[DescPtr->NumberOfDescriptors] = Tag;
				DescPtr->NumberOfDescriptors++;
			}

			memcpy(&ShortWord, TSDataPtr, 2);
			ShortWord = htons(ShortWord);
			TSDataPtr += 2;
			DescPtr->MultiplexBufferUtilsDesc.MDV_ValidFlag = (ShortWord >> 15) & 1;
			DescPtr->MultiplexBufferUtilsDesc.MultiplexDelayVariation = ShortWord & 0x7FFF;
			DescPtr->MultiplexBufferUtilsDesc.MulitplexStrategy = *TSDataPtr++;
			DescPtr->MultiplexBufferUtilsDesc.MulitplexStrategy >>= 5;
			if(FilePtr != NULL)
			{
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," Multiplex Buffer Utilization Descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr,"MDV Valid Flag = %d\r\n",DescPtr->MultiplexBufferUtilsDesc.MDV_ValidFlag);
				fprintf(FilePtr,"Multiplex Delay Variation = %d\r\n",DescPtr->MultiplexBufferUtilsDesc.MultiplexDelayVariation);
				fprintf(FilePtr,"Mulitplex Strategy = %d\r\n",DescPtr->MultiplexBufferUtilsDesc.MulitplexStrategy);
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," End of descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n\r\n");
			}
			DescPtr->MultiplexBufferUtilsDesc.Counter++;
			break;
// Copyright Descriptor
		case 13:
			if(DescPtr->CopyrightDesc.Counter == 0)
			{
				DescPtr->TagArray[DescPtr->NumberOfDescriptors] = Tag;
				DescPtr->NumberOfDescriptors++;
			}

			memcpy(&DescPtr->CopyrightDesc.CopyrightID, TSDataPtr, 4);
			DescPtr->CopyrightDesc.CopyrightID = htonl(DescPtr->CopyrightDesc.CopyrightID);
			TSDataPtr += 4;
			if(FilePtr != NULL)
			{
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," Copyright Descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr,"Copyright ID = %d\r\n",DescPtr->CopyrightDesc.CopyrightID);
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," End of descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n\r\n");
			}
			if(Length > 0)
			{
				if(DescPtr->CopyrightDesc.AdditionalInfoPtr == NULL)
					DescPtr->CopyrightDesc.AdditionalInfoPtr = (char *)tsContext.memCxt.alloc(0,tsContext.memCxt.memHandle);
				for(i=0; i<Length; i++)
					DescPtr->CopyrightDesc.AdditionalInfoPtr[i] = *TSDataPtr++;
			}
			DescPtr->CopyrightDesc.Counter++;
			break;
// Maximum bitrate Descriptor
		case 14:
			if(DescPtr->MaxBitrateDesc.Counter == 0)
			{
				DescPtr->TagArray[DescPtr->NumberOfDescriptors] = Tag;
				DescPtr->NumberOfDescriptors++;
			}
			Byte1 = (char)*TSDataPtr++;
			Byte2 = (char)*TSDataPtr++;
			Byte3 = (char)*TSDataPtr++;
			DescPtr->MaxBitrateDesc.MaxBitRate = (Byte1 << 16) | (Byte2 << 8) | Byte3;
			DescPtr->MaxBitrateDesc.MaxBitRate &= 0x3FFFFF;
			if(FilePtr != NULL)
			{
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," Maximum Bit Rate Descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr,"MDV Valid Flag = %d\r\n",DescPtr->MaxBitrateDesc.MaxBitRate);
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," End of descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n\r\n");
			}
			DescPtr->MaxBitrateDesc.Counter++;
			break;
// Private data indicator Descriptor
		case 15:
			if(DescPtr->PrivateDataIndicatorDesc.Counter == 0)
			{
				DescPtr->TagArray[DescPtr->NumberOfDescriptors] = Tag;
				DescPtr->NumberOfDescriptors++;
			}

			memcpy(&DescPtr->PrivateDataIndicatorDesc.PrivateDataIndicator, TSDataPtr, 4);
			DescPtr->PrivateDataIndicatorDesc.PrivateDataIndicator = htonl(DescPtr->PrivateDataIndicatorDesc.PrivateDataIndicator);
			TSDataPtr += 4;
			if(FilePtr != NULL)
			{
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," Private Data Indicator Descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr,"PrivateDataIndicator = %d\r\n",DescPtr->PrivateDataIndicatorDesc.PrivateDataIndicator);
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," End of descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n\r\n");
			}
			DescPtr->PrivateDataIndicatorDesc.Counter++;
			break;
// ISO reserved Descriptor (16 - 63)
		case 16:
			if(DescPtr->ISOReservedDesc.Counter == 0)
			{
				DescPtr->TagArray[DescPtr->NumberOfDescriptors] = Tag;
				DescPtr->NumberOfDescriptors++;
			}
			if(FilePtr != NULL)
			{
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," ISO Reserved Descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," End of descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n\r\n");
			}
			if(Length > 0)
			{
				if(DescPtr->ISOReservedDesc.ISODataPtr == NULL)
					DescPtr->ISOReservedDesc.ISODataPtr = (char *)tsContext.memCxt.alloc(0,tsContext.memCxt.memHandle);
				for(i=0; i<Length; i++)
					DescPtr->ISOReservedDesc.ISODataPtr[i] = *TSDataPtr++;
			}
			DescPtr->ISOReservedDesc.Counter++;
			break;
// User private data Descriptor (64 - 255)
		default:
			if(DescPtr->UserPrivateDesc.Counter == 0)
			{
				DescPtr->TagArray[DescPtr->NumberOfDescriptors] = Tag;
				DescPtr->NumberOfDescriptors++;
			}
			if(FilePtr != NULL)
			{
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," User Private Data Descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr,"*******************************************************\r\n");
				fprintf(FilePtr," End of descriptor\r\n");
				fprintf(FilePtr,"*******************************************************\r\n\r\n");
			}
			if(Length > 0)
			{
				if(DescPtr->UserPrivateDesc.UserPrivateDataPtr == NULL)
					DescPtr->UserPrivateDesc.UserPrivateDataPtr = (char *)tsContext.memCxt.alloc(0,tsContext.memCxt.memHandle);
				for(i=0; i<Length; i++)
					DescPtr->UserPrivateDesc.UserPrivateDataPtr[i] = *TSDataPtr++;
			}
			DescPtr->UserPrivateDesc.Counter++;
			break;
	}
	return BytesUsed;
}

// ****************************************************************************
// end of file
// ****************************************************************************
