/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



// ****************************************************************************
// PES_Demux.c
// ****************************************************************************
#include <string.h>
#include <ti/mas/mmcu/src/ts/tsdemux.h>

tlong tsDemux_find_MPEG_startcode(ifmmcOsalFileHandle_t BufferInfo, tlong *CodeFoundFlagPtr, tlong BytesToCount );

tlong tsDemux_parse_PES_pkt( tsDemuxInst_t *inst, tsDemuxPESInfo_t *PESInfoPtr )
{
  tlong Index, Word32, Bits1, Bits2, Bits3, HeaderLength, PrivateStreamID, BytesToES, NumOfStreams;
  tlong PacketLength, BytesLeft, TotalBytes, BytesRemaining, BytesToTransfer, BytesProcessed;
  tlong AVStreamID, StartCodeFoundFlag;
  tlong LongWord; 
  tint ShortWord1, ShortWord2, ShortWord3; 
  char Byte1;
  tint ShortWord;
  tword *PESDataPtr = 0, *StartPtr, StreamID;
  char Byte;
  tsDemuxPESHdr_t PESHdr;
  char *PayloadData = (char *)tsContext.scratch;
  ifmmcOsalFileHandle_t PESBufferInfo;

  PESBufferInfo = PESInfoPtr->BufferInfo;

  BytesRemaining = PESInfoPtr->PayloadSize;

  StartPtr = PESDataPtr;
  PESDataPtr += tsDemux_find_MPEG_startcode( PESBufferInfo, &StartCodeFoundFlag, BytesRemaining );

  if(StartCodeFoundFlag == TRUE)
  {
    PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,&Byte,1);
    StreamID = Byte;
  }
  else
    return -1;
  PESInfoPtr->PESFrameInfo.PTSFoundFlag = FALSE;
  PESInfoPtr->PESFrameInfo.DTSFoundFlag = FALSE;
  PESInfoPtr->Packets++;
  Byte = 0;
  
  PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,(tword *)&ShortWord,2);
  PacketLength = htons( ShortWord );

  if(PacketLength < inst->MinPESPacketLength)
    inst->MinPESPacketLength = PacketLength;
  if(PacketLength > inst->MaxPESPacketLength)
    inst->MaxPESPacketLength = PacketLength;

  BytesLeft = BytesRemaining - 6; //PESInfoPtr->PacketLength - 6;
  if(PacketLength == 0)
    PacketLength = BytesLeft;
  else if(PacketLength > BytesLeft)
  { 
    tsContext.fileCxt.fskip(PESBufferInfo, BytesLeft); 
    return (BytesLeft + 6); //>BytesLeft;
  }

  if(PacketLength == 0)
    return tsDemux_BAD_PACKET_LENGTH;

  PESInfoPtr->HeaderBytes += 6;
  AVStreamID = StreamID & 0xE0;
  if(AVStreamID == ts_AUDIO_STREAM_MPEG1_2)
    StreamID = ts_AUDIO_STREAM_MPEG1_2;
  AVStreamID = StreamID & 0xF0;
  if(AVStreamID == ts_VIDEO_STREAM_MPEG1_2)
    StreamID = ts_VIDEO_STREAM_MPEG1_2;
  switch(StreamID)
  {
    case ts_PROGRAM_STREAM_MAP:
    case ts_PRIVATE_STREAM_2:
    case ts_ECM_STREAM:
    case ts_EMM_STREAM:
    case ts_PROGRAM_STREAM_DIR:
    case ts_PADDING_STREAM:
      PESInfoPtr->DataBytes += PacketLength;
      if(PacketLength < PESInfoPtr->DataSizeMin)
        PESInfoPtr->DataSizeMin = PacketLength;
      if(PacketLength > PESInfoPtr->DataSizeMax)
        PESInfoPtr->DataSizeMax = PacketLength;
      PESInfoPtr->DataSizeAvg = PESInfoPtr->DataBytes/PESInfoPtr->Packets;
      
      PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,PayloadData,PacketLength);

      break;
    case 0xB:
    case ts_PRIVATE_STREAM_1:
    case ts_AUDIO_STREAM_MPEG1_2:
    case ts_VIDEO_STREAM_MPEG1_2:
      PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,(tword *)&ShortWord,2);
      ShortWord = htons( ShortWord );
      PESHdr.PktHeader.Marker = (ShortWord >> 14) & 0x03;
      PESHdr.PktHeader.ScramblingControl = (ShortWord >> 12) & 0x03;
      PESHdr.PktHeader.PriorityFlag = (ShortWord >> 11) & 1;
      PESHdr.PktHeader.DataAlignment = (ShortWord >> 10) & 1;
      PESHdr.PktHeader.Copyright = (ShortWord >> 9) & 1;
      PESHdr.PktHeader.OriginalOrCopy = (ShortWord >> 8) & 1;
      PESHdr.PktHeader.PTS_DTS_Flags = (ShortWord >> 6) & 0x03;
      PESHdr.PktHeader.ESCRFlag = (ShortWord >> 5) & 1;
      PESHdr.PktHeader.ESRateFlag = (ShortWord >> 4) & 1;
      PESHdr.PktHeader.DSMTrickModeFlag = (ShortWord >> 3) & 1;
      PESHdr.PktHeader.AdditionalCopyInfoFlag = (ShortWord >> 2) & 1;
      PESHdr.PktHeader.CRCFlag = (ShortWord >> 1) & 1;
      PESHdr.PktHeader.Ext1Flag = ShortWord & 1;
      
      PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,&Byte,1);
      HeaderLength = Byte;
      PESInfoPtr->HeaderBytes += HeaderLength + 3;
      PacketLength -= HeaderLength + 3;
      if(PESHdr.PktHeader.PTS_DTS_Flags & 2)
      {
        PESInfoPtr->PESFrameInfo.PTSFoundFlag = TRUE;
        PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,&Byte,1);
        Bits1 = (Byte >> 1) & 0x07; 
        
        PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,(tword *)&ShortWord,2);
        ShortWord = htons( ShortWord );
        Bits2 = (ShortWord >> 1) & 0x7FFF;
        
        PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,(tword *)&ShortWord,2);
        ShortWord = htons( ShortWord );
        Bits3 = (ShortWord >> 1) & 0x7FFF;
        PESHdr.PTS32 = Bits1>>2;
        PESHdr.PTS31_0 = (Bits1<<30) | (Bits2<<15) | Bits3;
        
        PESInfoPtr->PTS[PESInfoPtr->PTSIndex].Base = PESHdr.PTS32;
        PESInfoPtr->PTS[PESInfoPtr->PTSIndex].Base <<= 1;
        PESInfoPtr->PTS[PESInfoPtr->PTSIndex].Base |= PESHdr.PTS31_0;
        PESInfoPtr->PTS[PESInfoPtr->PTSIndex].PacketNumber = PESInfoPtr->Packets;
        PESInfoPtr->PTS[PESInfoPtr->PTSIndex].BytePos = inst->BytesProcessed;

        PESInfoPtr->PTSCount++;
        PESInfoPtr->PTSIndex++;
        if(PESInfoPtr->PTSIndex >= tsDemux_PTS_OBJECTS_IN_QUEUE)
          PESInfoPtr->PTSIndex = 0;
        HeaderLength -= 5;
      }
      if(PESHdr.PktHeader.PTS_DTS_Flags & 1)
      {
        PESInfoPtr->PESFrameInfo.DTSFoundFlag = TRUE;
        PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,&Byte,1);
        Bits1 = (Byte >> 1) & 0x07; 
        
        PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,(tword *)&ShortWord,2);
        ShortWord = htons( ShortWord );
        Bits2 = (ShortWord >> 1) & 0x7FFF;
        
        PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,(tword *)&ShortWord,2);
        ShortWord = htons( ShortWord );
        Bits3 = (ShortWord >> 1) & 0x7FFF;

        PESHdr.DTS32 = Bits1>>2;
        PESHdr.DTS31_0 = (Bits1<<30) | (Bits2<<15) | Bits3;
        
        PESInfoPtr->DTS[PESInfoPtr->DTSIndex].Base = PESHdr.DTS32;
        PESInfoPtr->DTS[PESInfoPtr->DTSIndex].Base <<= 1;
        PESInfoPtr->DTS[PESInfoPtr->DTSIndex].Base |= PESHdr.DTS31_0;
        PESInfoPtr->DTS[PESInfoPtr->DTSIndex].PacketNumber = PESInfoPtr->Packets;
        PESInfoPtr->DTS[PESInfoPtr->DTSIndex].BytePos = inst->BytesProcessed;

        PESInfoPtr->DTSCount++;
        PESInfoPtr->DTSIndex++;
        if(PESInfoPtr->DTSIndex >= tsDemux_DTS_OBJECTS_IN_QUEUE)
          PESInfoPtr->DTSIndex = 0;
        HeaderLength -= 5;
      }
      if(PESHdr.PktHeader.ESCRFlag)
      {
        PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,(tword *)&ShortWord1,2);
        ShortWord1 = htons( ShortWord1 );
        
        PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,(tword *)&ShortWord2,2);
        ShortWord2 = htons( ShortWord2 );
        
        PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,(tword *)&ShortWord3,2);
        ShortWord3 = htons( ShortWord3 );

        PESHdr.ESCRBase32 = (ShortWord1 >> 13) & 0x1;
        LongWord = (ShortWord1 << 3) & 0x3FFF;
        LongWord |= (ShortWord1 & 0x03FF) << 4;
        LongWord |= (ShortWord2 >> 12);
        LongWord <<= 16;
        ShortWord = (ShortWord2 << 4) & 0x8000;
        ShortWord |= (ShortWord2 & 0x03FF) << 5;
        ShortWord |= (ShortWord3 >> 11);
        LongWord |= ShortWord;
        PESHdr.ESCRBase31_0 = LongWord;
        PESHdr.ESCRExtension = (ShortWord3 >> 1) & 0x1FF;

        PESInfoPtr->ESCR[PESInfoPtr->ESCRIndex].Extension = PESHdr.ESCRExtension;
        PESInfoPtr->ESCR[PESInfoPtr->ESCRIndex].BaseLSW = PESHdr.ESCRBase31_0;
        PESInfoPtr->ESCR[PESInfoPtr->ESCRIndex].BytePos = inst->BytesProcessed;
        PESInfoPtr->ESCRCount++;
        PESInfoPtr->ESCRIndex++;
        if(PESInfoPtr->ESCRIndex >= tsDemux_SCR_OBJECTS_IN_QUEUE)
          PESInfoPtr->ESCRIndex = 0;
        HeaderLength -= 6;
      }
      if(PESHdr.PktHeader.ESRateFlag)
      {
        PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,&Byte,1);
        Byte1 = Byte & 0x7F;
        
        PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,(tword *)&ShortWord,2);
        ShortWord = htons( ShortWord );
        ShortWord  = (ShortWord >> 1) & 0x7FFF;
        PESHdr.ESRate = (Byte << 15) | ShortWord;  //TODO: Should this use Byte1???
        HeaderLength -= 3;
      }
      if(PESHdr.PktHeader.DSMTrickModeFlag)
      {
        PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,&Byte,1);
        PESHdr.TrickModeControl = (Byte >> 5) & 0x7;
        switch(PESHdr.TrickModeControl)
        {
          case 0:
            Byte &= 0x1F;
            break;
          case 1:
            Byte &= 0x1F;
            break;
          case 2:
            Byte &= 0x1F;
            break;
          case 3:
            Byte &= 0x1F;
            break;
          case 4:
            Byte &= 0x1F;
            break;
          default:
            Byte &= 0x1F;
            break;
        }
        HeaderLength -= 1;
      }
      if(PESHdr.PktHeader.AdditionalCopyInfoFlag)
      {
        PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,&Byte,1);
        PESHdr.AdditionalCopyInfo = Byte >> 1;
        HeaderLength -= 1;
      }
      if(PESHdr.PktHeader.CRCFlag)
      {
        PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,(tword *)&ShortWord,2);
        PESHdr.PESPacketCRC = htons( ShortWord );
        HeaderLength -= 2;
      }
      if(PESHdr.PktHeader.Ext1Flag)
      {
        PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,&Byte,1);
        PESHdr.ExtHeader.PrivateDataFlag = (Byte >> 7) & 1;
        PESHdr.ExtHeader.PackHdrFieldFlag = (Byte >> 6) & 1;
        PESHdr.ExtHeader.SeqCounterFlag = (Byte >> 5) & 1;
        PESHdr.ExtHeader.PSTDBufferFlag = (Byte >> 4) & 1;
        PESHdr.ExtHeader.Ext2Flag = Byte & 1;
        HeaderLength -= 1;
        if(PESHdr.ExtHeader.PrivateDataFlag)
        {
          for(Index=0; Index<4; Index++)
          {
            PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,(tword *)&Word32,4);
            PESHdr.ExtHeader.PrivateData[Index] = htonl( Word32 );
          }
          HeaderLength -= 16;
        }
        if(PESHdr.ExtHeader.PackHdrFieldFlag)
        {
          PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,&Byte,1);
          PESHdr.ExtHeader.PackFieldLength = Byte;
          HeaderLength -= 1;
        }
        if(PESHdr.ExtHeader.SeqCounterFlag)
        {
          PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,(tword *)&ShortWord,2);
          ShortWord = htons( ShortWord );
          PESHdr.ExtHeader.PacketSeqCounter = (ShortWord >> 8) & 0x7F;
          PESHdr.ExtHeader.MPEG1_MPEG2_ID = (ShortWord >> 6) & 1;
          PESHdr.ExtHeader.OriginalStuffLength = ShortWord & 0x3F;
          HeaderLength -= 2;
        }
        if(PESHdr.ExtHeader.PSTDBufferFlag)
        {
          PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,(tword *)&ShortWord,2);
          ShortWord = htons( ShortWord );
          PESHdr.ExtHeader.PSTDBufferScale = (ShortWord >> 13) & 1;
          PESHdr.ExtHeader.PSTDBufferSize = ShortWord  & 0x1FFF;
          if(PESHdr.ExtHeader.PSTDBufferScale == 0)
            PESInfoPtr->BufferSize = PESHdr.ExtHeader.PSTDBufferSize * 128;
          else
            PESInfoPtr->BufferSize = PESHdr.ExtHeader.PSTDBufferSize * 1024;
          HeaderLength -= 2;
        }
        if(PESHdr.ExtHeader.Ext2Flag)
        {
          PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,&Byte,1);
          PESHdr.ExtHeader.Ext2FieldLength = Byte & 0x7F;
          // Private data bytes
          PESInfoPtr->PrivateDataBytes += PESHdr.ExtHeader.Ext2FieldLength;	
          
          PESDataPtr += tsContext.fileCxt.fread(PESBufferInfo,PayloadData,PESHdr.ExtHeader.Ext2FieldLength);
          
          HeaderLength -= 1 + PESHdr.ExtHeader.Ext2FieldLength;
        }
      }
      // Stuffing bytes
      PESInfoPtr->StuffedBytes += HeaderLength;
      tsContext.fileCxt.fskip(PESBufferInfo,(int64_t)HeaderLength);
      
      // Payload data
      PESInfoPtr->DataBytes += PacketLength;
      if(PacketLength < PESInfoPtr->DataSizeMin)
        PESInfoPtr->DataSizeMin = PacketLength;
      if(PacketLength > PESInfoPtr->DataSizeMax)
        PESInfoPtr->DataSizeMax = PacketLength;
      PESInfoPtr->DataSizeAvg = PESInfoPtr->DataBytes/PESInfoPtr->Packets;
      if(StreamID == ts_VIDEO_STREAM_MPEG1_2)
      {
        PESInfoPtr->TotalBytes += BytesRemaining;
        BytesProcessed = (tlong)PESDataPtr - (tlong)StartPtr;
        BytesToTransfer = BytesRemaining - BytesProcessed;

        PESInfoPtr->PESFrameInfo.BufferInfo = PESBufferInfo;
        PESInfoPtr->PESFrameInfo.FrameSize = BytesToTransfer;

        return BytesRemaining;
      }
      else 
      {
        if(StreamID == ts_AUDIO_STREAM_MPEG1_2)
        {

          PESInfoPtr->TotalBytes += BytesRemaining;
          BytesProcessed = (tlong)PESDataPtr - (tlong)StartPtr;
          BytesToTransfer = BytesRemaining - BytesProcessed;
          
#ifndef __MMCU_INTEGRATION // TODO: This should happen when extracting the frame.

          if(AudioInfoPtr->TotalBytes == 0)
          {
            AudioInfoPtr->PESBufferSize = 0x20;
            AudioInfoPtr->SyncWordMSB = 0xFF;
            //						inst->SelectedProgram.AudioStreamType = 0x03;
            AudioInfoPtr->StreamNumber = StreamID; //ts_AUDIO_STREAM_MPEG1_2;
            //						AudioInfoPtr->SyncWordLSB = PESDataPtr[1];

            Index = GetPIDIndexInPIDQueue(inst, inst->SelectedProgram.AudioPID);
            if(Index < 0)
              Index = inst->PIDQueueIndex - 1;
            PIDQueuePtr = (struct PID_QUEUE *)&inst->PIDQueue[Index];
            inst->SelectedProgram.AudioStreamType = PIDQueuePtr->StreamType;

            switch(inst->SelectedProgram.AudioStreamType)
            {
            case 0x0F:
              AudioInfoPtr->SyncWordLSB = 0xF1;
              AudioInfoPtr->FileType = AUDIO_FILE_TYPE_AAC;
              break;								
              //							case 0xFB:
              //								AudioInfoPtr->SyncWordLSB = 0xFB;
              //								AudioInfoPtr->FileType = AUDIO_FILE_TYPE_MPEG1_L3;
              //								break;
            case 0x03:
              AudioInfoPtr->SyncWordLSB = 0xFD;
              AudioInfoPtr->FileType = AUDIO_FILE_TYPE_MPEG1_L2;
              break;
              //							case 0xFF:
              //								AudioInfoPtr->SyncWordLSB = 0xFF;
              //								AudioInfoPtr->FileType = AUDIO_FILE_TYPE_MPEG1_L1;
              //								break;
            default:
              AudioInfoPtr->FileType = AUDIO_FILE_TYPE_MPEG1_L2;
              break;
            }
          }		
#endif
          PESInfoPtr->PESFrameInfo.BufferInfo = PESBufferInfo;
          PESInfoPtr->PESFrameInfo.FrameSize = BytesToTransfer;

          return BytesRemaining;

        }
        else if( (StreamID == ts_PRIVATE_STREAM_1) || (StreamID == 0xB) )
        {
#ifndef __MMCU_INTEGRATION //TODO:  This should happen when extracting the frame.
          // For private streams, format is defined as follows (4 byte header):
          // Byte #1 - stream ID  (i.e., 0x81 - AC3)
          // Byte #2 - number of ES frames which are fully or partially contained (whose 1st byte) is in this payload
          // Bytes #3/#4 - number of bytes to first byte of next ES frame starting from byte position #4
          // (i.e., value of 1 would be next byte (#5) is the beginning of the next ES frame)
          
          // TODO: This can be done when picking up the frame.
          if(AudioInfoPtr->TotalBytes == 0)
          {
            AudioInfoPtr->FileType = AUDIO_FILE_TYPE_AC3;
            AudioInfoPtr->PESBufferSize = 0x3A;
            AudioInfoPtr->SyncWordMSB = 0x0B;
            AudioInfoPtr->SyncWordLSB = 0x77;
            inst->SelectedProgram.AudioStreamType = 0x81;
            AudioInfoPtr->StreamNumber = ts_PRIVATE_STREAM_1;
          }
#endif
          tsContext.fileCxt.fpeek(PESBufferInfo,0,&Byte,1);
          if(Byte == 0x81)
          {
            tsContext.fileCxt.fpeek(PESBufferInfo,0,(tword *)&LongWord,4);
            LongWord = htons( LongWord );
            PrivateStreamID = (LongWord>>24) & 0xFF;
            PESInfoPtr->StreamType = PrivateStreamID; //PayloadData[0];		// 1st byte is Stream Type
            NumOfStreams = (LongWord>>16) & 0xFF;
            BytesToES = (LongWord & 0xFFFF) - 1;
            if(BytesToES < PacketLength)
            {
              tsContext.fileCxt.fpeek(PESBufferInfo,BytesToES + 4,(tword *)&ShortWord,2);
              if( htons(ShortWord) == 0x0B77)
              {
                tsContext.fileCxt.fskip(PESBufferInfo,4);
                PacketLength -= 4;
                PESDataPtr += 4;
              }
            }
          }

          PESInfoPtr->TotalBytes += BytesRemaining;
          BytesProcessed = (tlong)PESDataPtr - (tlong)StartPtr;
          BytesToTransfer = BytesRemaining - BytesProcessed;

          PESInfoPtr->PESFrameInfo.BufferInfo = PESBufferInfo;
          PESInfoPtr->PESFrameInfo.FrameSize = BytesToTransfer;
          return BytesRemaining;
        }
      }
      break;
    default:
      break;
  }
  TotalBytes = (tlong)PESDataPtr - (tlong)StartPtr;
  PESInfoPtr->TotalBytes += TotalBytes;
  tsContext.fileCxt.fskip(PESBufferInfo, BytesRemaining - TotalBytes);
  return TotalBytes;
}

tlong tsDemux_find_MPEG_startcode(ifmmcOsalFileHandle_t BufferInfo, tlong *CodeFoundFlagPtr, tlong BytesToCount )
{
  char Byte;
  tlong ByteCounter, ZeroByteCtr;
  ifmmcOsalFileReadFcn_t tsfread = tsContext.fileCxt.fread;

  ByteCounter = 0;
  ZeroByteCtr = 0;
  *CodeFoundFlagPtr = FALSE;
  while(BytesToCount > 0)
  {
    ByteCounter += tsfread(BufferInfo,&Byte,1);
    if(Byte == 0)
    {
      ZeroByteCtr++;
      BytesToCount--;
      continue;
    }
    else
    {
      if(ZeroByteCtr >= 2)
      {
        if(Byte == 1)
        {
          *CodeFoundFlagPtr = TRUE;
          break;
        }
      }
    }
    ZeroByteCtr = 0;
    BytesToCount--;
  };
  return ByteCounter;
}

// ****************************************************************************
// end of file
// ****************************************************************************

