# ==============================================================================
# File            : Makedocs.mk
# Description     : 
#
#   GNU makefile to generate NEU documentation from sources using Doxygen
#
# ==============================================================================

# The target for generating documents using doxygen is gendocs

NEUAPI_DOC=./docs/doxygen/NEUAPI.chm
NEU_DOC=./docs/doxygen/NEU.chm
RELEASE_DOC=./docs/doxygen/release.chm
NEU_MANIFEST=./docs/manifest/Software_Manifest.html

releasenotes : $(RELEASE_DOC)

$(RELEASE_DOC): ./docs/doxygen/release.h
	-@echo generating Release Notes ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen ../swtools/docs/doxygen/releaseDoxyfile
	@xs -f ../swtools/release.js


release : $(NEU_MANIFEST) $(NEU_DOC) $(NEUAPI_DOC)

gendocs $(NEU_DOC): neu.h ./docs/doxygen/doxygen.h
	-@echo generating NEU documentation ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen.exe ./docs/doxygen/Doxyfile

genapidocs $(NEUAPI_DOC): neu.h ./docs/doxygen/doxygen.h
	-@echo generating NEU API documentation ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen.exe ./docs/doxygen/APIDoxyfile

genmanifest $(NEU_MANIFEST): ./docs/manifest/manifest.xml
	-@echo generating NEU Software Manifest ...
	-@php ../swtools/mangen.php $(NEU_MANIFEST) $?


# End of Makedocs.mk
