/**
 *  @file   aal5.h
 *
 *  path    /dsps_gtmas/ti/mas/neu/aal5.h
 *
 *  @brief  
 *
 *  Copyright (C) 2001-2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#ifndef __AAL5_H__
#define __AAL5_H__

/* Now assume the max packet size is 128(30ms PCM rtp) + 40 (header) = 168
which is 168/24 = 7 ATM cells. The max. padding size = one cell + one trailer.*/

#define neuproto_MAX_AAL5_PAYLOAD_BYTES    (24 *2)
#define neuproto_MAX_AAL5_TRAILER_BYTES    (4*2)
#define neuproto_MAX_CELLS_NUM             7
#define neuproto_MAX_AAL5_DATA_SIZE_BYTES ((neuproto_MAX_AAL5_PAYLOAD_BYTES * \
                                             (neuproto_MAX_CELLS_NUM+1)) \
                                             + neuproto_MAX_AAL5_TRAILER_BYTES)

#define neuproto_AAL5_CRC_GEN_POLYNOMIAL   0x04c11db7
#define neuproto_AAL5_CRC_CHK_POLYNOMIAL   0xC704DD7B

/* AAL5 RX return codes
******************************************************************************/
typedef enum {
  SAR_NOT_DONE = 0,   /* Still accumulating */
  SAR_DONE     = 1,   /* Accumulation done; packet returned */
  AAL5_DONE    = 1,   /* Need this definition for other users of aal5 */
  SAR_CRC      = -1,  /* Toss: BAD CRC */
  SAR_LEN      = -2,  /* Toss: Too big */
  SAR_RATOUT   = -3,  /* Toss: Reassembly time out */
  SAR_CIDERR   = -4,  /* Toss??? : not expected CID */
  SAR_UUIERR   = -5   /* Toss: UUI error */
} sarRxRet_e;

/******************************************************************************
 * DATA DEFINITION:  AAL5 parameters
 *****************************************************************************/
typedef struct {
  tuint rxInvdPkt;        /* RX invd. AAL5 packets dropped */
} aal5ErrStat_t;

typedef struct {
  tulong rx_curr_crc32;         /* current pkt CRC value */
  tword   *header_buf;           /* AAL5 Header buffer */
  tword   *tx_sar_buf;           /* AAL5 Tx SAR buffer */
  tword   *rx_sar_buf;           /* AAL5 Rx SAR buffer (pointer to scratch buffer) */
  void   *gmpBuffer;            /* Pointer to GMP allocated receive buffer */
  tuint  rx_curr_pktlen_words;  /* current pkt length in words(16 bits) */
  tuint  hdr_len_bytes;         /* AAL5 header length in byte */
  aal5ErrStat_t errStats;       /* error stats */
  tuint   tx_sar_buf_size;      /* Size of Tx SAR buffer */
  tuint   rx_sar_buf_size;      /* Size of Rx SAR buffer */
} aal5Inst_t;

tbool aal5_send_process (aal5Inst_t *inst, tint pktSize[], void *pktIn[],
                        tbool crc_gen);
sarRxRet_e aal5_receive_process (aal5Inst_t *inst, tint pktSize[], 
                                  void *pktIn[], tbool crc_check,
                                  tuint instance_ID, void **gmpBuffer, tuint *gmpLength);
#endif /* __AAL5_H__ */
