/*
 * This is a template header file which doxygen parses to generate the main
 * documentation page
 */

/**
 * @mainpage @COMP (Network Encapsulation Unit) Package
 *
 * @HLINE
 *
 * @section content Page Contents
 *  
 *  <ol>
 *    <li> @ref describe 
 *    <li> @ref integrate
 *    <li> @ref perform
 *    <li> @ref example
 *    <li> @ref limit
 *    <li> @ref depend
 *  </ol>
 *  
 * @HLINE
 *
 *
 * @section describe Description
 *  
 *  The NEU (Network protocol Encapsulation Unit) performs network configurable 
 *  encapsulation on a call payload.Functionalities supported by module includes:  
 *
 *  
 *  For outgoing packets to network:
 *  <ul>
 *    <li> Preconfigured header being pre-pended to each cell/frame/packet depending on transport types
 *    <li> Allow padding at the end of a packet to fill out the cell.
 *    <li> Allow re-packing if configured header size is an odd number.
 *    <li> Update sequence number, packet length, checksums, CRCs and other required header parameters.
 *    <li> Allow AAL5 segmentation for UTOPIA transport
 *  </ul>
 *
 *  For incoming packets from network:
 *  <ul>
 *    <li> Skip over a predefined header size
 *    <li> Allow re-packing if predefined header size is an odd number
 *    <li> Allow checksum check and CRC check
 *    <li> Allow AAL5 re-assembly for UTOPIA transport
 *    <li> Allow network protocol type check
 *    <li> Additional validation if enabled for channel configuration
 *    <li> In case of any packet violation condition, trigger packet violation event
 *  </ul>
 *
 *  SBC Applications (Packet to Packet) support
 *  <ul>
 *    <li> Transparent domain routing ensuring layer-3 transparency (IP layer) 
 *         while routing network-side packets back to network from one source to a 
 *         different destination.
 *    <li> Bandwidth Control for Dedicated Bandwidth capability as per Y.1221 for 
 *         real time applications
 *    <li> Media Payload monitoring hook for validation of payload outside NEU
 *  </ul>
 *
 *  Miscellaneous supprted features in the module includes
 *  <ul>
 *    <li> Loopback of the packet received from the network
 *    <li> Support for receving non voice packets 
 *      <ol>
 *        <li> If ICMP ping request is received prepare response and send to network
 *        <li> For any other packets support for forwarding the request to host
 *        <li> Support for receiving a non voice and non control packets from host to be forwarded
 *             to network
 *      </ol>
 *  </ul>
 *
 *
 *  Supported Transport types includes:
 *  <ul>
 *    <li> GMAC
 *    <li> UTOPIA      
 *      <tt>
 *      <ol>
 *      <li> ATM
 *      <li> AAL2
 *      <li> AAL5
 *      </ol>
 *      </tt>
 *  </ul>
 *
 *
 *  Supported protocol types includes:
 *   Layer 2:
 *  <ul>
 *    <li> Ethernet header One of 4 types   
 *    <li> PPP
 *    <li> LLC/SNAP
 *    <li> Null protocol with no header
 *    <li> Custom protocol tags/ header through Protocol type Differentiation Tag (PDT) 
 *  </ul>
 *
 *
 *   Layer 3:
 *  <ul>
 *    <li> IPv4
 *    <li> IPv6
 *    <li> NULL protocol with no additional header
 *  </ul>
 *
 *   Layer 4:
 *  <ul>
 *    <li> UDP
 *  </ul>
 *
 *  
 *  Additional info: [@subpage describe_details]
 *  
 * @HLINE
 * 
 *
 * @section integrate Integration
 *
 *  Information on building and integrating NEU is found on the following pages:
 *
 *  <ul>
 *    <li> Build Procedure
 *      <ol>
 *        <li> @subpage building_xdc
 *        <li> @subpage building_make
 *      </ol>
 *    <li> @subpage integrate_details
 *    <li> @subpage external_api
 *  </ul>
 *  
 * @HLINE
 *
 *
 * @section perform Performance
 *
 *  Information on NEU's MIPS and memory usage can be found on the following pages:
 *  
 *  <ul>
 *    <li> @ref mips_details
 *    <li> @ref memory_details
 *  </ul>
 *
 * @HLINE
 *
 * 
 * @section example Example Project
 *
 *  An example CCS project is provided with this release of NEU. The example 
 *  combines NEU along with the EMAC driver, CSL, BIOS, and IPC to create
 *  a sample application to highlight the call flow for creating an NEU 
 *  channel. Information on building the sample project can be found here:
 *
 *  @ref example_proj
 *
 *  Additional required packages are listed within the release notes. 
 *
 * @HLINE
 *
 *
 * @section limit Limitations
 *
 *  The @COMP package has the following limitations:
 *
 *  <ul>
 *
 *    <li> The @COMP package can build two different libraries:
 *
 *      <ol>
 *        <li> NEU for GMAC interface.
 *        <li> NEU for UTOPIA interface.
 *      </ol>
 *
 *      See @ref neu_build_libs for more details.
 *
 *    <li> The UTOPIA library version currently requires GMP to be implented via function pointers in neuContext.
 *
 *  </ul>
 *
 * @HLINE
 *
 *
 * @section depend Dependent Packages
 *
 *  The @COMP package depends on the following packages for build and/or integration:
 *
 *  <ol>
 *    <li> \c ti.mas.types (Common data type defintions)
 *    <li> \c ti.mas.util  (Common utilities)
 *    <li> \c ti.mas.pktutl 
 *    <li> \c ti.mas.iface.ifpkt
 *    <li> \c ti.mas.iface.ifneu
 *    <li> \c ti.mas.iface.ifrcu
 *    <li> \c ti.mas.swtools (Build tools)
 *  </ol>
 *  
 */


/**
 * @page describe_details  Detailed @COMP Description
 * 
 *  @section describe_content Page Contents
 *  
 *  <ol>
 *    <li> @ref describe_atm 
 *    <li> @ref describe_udpip
 *    <li> @ref describe_aal5
 *    <li> @ref describe_ethernet
 *    <li> @ref describe_ppp
 *  </ol>
 *  
 * @HLINE
 *
 *  @section describe_atm Function of ATM
 *
 *  The predefined header is added on the top of each packet from telephony to 
 *  network. Packets are repacked if the predefined header is in odd bytes. 
 *  Zeros are padded at the end of a packet to align the packet to a 16-bit 
 *  even ending boundary or to meet the minimum packet size requirement.
 *
 *  The predefined header is removed for each packet from network to telephony. 
 *  Re-packing is performed and a zero is padded to the last byte when the 
 *  removed header is in odd bytes.
 *
 * @HLINE
 * 
 *
 *  @section describe_udpip Function of UDP/IP
 *
 *  For outgoing packets to network following header modifications is supported:
 *
 *  <ul>
 *    <li> Update the length fields in both IP and UDP header. 
 *
 *    <li> Calculate the checksum of IP header in the following 4 steps: 
 *      
 *      <tt>
 *      <ol>
 *        <li> Put zero in IP checksum field.
 *        <li> Put the updated packet size including both header and payload in 
 *              bytes in the 16-bit total length field of IP header.
 *        <li> Calculate the ones complement sum over the whole IP header.
 *        <li> Store the ones complement of the result from step 3 in the 
 *              checksum field.
 *      </ol>
 *      </tt>
 *      
 *    <li> Calculate the checksum of UDP datagram in the following 3 steps: 
 *      
 *      <tt>
 *      <ol>
 *        <li> Put the updated packet length in the length field of UDP header.
 *        <li> Calculate the ones complement sum over both UDP header and UDP 
 *              payload. NOTE: The pseudo header checksum is pre-calculated by 
 *              hosts and placed in the checksum field of the predefined UDP/IP 
 *              header configured from hosts.
 *        <li> Store the ones complement of the result from step 2 in the 
 *              checksum field.
 *      </ol>
 *      </tt>
 *
 *
 *  For packets received from network following validation is done:
 *      
 *    <li> Verify  IP checksum by calculating the ones complement sum over 
 *          the IP header. If the calculated result is not all zero or all one, 
 *          discard the received packet. 
 *
 *    <li> Verify the UDP checksum if UDP checksum check is enabled in the 
 *          following steps: 
 *      
 *      <tt>
 *      <ol>
 *        <li> Calculate the pseudo header checksum using IP header.
 *        <li> Do ones complement sum over pseudo header checksum, UDP header 
 *              and UDP payload. If the calculated result is not all zero or 
 *              all one, discard the received packet.
 *      </ol>
 *      </tt> 
 *
 *    <li> In case of any violation condition send packet violation event to host 
 *      
 *  </ul>
 *
 * @HLINE
 *
 *
 *  @section describe_aal5 Function of AAL5
 *
 *  In telephony to network direction, packets are segmented to cells. The 
 *  trailer and necessary padding bytes are added to the last cell. The length 
 *  field and CRC field in the trailer are updated. The out going packets have 
 *  one or multiple cells and the AUU parameter of the last cell is one. 
 *
 *  In network to telephony direction, the receiving cells are re-assembled. 
 *  The CRC check is performed. If the CRC check fails, the packet is dropped.
 *
 * @HLINE
 *
 *
 *  @section describe_ethernet Function of Ethernet
 *
 *  When configured to receive packets from GMAC device module exposes API's to 
 *  do two phase processing of packets. Module supports lookup of the channel 
 *  instance from a 16 bit key which is UDP destination port for all default 
 *  Ethernet/IP/UDP packets.In the first phase module can identify the
 *  instance based on the incoming packet header. In the second phase module supports
 *  additional validation of packet before passing the payload for further processing.
 * 
 * 
 *  The Ethernet packets received by module from network can be one of the 
 *  following four types:
 *
 *  <ol>
 *    <li> DIX Ethernet
 *    <li> 802.3 Ethernet
 *    <li> DIX Ethernet with VLAN Tag
 *    <li> 802.3 Ethernet with VLAN Tag
 *  </ol>
 *
 *  For incoming packets from network NEU is capable of doing Ethernet remote 
 *  address check, local address check of broadcasting and multicasting and 
 *  protocol type check.
 *
 * @HLINE
 *
 *
 *  @section describe_ppp Function of PPP and LLC/SNAP
 *
 *  When NEU receives a PPP or LLC/SNAP packet from network, it checks the 
 *  protocol type when enabled and drops the packet if the protocol type is not 
 *  IPv4 or IPv6.
 *
 *
 */


/**
 * @page mips_details  MIPS Requirements
 *
 * @HLINE
 *
 * @section content Page Contents
 *  
 *  MIPS profiling data is only available for the c64x+ target.
 *  
 * @HLINE
 *
 * 
 * @section c64p_mips C64x+ Target 
 *  
 *  <table>  
 *    <tr>
 *      <th> TX / RX </th>
 *      <th>Minimum</th>
 *      <th>Average</th>
 *      <th>Maximum</th>
 *    </tr>
 *    <tr>
 *      <td> TX </td>
 *      <td>1103</td>
 *      <td>2697</td>
 *      <td>8252</td>
 *    </tr>
 *    <tr>
 *      <td> RX </td>
 *      <td>719</td>
 *      <td>868</td>
 *      <td>1018</td>
 *    </tr>
 *  </table>
 *
 *  NOTE : Profiling data for NEU is computed as the number of cycles per 
 *         packet for a maximum packet size of 1500 bytes.
 *
 *
 */

 
/**
 * @page memory_details  Memory Requirements
 *
 * @HLINE
 *
 * @section content Page Contents
 *  
 *  <ol>
 *    <li> @ref c64_memory
 *      <ul> 
 *        <li> @ref c64_memory_data
 *        <li> @ref c64_memory_prog
 *        <li> @ref c64p_memory_prog
 *      </ul>
 *  </ol>
 *  
 * @HLINE
 * 
 *
 * @section c64_memory  C64x / C64x+ Target
 *  
 * @subsection  c64_memory_data  Data Requirements
 *
 *  <table>
 *    <caption align="bottom">Per Instance Data Buffers</caption>
 *    <tr>
 *      <th rowspan="2"> Buffer ID </th>
 *      <th colspan="2"> Size </th>
 *      <th rowspan="2"> Scratch / Dedicated </th>
 *    </tr>
 *    <tr>
 *      <th> GMAC </th>
 *      <th> UTOPIA </th>
 *    </tr>
 *    <tr align="center">
 *      <td> neu_INSTANCE_BUFN </td>
 *      <td> 120 </td>
 *      <td> 156 </td>
 *      <td> Dedicated </td>
 *    </tr>
 *    <tr align="center">
 *      <td> neu_SSSAR_BUFN </td>
 *      <td> 0 </td>
 *      <td> 28 </td>
 *      <td> Dedicated </td>
 *    </tr>
 *    <tr align="center">
 *      <td> neu_TX_SCRATCH_BUFN </td>
 *      <td colspan="2"> Configurable (see neuSizeCfg_t::txScratchSize) </td>
 *      <td> Scratch </td>
 *    </tr>
 *    <tr align="center">
 *      <td> neu_TX_HEADER_BUFN </td>
 *      <td colspan="2"> Configurable (see neuSizeCfg_t::txHeaderSize) </td>
 *      <td> Dedicated </td>
 *    </tr>
 *    <tr align="center">
 *      <td> neu_RX_PKTASM_BUFN </td>
 *      <td colspan="2"> Configurable (see neuSizeCfg_t::rxAssemSize) </td>
 *      <td> Scratch </td>
 *    </tr>
 *  </table>
 *
 *
 *  <table>
 *    <caption align="bottom">Additional Data Memory</caption>
 *    <tr>
 *      <th rowspan="2"> Section </th>
 *      <th colspan="2"> Size </th>
 *    </tr>
 *    <tr>
 *      <th> Gmac </th>
 *      <th> Utopia </th>
 *    </tr>
 *    <tr align="center">
 *      <td> .cinit </td>
 *      <td> 68 </td>
 *      <td> 68 </td>
 *    </tr>
 *    <tr align="center">
 *      <td> .far </td>
 *      <td> 60 </td>
 *      <td> 60 </td>
 *    </tr>
 *    <tr align="center">
 *      <td> .const </td>
 *      <td> 8 </td>
 *      <td> 8 </td>
 *    </tr>
 *    <tr align="center">
 *      <td> .switch </td>
 *      <td> 52 </td>
 *      <td> 76 </td>
 *    </tr>
 *    <tr align="center">
 *      <td> neuContext (defined externally) (see neuContext_t) </td>
 *      <td> 216 </td>
 *      <td> 216 </td>
 *    </tr>
 *    <tr align="center">
 *      <th> Total </th>
 *      <td> 404 </td>
 *      <td> 428 </td>
 *    </tr>
 *  </table>
 *
 * @subsection  c64_memory_prog  C64x Program Requirements
 *
 *  <table>
 *    <caption align="bottom">Program Memory Requirements</caption>
 *    <tr>
 *      <th rowspan="2"> Section </th>
 *      <th colspan="2"> Size </th>
 *    </tr>
 *    <tr>
 *      <th> Gmac </th>
 *      <th> Utopia </th>
 *    </tr>
 *    <tr align="center">
 *      <td> .text </td>
 *      <td> 16640 </td>
 *      <td> 24992 </td>
 *    </tr>
 *    <tr align="center">
 *      <td> .initProg </td>
 *      <td> 608 </td>
 *      <td> 768 </td>
 *    </tr>
 *    <tr align="center">
 *      <td> .controlProg </td>
 *      <td> 4992 </td>
 *      <td> 3968 </td>
 *    </tr>
 *    <tr align="center">
 *      <td> .tdm2pkttpk2tdmProg </td>
 *      <td> 128 </td>
 *      <td> 128 </td>
 *    </tr>
 *    <tr align="center">
 *      <td> .pkt2tdmProg </td>
 *      <td> 288 </td>
 *      <td> 736 </td>
 *    </tr>
 *    <tr align="center">
 *      <td> .tdm2pktProg </td>
 *      <td> 3232 </td>
 *      <td> 4544 </td>
 *    </tr>
 *    <tr align="center">
 *      <th> Total </th>
 *      <td> 25888 </td>
 *      <td> 35136 </td>
 *    </tr>
 *  </table>
 *
 * @HLINE
 * 
 *
 * @subsection  c64p_memory_prog  C64x+ Program Requirements
 *
 *  <table>
 *    <caption align="bottom">Program Memory Requirements</caption>
 *    <tr>
 *      <th rowspan="2"> Section </th>
 *      <th colspan="2"> Size </th>
 *    </tr>
 *    <tr>
 *      <th> Gmac </th>
 *      <th> Utopia </th>
 *    </tr>
 *    <tr align="center">
 *      <td> .text </td>
 *      <td> 14368 </td>
 *      <td> 22336 </td>
 *    </tr>
 *    <tr align="center">
 *      <td> .initProg </td>
 *      <td> 544 </td>
 *      <td> 704 </td>
 *    </tr>
 *    <tr align="center">
 *      <td> .controlProg </td>
 *      <td> 4384 </td>
 *      <td> 3584 </td>
 *    </tr>
 *    <tr align="center">
 *      <td> .tdm2pkttpk2tdmProg </td>
 *      <td> 96 </td>
 *      <td> 96 </td>
 *    </tr>
 *    <tr align="center">
 *      <td> .pkt2tdmProg </td>
 *      <td> 256 </td>
 *      <td> 608 </td>
 *    </tr>
 *    <tr align="center">
 *      <td> .tdm2pktProg </td>
 *      <td> 3104 </td>
 *      <td> 4384 </td>
 *    </tr>
 *    <tr align="center">
 *      <th> Total </th>
 *      <td> 22752 </td>
 *      <td> 31712 </td>
 *    </tr>
 *  </table>
 *
 */

/**
 *  @page example_proj Building the NEU Example Project
 *
 *  The example CCS project for NEU is located in the @c example folder. The 
 *  project contains example code for showing how to implement NEU in an 
 *  application. The project was created for the C6472 EVM, and is currently 
 *  only available in Little Endian. The projects provided are the 
 *  LoopbackProject and the dependent LoopbackProjectConfig. The following 
 *  steps provide details on how to build the example application.
 *
 *  <ol>
 *    <li> Open CCS and import the LoopbackProject and LoopbackProjectConfig 
 *          projects. The project can be imported by performing the following 
 *          steps:
 *  
 *          <ol>
 *            <li> Choose @c Import... under the @c File menu.
 *            <li> In the Import window, select "Existing Projects into Workspace"
 *                  in the "General" folder. Select Next.
 *            <li> Select the root directory as the loopback directory in the 
 *                  example folder. The LoopbackProject and LoopbackProjectConfig
 *                  projects will appear in the Import window. Select both 
 *                  projects and then select Finish.
 *            </ol>
 *
 *    <li> In the LoopbackProject project, the file @c macros.ini contains 
 *          macro definitions which point to the install locations of the CSL
 *          and EMAC driver packages. Change the values of CSL_INSTALL_DIR and
 *          EMAC_INSTALL_DIR to the location of the CSL package and EMAC driver
 *          package, respectively, on your system. 
 *
 *    <li> Import @c macros.ini into CCS. Macros are imported by performing the
 *          following steps: 
 *
 *          <ol>
 *            <li> Choose @c Import... under the @c File menu.
 *            <li> In the Import window, select "Managed Build Macros" in the 
 *                  "CCS" folder. Select Next.
 *            <li> Browse for the @c macros.ini file in the LoopbackProject 
 *                  directory.
 *          </ol>
 *
 *    <li> Set LoopbackProject as the active project and build. The executable 
 *          @c LoopbackProject.out will be created.
 *  </ol>
 *
 *  @note Required packages and version numbers can be found in the release 
 *        notes.
 *
 */
 
/**
 * @page limit_details  Limitations
 *
 */

 
/**
 * @page standard_details  Standard Compliance
 *
 */

 
/**
 * @page building_xdc Build Procedure using XDC
 *
 *  @section tools Required Tools
 *
 *  The following tools are required to build the @COMP component.
 *  Download and install all tools to a single local (@c C:) directory, for 
 *  example @c c:\\tools.
 *
 *   <ol>
 *     <li> Code Generation 
 *       <ul>
 *         <li> CG Tools for C64x
 *         <li> CG Tools for C66x
 *       </ul>
 *     <li> XDC 
 *     <li> xDAIS 
 *   </ol>
 *
 * @note Version information can be found in the release notes.
 *
 *
 * @section config Configuration
 *
 * @subsection win32 Windows Environment
 *
 *  Once all tools are properly installed, the environment will need to be configured 
 *  to recognize the tool paths. A Windows batch file should be created to provide a
 *  consistent manner to achieve this. The example below can be used (cut & paste) to 
 *  create a @c setenv.bat batch file in the <tt>...\\ti\\mas\\swtools directory</tt>.
 *
 * @note The following example makes the assumptions:
 *
 *  <ol>
 *    <li> The XDC tools were installed in @c c:\\tools
 *    <li> The C64 code generation tools were installed in @c c:\\tools\\cgen_6_0_15
 *    <li> The C66 code generation tools were installed in @c c:\\tools\\cgen_7_2_0A10155
 *    <li> The xDAIS developr's kit was installed in @c c:\\tools\\xdais_5_21
 *  </ol>
 *
 *  @note Please read the release notes for correct version information.
 *
 * @verbatim

    @echo off
    rem # *************************************************************************
    rem # *** Version information (ONLY EDIT THIS SECTION)
    rem # *************************************************************************
    set LOCAL_TOOLSDIR=tools
    set XDCBASE=xdctools_3_20_00_41
    set C64CODEGENBASE=cgen_6_0_15
    set C66CODEGENBASE=cgen_7_2_0A10155
    set XDAISBASE=xdais_5_21

    rem # *************************************************************************
    rem # *** Set up tools directory
    rem # *************************************************************************
    set LOCAL_TOOLSDIR_DOS=c:\%LOCAL_TOOLSDIR%

    rem # *************************************************************************
    rem # ** Set code generation tools path
    rem # *************************************************************************
    set C64CODEGENTOOL=%LOCAL_TOOLSDIR_DOS%\%C64CODEGENBASE%
    set C66CODEGENTOOL=%LOCAL_TOOLSDIR_DOS%\%C66CODEGENBASE%

    rem # *************************************************************************
    rem # ** Set the PATH
    rem # *************************************************************************
    set PATH=%SystemRoot%;%SystemRoot%\system32
    set PATH=%PATH%;%LOCAL_TOOLSDIR_DOS%\%XDCBASE%

    rem # *************************************************************************
    rem # ** Create environment variables for XDC
    rem # *************************************************************************
    set XDCCGROOT=%LOCAL_TOOLSDIR_DOS%
    set xdc=\%LOCAL_TOOLSDIR%\%XDCBASE%\xdc.exe $*

    rem # *************************************************************************
    rem # ** Set the XDC PATH
    rem # *************************************************************************
    set XDCPATH=%LOCAL_TOOLSDIR_DOS%\%XDCBASE%\packages
    set XDCPATH=%XDCPATH%;%LOCAL_TOOLSDIR_DOS%\%XDAISBASE%\packages

    rem # *************************************************************************
    rem # ** Identify the config.bld file
    rem # *************************************************************************
    xs -f setconfig.js
    call tempcfg
    del tempcfg.bat

    rem # End of file
   @endverbatim
 *
 * @note The swtools component contains a similar batch file, named cygwinxdc.bat, 
 *       that was used to generate the NEU component package. Calling 
 *       'cygwinxdc.bat bypass' on the command line will set up the environment, 
 *       however, it will be required to confirm that the path for the tools are 
 *       correct.
 *
 *
 * @subsection linux Linux Environment
 *
 *  TBD
 *
 *
 * @section compile Compilation using XDC
 *
 *  To build the @COMP package, ensure (again) that all packages provided with the 
 *  build have been extracted to a common working directory (as described in 
 *  @ref integrate_details). Change to the @c swtools directory and configure the build 
 *  environment by executing the @c setenv.bat batch file.  To build the @COMP using the 
 *  XDC tools, change to the @COMP directory and proceed.
 *
 *  With the environment configured, XDC may be employed to build the @COMP and its
 *  dependent packages. The four XDC commands below are all that is needed to
 *  clean and build any of the @COMP packages.  The first two commands provide a means
 *  to clean and build the @COMP package (alone).  Nothing further is needed unless 
 *  the source for a dependent packages has changed.
 *
 *  If the source for any of the dependent packages has changed, commands (3) and (4)
 *  below provide a mechanism to clean and build both the @COMP and all dependent packages.
 *
 * @note In the above, the @c \<WORK\>/ti/mas/ path is assumed and just the sub-directories 
 *       are specified (e.g., @c neu).  
 *
 *  The XDC environment provides several build options.
 *
 *  <ol>
 *    <li> <tt>xdc clean</tt>
 *      <ul>
 *        <li> Removes all generated @COMP build files
 *        <li> Analagous to "make clean"
 *      </ul>
 *
 *    <li> <tt>xdc XDCARGS="c\<rtarg\> obj"</tt>
 *      <ul>
 *        <li> Builds the @COMP for the target specified by @c \<rtarg\> (see Table 2 in 
 *             @ref integrate_details)
 *      </ul>
 *
 *    <li> <tt>xdc XDCARGS="c\<rtarg\> obj" -PD .</tt>
 *      <ul>
 *        <li> Builds the @COMP as in (2) above
 *        <li> The <tt>"-PD ."</tt> option ensures that all dependent packages are built as 
 *             well (if needed).
 *      </ul>
 *
 *    <li> <tt>xdc clean -PD .</tt>
 *      <ul>
 *        <li> Removes all generated @COMP build files as in (1) above
 *        <li> Removes all generated build files for all @COMP dependent packages
 *      </ul>
 *  </ol>
 *  
 * @HLINE
 *
 *
 *  @section neu_build_libs Building NEU Libraries
 *
 *  The @COMP package can be used to build different libraries which have 
 *  functionality for different network interfaces. Currently only the GMAC
 *  and UTOPIA interfaces are supported. Additional options are supplied to 
 *  XDCARGS to choose which interface should be built.
 *
 *  <table>
 *    <tr>
 *      <th> Name </th>
 *      <th> Option </th>
 *      <th> Description </th>
 *      <th> Example </th>
 *    </tr>
 *    <tr>
 *      <td> <i> neu_gmac </i> </td>
 *      <td> <br> </td>
 *      <td> By default, NEU will be built with GMAC interface functionality </td>
 *      <td> <b> xdc XDCARGS="c\<rtarg\> obj" </b> will build NEU with GMAC for the specified target. </td>
 *    </tr>
 *    <tr>
 *      <td> <i> neu_utopia </i> </td>
 *      <td> \c utopia </td>
 *      <td> Build NEU with Utopia interface functionality instead of GMAC. </td>
 *      <td> <b> xdc XDCARGS="c\<rtarg\> obj utopia" </b> will build NEU with UTOPIA for the specified target. </td>
 *    </tr>
 *  </table>
 *
 */

/**
 * @page building_make Build Procedure using Make
 *
 *  @section tools Required Tools
 *
 *  One of the following tools is required to build the @COMP component 
 *  depending on which target the NEU package is provided for.
 *  Download and install all tools to a single local (@c C:) directory, for 
 *  example @c c:\\tools.
 *
 *   <ol>
 *     <li> CG Tools for C64x
 *     <li> CG Tools for C66x
 *   </ol>
 *
 *  In addition to the code generation tools, the GNU tools gmake, rm, cp, mkdir,
 *  sed, and make
 *
 * @note Version information can be found in the release notes.
 *
 *
 * @section config Configuration
 *
 * @subsection win32 Windows Environment
 *
 *  Once all tools are properly installed, the environment will need to be configured 
 *  to recognize the tool paths. NEU contains an example batch file (setupenv.bat) 
 *  for setting up the environment, but will need to be changed depending on the 
 *  location of the installed tools. 
 *
 * @HLINE
 *
 *
 * @subsection Compilation Using Make
 *
 *  Once the environment has been configured, NEU is ready to be compiled using the
 *  make utility. When executed from the windows command prompt, the batch file 
 *  neubuilder.bat will build NEU and all dependent components.
 *
 */


/**
 * @page integrate_details  @COMP Integration 
 *  
 * @HLINE
 *
 * @section content Page Contents
 *  
 *  <ul>
 *    <li> @ref tools
 *    <li> @ref pack
 *    <li> @ref include
 *    <li> @ref options
 *    <li> @ref linking
 *    <li> @ref context
 *  </ul>
 *  
 * @HLINE
 *
 *
 * @section tools XDC Build Tools
 *
 *  All Real-Time Software Component (RTSC) packages currently require the Expanded 
 *  C Package Build Tools (XDC) environment to build.  The XDC tools need to be 
 *  installed even for linking a RTSC library.  Directions for loading the proper XDC 
 *  tools can be found in @ref building_xdc.
 *
 * @HLINE
 *
 *
 * @section pack Packages
 *
 *  The list of dependent packages is provided below. See the release notes for
 *  version and compatibility information.
 *  
 *  <ol>
 *    <li> \c ti.mas.types 
 *    <li> \c ti.mas.util  
 *    <li> \c ti.mas.pktutl 
 *    <li> \c ti.mas.iface.ifpkt
 *    <li> \c ti.mas.iface.ifneu
 *    <li> \c ti.mas.iface.ifrcu
 *    <li> \c ti.mas.swtools 
 *  </ol>
 *  
 *  
 *  Each package in the above table is provided as a zip-file and should be 
 *  expanded (unzipped) to a common working directory (@c \<WORK\>).  This will
 *  create the following directory structure under the common directory.
 *
 * @verbatim

  <WORK>/ti/mas/neu
               /pktutl
               /swtools
               /types
               /util
               /iface/ifpkt
                     /ifneu
                     /ifrcu

   @endverbatim
 *  Please note that this directory structure and its content should be maintained to 
 *  allow subsequent compilation.
 *
 * @HLINE
 *
 *
 * @section include Include Requirements
 *
 *  The following header files must be included in any source file that references
 *  the @COMP API:
 *
 *   <ol>
 *     <li> @c \#include @c <ti/mas/types/types.h>
 *     <li> @c \#include @c <ti/mas/neu/neu.h>
 *   </ol>
 *
 *  The compile-time options below are required such that both @c \<WORK\> and XDC's 
 *  @c std.h reside in the compiler's include path.
 *
 *   <ol>
 *     <li> @c -i @c \<TOOLSXDC\>/packages
 *     <li> @c -i @c \<WORK\>
 *   </ol>
 *
 *  Where @c TOOLSXDC is the path to XDC tools and @c WORK is the path 
 *  to the working directory.  Note that the TOOLSXDC path includes everything up to and 
 *  including the XDC tools version (e.g., @c C:\\tools\\gen\\xdc\\xdc_3_00_04).
 *
 * @HLINE
 *
 *
 * @section options Compile Options
 *
 *  When compiling source files that include RTSC package header files, the following 
 *  compiler options must be specified:
 *
 *   <ol>
 *     <li> @c -Dti_targets_\<xtarg\> 
 *     <li> @c -Dxdc_target_name__=\<xtarg\> 
 *     <li> @c -Dxdc_target_types__=ti/targets/std.h 
 *     <li> @c -Dxdc__nolocalnames 
 *   </ol>
 *
 *  Where @c \<xtarg\> represents the target platform using the XDC naming convention 
 *  (see Table 1 below).
 *
 * @HLINE
 *
 *
 * @section linking Linking
 *
 *  The following libraries must be linked:
 *
 *  <ol>
 *    <li> @c ti\\mas\\util\\c\<rtarg\>\\util_a.a\<ltarg\>
 *    <li> @c ti\\mas\\util\\c\<rtarg\>\\util_c.a\<ltarg\>
 *    <li> @c ti\\mas\\pktutl\\c\<rtarg\>\\pktutl_a.a\<ltarg\>
 *    <li> @c ti\\mas\\pktutl\\c\<rtarg\>\\pktutl_c.a\<ltarg\>
 *    <li> @c ti\\mas\\neu\\c\<rtarg\>\\neu_\<interface\>_c.a\<ltarg\>
 *  </ol>
 *
 *  Where @c \<interface\> is either \c gmac or \c utopia.
 *
 * @HLINE
 *
 *
 *  <table>
 *     <caption align="bottom">Table 1.  Target Naming Conventions</caption>
 *     <tr>
 *       <td><B>Target</B></td>
 *       <td><B>RTSC Naming (\<rtarg\>)</B></td>
 *       <td><B>XDC Naming (\<xtarg\>)</B></td>
 *       <td><B>Library Naming (\<ltarg\>)</B></td>
 *       <td><B>Library Format</B></td>
 *     </tr>
 *     <tr>
 *       <td>C64x Little Endian</td>
 *       <td>@c 64le</td>
 *       <td>@c C64</td>
 *       <td>@c 64</td>
 *       <td>@c COFF</td>
 *     </tr>
 *     <tr>
 *       <td>C64x Big Endian</td>
 *       <td>@c 64be</td>
 *       <td>@c C64_big_endian</td>
 *       <td>@c 64e</td>
 *       <td>@c COFF</td>
 *     </tr>
 *     <tr>
 *       <td>C64x+ Little Endian</td>
 *       <td>@c 64Ple</td>
 *       <td>@c C64P</td>
 *       <td>@c 64P</td>
 *       <td>@c COFF</td>
 *     </tr>
 *     <tr>
 *       <td>C64x+ Big Endian</td>
 *       <td>@c 64Pbe</td>
 *       <td>@c C64P_big_endian</td>
 *       <td>@c 64Pe</td>
 *       <td>@c COFF</td>
 *     </tr>
 *     <tr>
 *       <td>C66x Little Endian</td>
 *       <td>@c 66le</td>
 *       <td>@c C66</td>
 *       <td>@c e66</td>
 *       <td>@c ELF</td>
 *     </tr>
 *     <tr>
 *       <td>C66x Big Endian</td>
 *       <td>@c 66be</td>
 *       <td>@c C66_big_endian</td>
 *       <td>@c e66e</td>
 *       <td>@c ELF</td>
 *     </tr>
 *   </table> 
 *
 *  @HLINE
 *
 *
 * @section context Context Structure
 *
 *  Information on NEU's context structure is found here: @ref neuContext_t.
 *
 */


/**
 * @page external_api @COMP External API
 *  
 * @HLINE
 *
 * @section content Page Contents
 *
 *  <ul>
 *    <li> @ref functions
 *    <li> @ref ret_vals
 *  </ul>
 *
 *
 *  @HLINE
 *
 *  @subsection functions API Functions
 *
 *  <ol>
 *    <li> @ref neu_api_create 
 *    <li> @ref neu_api_configure
 *    <li> @ref neu_api_execute 
 *    <li> @ref neu_api_destroy
 *  </ol>
 *
 *
 *  @HLINE
 *
 *  @subsection ret_vals API Return Values
 *
 *  <ol>
 *    <li> @ref neu_err_code
 *    <li> @ref neu_nv_codes
 *    <li> @ref neu_exc_msgs
 *  </ol>
 *
 * @HLINE
 */


/**
 * @page Disclaimer
 *<center> <B>IMPORTANT NOTICE </B> </center>
 * Texas Instruments Incorporated and its subsidiaries (TI) reserve the right
 * to make corrections, modifications, enhancements, improvements, and other
 * changes to its products and services at any time and to discontinue any
 * product or service without notice. Customers should obtain the latest
 * relevant information before placing orders and should verify that such
 * information is current and complete. All products are sold subject to TIs
 * terms and conditions of sale supplied at the time of order acknowledgment.
 *
 * TI warrants performance of its hardware products to the specifications
 * applicable at the time of sale in accordance with TIs standard warranty.
 * Testing and other quality control techniques are used to the extent TI
 * deems necessary to support this warranty. Except where mandated by
 * government requirements, testing of all parameters of each product is not
 * necessarily performed.
 *
 * TI assumes no liability for applications assistance or customer product
 * design. Customers are responsible for their products and applications
 * using TI components. To minimize the risks associated with customer
 * products and applications, customers should provide adequate design and
 * operating safeguards.
 *
 * TI does not warrant or represent that any license, either express or
 * implied, is granted under any TI patent right, copyright, mask work right,
 * or other TI intellectual property right relating to any combination,
 * machine, or process in which TI products or services are used. Information
 * published by TI regarding third-party products or services does not
 * constitute a license from TI to use such products or services or a warranty
 * or endorsement thereof. Use of such information may require a license from a
 * third party under the patents or other intellectual property of the third
 * party, or a license from TI under the patents or other intellectual property
 * of TI.
 *
 * Reproduction of information in TI data books or data sheets is permissible
 * only if reproduction is without alteration and is accompanied by all
 * associated warranties, conditions, limitations, and notices. Reproduction
 * of this information with alteration is an unfair and deceptive business
 * practice. TI is not responsible or liable for such altered documentation.
 *
 * Resale of TI products or services with statements different from or beyond
 * the parameters stated by TI for that product or service voids all express
 * and any implied warranties for the associated TI product or service and is
 * an unfair and deceptive business practice. TI is not responsible or liable
 * for any such statements.
 *
 *
 *
 *
 * Mailing Address: <BR>
 * Texas Instruments <BR>
 * Post Office Box 655303 <BR>
 * Dallas, Texas 75265 <BR>
 *
 *
 *
 * Copyright  2010 Texas Instruments Incorporated.
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 * Information in this document is subject to change without notice.
 * Texas Instruments may have pending patent applications, trademarks,
 * copyrights, or other intellectual property rights covering matter in this
 * document.  The furnishing of this document is given for usage with Texas
 * Instruments products only and does not give you any license to the
 * intellectual property that might be contained within this document.
 * Texas Instruments makes no implied or expressed warranties in this document
 * and is not responsible for the products based from this document.
 *
*/
