# ==============================================================================
# File            : Makedocs.mk
# Description     : 
#
#   GNU makefile to generate OVLY documentation from sources using Doxygen
#
# ==============================================================================

# The target for generating documents using doxygen is gendocs

RELEASE_DOC=./docs/doxygen/release.chm

releasenotes : $(RELEASE_DOC)

$(RELEASE_DOC): ./docs/doxygen/release.h
	-@echo generating Release Notes ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen ../swtools/docs/doxygen/releaseDoxyfile
	@xs -f ../swtools/release.js
OVLYAPI_DOC=./docs/doxygen/OVLYAPI.chm
OVLY_DOC=./docs/doxygen/OVLY.chm

release : $(OVLYAPI_DOC) $(OVLY_DOC)

gendocs $(OVLY_DOC): ovly.h ./docs/doxygen/doxygen.h
	-@echo generating OVLY documentation ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen.exe ./docs/doxygen/Doxyfile

genapidocs $(OVLYAPI_DOC): ovly.h ./docs/doxygen/doxygen.h
	-@echo generating OVLY API documentation ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen.exe ./docs/doxygen/APIDoxyfile

# End of Makedocs.mk
