/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



#include <ti/mas/types/types.h>
#include <stdio.h>
#include <stdlib.h>

#include "ovlybmp.h"
#pragma DATA_SECTION(ovlyLogoImageY, ".ovly_bmp")
#pragma DATA_SECTION(ovlyLogoImageU, ".ovly_bmp")
#pragma DATA_SECTION(ovlyLogoImageV, ".ovly_bmp")

#if 0
// Basic Transform
Y =  66 * R + 129 * G +  25 * B;
U = -38 * R -  74 * G + 112 * B;
V = 112 * R -  94 * G -  18 * B;

// Scale down to 8 bits with rounding

Y = ( Y + 128 ) >> 8;
U = ( U + 128 ) >> 8;
V = ( V + 128 ) >> 8;

// Shift values

Y +=  16;
U += 128;
V += 128;
#endif
/******************************************************************/
/*** YUV plane of 420P type assumed in all functions bellow!!!! ***/
/******************************************************************/
void ovly_bmp (tword *yuv_planes, tuint Width, tuint Height, 
                 tuint pos_x, tuint pos_y, 
                 tword *bmp_arr, tuint bmp_arr_w, tuint bmp_arr_h, 
                 tword luma, tword chroma_r, tword chroma_b)
{                 
    tuint i, j;
    tulong byte_offset;
    tword *y_plane, *u_plane, *v_plane;
    tword *roi_y, *roi_u, *roi_v, *ptrBmp;
    /* Set Y-plane */
    ptrBmp  = bmp_arr;
    y_plane = &yuv_planes[0];
    byte_offset = (tulong)pos_x + (tulong)pos_y * (tulong)Width;    
    for (i = 0; i < bmp_arr_h; i ++)
    { /* 420P */
      roi_y = (tword *)&y_plane[byte_offset];
      for (j = 0; j < bmp_arr_w; j ++)
      {
        if(*ptrBmp < 0x80)
        { /* Make Logo always visible */
          *roi_y = luma;
        }
        roi_y  ++;
        ptrBmp ++;        
      }
      byte_offset += (tulong)Width;
    }
    /* Set U and V planes */    
    u_plane = &y_plane[(tulong)Width * (tulong)Height];
    Width  >>= 1;
    Height >>= 1;
    v_plane = &u_plane[(tulong)Width * (tulong)Height];    
    ptrBmp = bmp_arr;    
    bmp_arr_w >>= 1;
    bmp_arr_h >>= 1;
    pos_x  >>= 1;
    pos_y  >>= 1;    
    byte_offset = (tulong)pos_x + (tulong)pos_y * (tulong)Width;    
    for (i = 0; i < bmp_arr_h; i ++)
    { /* 420P */
      roi_u = (tword *)&u_plane[byte_offset];
      roi_v = (tword *)&v_plane[byte_offset];
      for (j = 0; j < bmp_arr_w; j ++)
      {
        if(*ptrBmp < 0x80)
        { /* Make Logo always visible */
          *roi_u = chroma_r;
          *roi_v = chroma_b;
        }
        roi_u  ++;
        roi_v  ++;                
        ptrBmp ++;
        ptrBmp ++;        
      }
      byte_offset += (tulong)Width;
      ptrBmp      += (bmp_arr_w << 1); /* Skip one line */
    }
}
/******************************************************************/
/***                   Fixed TI logo rendering                  ***/
/******************************************************************/
void ovly_logo (tword *yuv_planes, tuint Width, tuint Height, tuint pos_x, tuint pos_y,
               tword luma, tword chroma_r, tword chroma_b)
{
  ovly_bmp (yuv_planes, Width, Height, pos_x, pos_y, ovlyLogoImageY, OVLY_LOGO_IMAGE_W, OVLY_LOGO_IMAGE_H, 
           luma, chroma_r, chroma_b);
}
/******************************************************************/
/***       Fixed rectangular TI logo rendering                  ***/
/******************************************************************/
void ovly_fixed_logo (tword *yuv_planes, tuint Width, tuint Height, tuint pos_x, tuint pos_y)
{
    tuint i;
    tword *y_plane, *u_plane, *v_plane;
    tword *roi, *bmpLogoPlane;
    /* Set planes */
    y_plane = &yuv_planes[0];
    u_plane = &yuv_planes[(tulong)Width * (tulong)Height];
    v_plane = &u_plane[(tulong)(Width >> 1) * (tulong)(Height >> 1)];

    roi = &y_plane[(tulong)pos_y * (tulong)Width + (tulong)pos_x];
    bmpLogoPlane = &ovlyLogoImageY[0];
    for (i = 0; i < OVLY_LOGO_IMAGE_H; i ++)
    { /* 420P */
      memcpy (roi, bmpLogoPlane, OVLY_LOGO_IMAGE_W);
      roi = &roi[Width];
      bmpLogoPlane = &bmpLogoPlane[OVLY_LOGO_IMAGE_W];
    }
    /* Set U and V planes */
    pos_x >>= 1;
    pos_y >>= 1;
    Width  >>= 1;
    Height >>= 1;
    roi = &u_plane[(tulong)pos_y * (tulong)Width + (tulong)pos_x];
    bmpLogoPlane = (tword *)&ovlyLogoImageU[0];
    for (i = 0; i < OVLY_LOGO_IMAGE_H/2; i ++)
    { /* 420P */
      memcpy (roi, bmpLogoPlane, OVLY_LOGO_IMAGE_W/2);
      roi = &roi[Width];
      bmpLogoPlane = &bmpLogoPlane[OVLY_LOGO_IMAGE_W / 2];
    }
    roi = &v_plane[(tulong)pos_y * (tulong)Width + (tulong)pos_x];
    bmpLogoPlane = (tword *)&ovlyLogoImageV[0];
    for (i = 0; i < OVLY_LOGO_IMAGE_H/2; i ++)
    { /* 420P */
      memcpy (roi, bmpLogoPlane, OVLY_LOGO_IMAGE_W/2);
      roi = &roi[Width];
      bmpLogoPlane = &bmpLogoPlane[OVLY_LOGO_IMAGE_W / 2];
    }
}
/*** nothing past this point ***/
