/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



/*==========================================================================*/
/* FILE PURPOSE: Define very simple font rendering functionality.			*/
/* Array with font definition can be created using simple desktop tools,    */
/* which does conversion between .FNT files and format presented below      */
/*==========================================================================*/
#include <ti/mas/types/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <ti/mas/ovly/src/ovlyBinNum.h>
#define OVLY_CHAR_H 12
#define OVLY_CHAR_W  8
#define OVLY_CHAR_BASE 32
#define OVLY_CHAR_NUM  96

#pragma DATA_SECTION(ovlyFontChars, ".ovly_bmp")
#pragma DATA_SECTION(ovlyFontCharsWidthAdjustments, ".ovly_bmp")
//==========================================================================
//  definition of a small bitmap font (offset of 32 wrt ASCII) 
//==========================================================================
tword ovlyFontChars[OVLY_CHAR_NUM][OVLY_CHAR_H] =
{
 {b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000}, /* ' ' */
 {b00000000,b00000000,b01000000,b00000000,b01000000,b01000000,b01000000,b01000000,b01000000,b01000000,b00000000,b00000000}, /* '!' */
 {b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b10100000,b10100000,b10100000,b00000000}, /* '"' */
 {b00000000,b00000000,b01010000,b01010000,b11111100,b00101000,b00101000,b01111110,b00010100,b00010100,b00000000,b00000000}, /* '#' */
 {b00100000,b00100000,b11110000,b01001000,b01001000,b01110000,b10100000,b10100000,b01111000,b00100000,b00100000,b00000000}, /* '$' */
 {b00000000,b00000000,b00100010,b00100101,b00010101,b00010010,b01001000,b10101000,b10100100,b01000100,b00000000,b00000000}, /* '%' */
 {b00000000,b00000000,b01110010,b10001100,b10001000,b10010100,b01100100,b10010000,b10010000,b01100000,b00000000,b00000000}, /* '&' */
 {b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b10000000,b10000000,b10000000,b00000000}, /* ''' */
 {b00100000,b01000000,b01000000,b10000000,b10000000,b10000000,b10000000,b10000000,b01000000,b01000000,b00100000,b00000000}, /* '(' */
 {b10000000,b01000000,b01000000,b00100000,b00100000,b00100000,b00100000,b00100000,b01000000,b01000000,b10000000,b00000000}, /* ')' */
 {b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00100000,b10101000,b01110000,b10101000,b00100000,b00000000}, /* '*' */
 {b00000000,b00000000,b00010000,b00010000,b00010000,b11111110,b00010000,b00010000,b00010000,b00000000,b00000000,b00000000}, /* '+' */
 {b10000000,b01000000,b01000000,b01000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000}, /* ',' */
 {b00000000,b00000000,b00000000,b00000000,b00000000,b11100000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000}, /* '-' */
 {b00000000,b00000000,b01000000,b01000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000}, /* '.' */
 {b10000000,b10000000,b10000000,b01000000,b01000000,b01000000,b01000000,b01000000,b00100000,b00100000,b00100000,b00000000}, /* '/' */
 {b00000000,b00000000,b01110000,b10001000,b10001000,b10001000,b10001000,b10001000,b10001000,b01110000,b00000000,b00000000}, /* '0' */
 {b00000000,b01110000,b00100000,b00100000,b00100000,b00100000,b00100000,b00100000,b01100000,b00100000,b00000000,b00000000}, /* '1' */
 {b00000000,b00000000,b11111000,b10000000,b01000000,b00100000,b00010000,b00001000,b10001000,b01110000,b00000000,b00000000}, /* '2' */
 {b00000000,b00000000,b01110000,b10001000,b00001000,b00001000,b00110000,b00001000,b10001000,b01110000,b00000000,b00000000}, /* '3' */
 {b00000000,b00000000,b00010000,b00010000,b00010000,b11111000,b10010000,b01010000,b00110000,b00010000,b00000000,b00000000}, /* '4' */
 {b00000000,b00000000,b01110000,b10001000,b00001000,b00001000,b11110000,b10000000,b10000000,b11111000,b00000000,b00000000}, /* '5' */
 {b00000000,b00000000,b01110000,b10001000,b10001000,b10001000,b11110000,b10000000,b01000000,b00110000,b00000000,b00000000}, /* '6' */
 {b00000000,b00000000,b01000000,b01000000,b00100000,b00100000,b00010000,b00010000,b00001000,b11111000,b00000000,b00000000}, /* '7' */
 {b00000000,b00000000,b01110000,b10001000,b10001000,b10001000,b01110000,b10001000,b10001000,b01110000,b00000000,b00000000}, /* '8' */
 {b00000000,b00000000,b01100000,b00010000,b00001000,b01111000,b10001000,b10001000,b10001000,b01110000,b00000000,b00000000}, /* '9' */
 {b00000000,b00000000,b01000000,b01000000,b00000000,b00000000,b01000000,b01000000,b00000000,b00000000,b00000000,b00000000}, /* ':' */
 {b10000000,b01000000,b01000000,b01000000,b00000000,b00000000,b01000000,b01000000,b00000000,b00000000,b00000000,b00000000}, /* ';' */
 {b00000000,b00000000,b00000010,b00001100,b00110000,b01000000,b00110000,b00001100,b00000010,b00000000,b00000000,b00000000}, /* '<' */
 {b00000000,b00000000,b00000000,b00000000,b11111110,b00000000,b11111110,b00000000,b00000000,b00000000,b00000000,b00000000}, /* '=' */
 {b00000000,b00000000,b01000000,b00110000,b00001100,b00000010,b00001100,b00110000,b01000000,b00000000,b00000000,b00000000}, /* '>' */
 {b00000000,b00000000,b01000000,b00000000,b01000000,b01000000,b00100000,b00010000,b00010000,b11100000,b00000000,b00000000}, /* '?' */
 {b00000000,b00111000,b01000000,b10011110,b10101001,b10101001,b10101001,b10011001,b01000010,b00111100,b00000000,b00000000}, /* '@' */
 {b00000000,b00000000,b10000100,b10000100,b10000100,b11111100,b01001000,b01001000,b01001000,b01111000,b00000000,b00000000}, /* 'A' */
 {b00000000,b00000000,b11110000,b10001000,b10001000,b10001000,b11110000,b10001000,b10001000,b11110000,b00000000,b00000000}, /* 'B' */
 {b00000000,b00000000,b00111100,b01000000,b10000000,b10000000,b10000000,b10000000,b01000000,b00111100,b00000000,b00000000}, /* 'C' */
 {b00000000,b00000000,b11110000,b10001000,b10000100,b10000100,b10000100,b10000100,b10001000,b11110000,b00000000,b00000000}, /* 'D' */
 {b00000000,b00000000,b11111000,b10000000,b10000000,b10000000,b11111000,b10000000,b10000000,b11111000,b00000000,b00000000}, /* 'E' */
 {b00000000,b00000000,b10000000,b10000000,b10000000,b10000000,b11111000,b10000000,b10000000,b11111000,b00000000,b00000000}, /* 'F' */
 {b00000000,b00000000,b00111100,b01000100,b10000100,b10011100,b10000000,b10000000,b01000000,b00111100,b00000000,b00000000}, /* 'G' */
 {b00000000,b00000000,b10000100,b10000100,b10000100,b10000100,b11111100,b10000100,b10000100,b10000100,b00000000,b00000000}, /* 'H' */
 {b00000000,b00000000,b11100000,b01000000,b01000000,b01000000,b01000000,b01000000,b01000000,b11100000,b00000000,b00000000}, /* 'I' */
 {b00000000,b00000000,b11100000,b00010000,b00010000,b00010000,b00010000,b00010000,b00010000,b01110000,b00000000,b00000000}, /* 'J' */
 {b00000000,b00000000,b10001000,b10010000,b10100000,b11000000,b11000000,b10100000,b10010000,b10001000,b00000000,b00000000}, /* 'K' */
 {b00000000,b00000000,b11110000,b10000000,b10000000,b10000000,b10000000,b10000000,b10000000,b10000000,b00000000,b00000000}, /* 'L' */
 {b00000000,b00000000,b10000010,b10000010,b10010010,b10010010,b10101010,b10101010,b11000110,b11000110,b00000000,b00000000}, /* 'M' */
 {b00000000,b00000000,b10001100,b10001100,b10010100,b10010100,b10100100,b10100100,b11000100,b11000100,b00000000,b00000000}, /* 'N' */
 {b00000000,b00000000,b00111000,b01000100,b10000010,b10000010,b10000010,b10000010,b01000100,b00111000,b00000000,b00000000}, /* 'O' */
 {b00000000,b00000000,b10000000,b10000000,b10000000,b11110000,b10001000,b10001000,b10001000,b11110000,b00000000,b00000000}, /* 'P' */
 {b00110000,b00001000,b00111000,b01000100,b10000010,b10000010,b10000010,b10000010,b01000100,b00111000,b00000000,b00000000}, /* 'Q' */
 {b00000000,b00000000,b10000100,b10001000,b10010000,b11110000,b10001000,b10000100,b10001000,b11110000,b00000000,b00000000}, /* 'R' */
 {b00000000,b00000000,b11110000,b00001000,b00001000,b00001000,b01110000,b10000000,b10000000,b01111000,b00000000,b00000000}, /* 'S' */
 {b00000000,b00000000,b00100000,b00100000,b00100000,b00100000,b00100000,b00100000,b00100000,b11111000,b00000000,b00000000}, /* 'T' */
 {b00000000,b00000000,b01111000,b10000100,b10000100,b10000100,b10000100,b10000100,b10000100,b10000100,b00000000,b00000000}, /* 'U' */
 {b00000000,b00000000,b00100000,b00100000,b01010000,b10001000,b10001000,b10001000,b10001000,b10001000,b00000000,b00000000}, /* 'V' */
 {b00000000,b00000000,b01000100,b01000100,b01000100,b10101010,b10010010,b10010010,b10010010,b10000010,b00000000,b00000000}, /* 'W' */
 {b00000000,b00000000,b10001000,b10001000,b01010000,b00100000,b00100000,b01010000,b10001000,b10001000,b00000000,b00000000}, /* 'X' */
 {b00000000,b00000000,b00100000,b00100000,b00100000,b00100000,b01010000,b01010000,b10001000,b10001000,b00000000,b00000000}, /* 'Y' */
 {b00000000,b00000000,b11111000,b10000000,b01000000,b00100000,b00100000,b00010000,b00001000,b11111000,b00000000,b00000000}, /* 'Z' */
 {b11100000,b10000000,b10000000,b10000000,b10000000,b10000000,b10000000,b10000000,b10000000,b10000000,b11100000,b00000000}, /* '[' */
 {b00000000,b00100000,b00100000,b00100000,b01000000,b01000000,b01000000,b01000000,b10000000,b10000000,b10000000,b00000000}, /* '\' */
 {b11100000,b00100000,b00100000,b00100000,b00100000,b00100000,b00100000,b00100000,b00100000,b00100000,b11100000,b00000000}, /* ']' */
 {b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b10000010,b01000100,b00101000,b00010000,b00000000,b00000000}, /* '^' */
 {b11111100,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000}, /* '_' */
 {b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00000000,b00100000,b01000000,b00000000}, /* '`' */
 {b00000000,b00000000,b01111000,b10001000,b10001000,b01111000,b00001000,b01110000,b00000000,b00000000,b00000000,b00000000}, /* 'a' */
 {b00000000,b00000000,b11110000,b10001000,b10001000,b10001000,b10001000,b11110000,b10000000,b10000000,b10000000,b00000000}, /* 'b' */
 {b00000000,b00000000,b01110000,b10000000,b10000000,b10000000,b10000000,b01110000,b00000000,b00000000,b00000000,b00000000}, /* 'c' */
 {b00000000,b00000000,b01111000,b10001000,b10001000,b10001000,b10001000,b01111000,b00001000,b00001000,b00001000,b00000000}, /* 'd' */
 {b00000000,b00000000,b01110000,b10001000,b10000000,b11111000,b10001000,b01110000,b00000000,b00000000,b00000000,b00000000}, /* 'e' */
 {b00000000,b00000000,b10000000,b10000000,b10000000,b10000000,b10000000,b11100000,b10000000,b10000000,b01100000,b00000000}, /* 'f' */
 {b01110000,b00001000,b01111000,b10001000,b10001000,b10001000,b01110000,b00000000,b00000000,b00000000,b00000000,b00000000}, /* 'g' */
 {b00000000,b00000000,b10001000,b10001000,b10001000,b10001000,b11110000,b10000000,b10000000,b10000000,b10000000,b00000000}, /* 'h' */
 {b00000000,b00000000,b10000000,b10000000,b10000000,b10000000,b10000000,b10000000,b00000000,b10000000,b00000000,b00000000}, /* 'i' */
 {b00000000,b00000000,b10000000,b01000000,b01000000,b01000000,b01000000,b11000000,b00000000,b01000000,b00000000,b00000000}, /* 'j' */
 {b00000000,b00000000,b10001000,b10010000,b10100000,b11000000,b10100000,b10010000,b10000000,b10000000,b10000000,b00000000}, /* 'k' */
 {b00000000,b00000000,b10000000,b10000000,b10000000,b10000000,b10000000,b10000000,b10000000,b10000000,b10000000,b00000000}, /* 'l' */
 {b00000000,b00000000,b10010010,b10010010,b10010010,b10010010,b10010010,b01101100,b00000000,b00000000,b00000000,b00000000}, /* 'm' */
 {b00000000,b00000000,b10001000,b10001000,b10001000,b10001000,b10001000,b11110000,b00000000,b00000000,b00000000,b00000000}, /* 'n' */
 {b00000000,b00000000,b01110000,b10001000,b10001000,b10001000,b10001000,b01110000,b00000000,b00000000,b00000000,b00000000}, /* 'o' */
 {b00000000,b00000000,b10000000,b10000000,b11110000,b10001000,b10001000,b11110000,b00000000,b00000000,b00000000,b00000000}, /* 'p' */
 {b10000000,b10000000,b11111000,b10001000,b10001000,b10001000,b10001000,b01111000,b00000000,b00000000,b00000000,b00000000}, /* 'q' */
 {b00000000,b00000000,b10000000,b10000000,b10000000,b10000000,b11000000,b10100000,b00000000,b00000000,b00000000,b00000000}, /* 'r' */
 {b00000000,b00000000,b11100000,b00010000,b00110000,b11000000,b10000000,b01110000,b00000000,b00000000,b00000000,b00000000}, /* 's' */
 {b00000000,b00000000,b01100000,b10000000,b10000000,b10000000,b10000000,b11100000,b10000000,b10000000,b00000000,b00000000}, /* 't' */
 {b00000000,b00000000,b01111000,b10001000,b10001000,b10001000,b10001000,b10001000,b00000000,b00000000,b00000000,b00000000}, /* 'u' */
 {b00000000,b00000000,b00100000,b00100000,b01010000,b01010000,b10001000,b10001000,b00000000,b00000000,b00000000,b00000000}, /* 'v' */
 {b00000000,b00000000,b01000100,b01000100,b10101010,b10101010,b10010010,b10010010,b00000000,b00000000,b00000000,b00000000}, /* 'w' */
 {b00000000,b00000000,b10001000,b01010000,b00100000,b00100000,b01010000,b10001000,b00000000,b00000000,b00000000,b00000000}, /* 'x' */
 {b01000000,b01000000,b00100000,b00100000,b01010000,b01010000,b10001000,b10001000,b00000000,b00000000,b00000000,b00000000}, /* 'y' */
 {b00000000,b00000000,b11110000,b10000000,b01000000,b00100000,b00010000,b11110000,b00000000,b00000000,b00000000,b00000000}, /* 'z' */
 {b00010000,b00100000,b00100000,b00100000,b00100000,b11000000,b00100000,b00100000,b00100000,b00100000,b00010000,b00000000}, /* '{' */
 {b01000000,b01000000,b01000000,b01000000,b01000000,b01000000,b01000000,b01000000,b01000000,b01000000,b01000000,b00000000}, /* '|' */
 {b10000000,b01000000,b01000000,b01000000,b01000000,b00110000,b01000000,b01000000,b01000000,b01000000,b10000000,b00000000}, /* '}' */
 {b00000000,b00000000,b00000000,b00000000,b10001100,b10010010,b01100010,b00000000,b00000000,b00000000,b00000000,b00000000}, /* '~' */
 {b00000000,b00000000,b11111111,b10000001,b10000001,b10000001,b10000001,b10000001,b10000001,b11111111,b00000000,b00000000}  /* '' */
};

/*==================================================================*/
/* Remove some space between characters to make them more appealing */
/*==================================================================*/
tint ovlyFontCharsWidthAdjustments[OVLY_CHAR_NUM] =
{
  5, 4, 4, 0, 2,-1, 1, 6, 4, 4, 2, 0, 4, 4, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 4, 4, 0, 0, 0, 3,-1, 1, 2, 1, 1, 2, 2, 1, 1, 4, 3, 2, 3, 0, 1, 0,
  2, 0, 1, 2, 2, 1, 2, 0, 2, 2, 2, 4, 4, 4, 0, 2, 4, 2, 2, 3, 2, 2, 4, 2,
  2, 6, 5, 3, 6, 0, 2, 2, 2, 2, 4, 3, 4, 2, 2, 0, 2, 2, 3, 3, 4, 3, 0, 0
};
//==========================================================================
void ovly_render_simplefont (tword *yuv, tuint w, tuint h, tuint pos_x, tuint pos_y, tword *str_ovly, 
                            tword luma, tword chroma_r, tword chroma_b)
{
tword *start_bmp, *y_plane, *u_plane, *uv_plane;
tulong uv_plane_size;
tword b_mask, idx;
tuint j, l;
tuint uv_w = w >> 1;
tuint uv_h = h >> 1;
tuint uv_pos_y = pos_y >> 1;
tulong uv_vertical_offset;

 uv_plane_size      = (tulong)uv_w * (tulong)uv_h;   
 uv_vertical_offset = (tulong)uv_pos_y * (tulong)uv_w;
 uv_plane           = &yuv[(tulong)w * (tulong)h]; /* U plane starts at the end of Y plane */
 while (idx = *str_ovly++)
 {
   idx -= OVLY_CHAR_BASE; /* remove offset to align with ASCII */
   start_bmp = &ovlyFontChars[idx][0];
   /******************************************/   
   y_plane = &yuv[(tulong)pos_x + (tulong)pos_y * (tulong)w];
   for (l = 0; l < OVLY_CHAR_H; l ++) 
   {
     b_mask = (tword)start_bmp[OVLY_CHAR_H - 1 - l];
     for (j = 0; j < OVLY_CHAR_W; j ++) 
     {
        if(b_mask & 0x80)
        {
          *y_plane = luma;
        }
        b_mask <<= 1;
        y_plane ++;        
     }
     y_plane = &y_plane[w - OVLY_CHAR_W]; /* move for one line */
   }
   if(chroma_r != 255 || chroma_b != 255)
   {
     /******************************************/   
     u_plane = &uv_plane[(tulong)(pos_x >> 1) + uv_vertical_offset];   
     for (l = 0; l < OVLY_CHAR_H/2; l ++) 
     {
       b_mask = (tword)start_bmp[OVLY_CHAR_H - 1 - l * 2];
       for (j = 0; j < OVLY_CHAR_W/2; j ++) 
       {
          if(b_mask & 0xC0)
          {
            u_plane[0]             = chroma_r;
            u_plane[uv_plane_size] = chroma_b;          
          } 
          b_mask <<= 2;
          u_plane ++;
       }
       u_plane = &u_plane[uv_w - OVLY_CHAR_W/2]; /* move for one line */     
     }
   } 
   /******************************************/
   pos_x += (tuint)(OVLY_CHAR_W - ovlyFontCharsWidthAdjustments[idx]);
   if((pos_x + OVLY_CHAR_W) > w) break;
 }
}

/*********************************************************************************
 * FUNCTION PURPOSE: Overlay a single bar
 *********************************************************************************
  DESCRIPTION:       Overlay a single bar
  Parameters :       Inputs: yuv:        YUV Image Pointer
                             w:          Width of YUV Image
                             h:          Height of YUV Image
                             pos_x:      X-Position where Overlay needs to be done
                             pos_y:      Y-Position where Overlay needs to be done
                             bar_w:      Width of equalizer bar
                             bar_h:      Height of equalizer bar
                             luma:       Luma
                             chroma_r:   Chroma-Red
                             chroma_b:   Chroma-Blue
                      Output: None
 *********************************************************************************/
void ovly_render_equalizerbar (tword *yuv, tuint w, tuint h, 
                               tuint pos_x, tuint pos_y, tuint bar_w, tuint bar_h, 
                               tword luma, tword chroma_r, tword chroma_b)
{

   tword *y_plane, *u_plane, *uv_plane;
   tulong uv_plane_size;
   tuint j, l;
   tuint uv_w = w >> 1;
   tuint uv_h = h >> 1;
   tuint uv_pos_y = pos_y >> 1;
   tulong uv_vertical_offset;

   uv_plane_size      = (tulong)uv_w * (tulong)uv_h;   
   uv_vertical_offset = (tulong)uv_pos_y * (tulong)uv_w;
   uv_plane           = &yuv[(tulong)w * (tulong)h]; /* U plane starts at the end of Y plane */

   y_plane = &yuv[(tulong)pos_x + (tulong)pos_y * (tulong)w];
   for (l = 0; l < bar_h; l ++) 
   {
     for (j = 0; j < bar_w; j ++) 
     {
        *y_plane = luma;
        y_plane ++;        
     }
     y_plane = &y_plane[w - bar_w]; /* move for one line */
   }
   if(chroma_r != 255 || chroma_b != 255)
   {
     /******************************************/   
     u_plane = &uv_plane[(tulong)(pos_x >> 1) + uv_vertical_offset];   
     for (l = 0; l < bar_h/2; l ++) 
     {
       for (j = 0; j < bar_w/2; j ++) 
       {
          u_plane[0]             = chroma_r;
          u_plane[uv_plane_size] = chroma_b;          
          u_plane ++;
       }
       u_plane = &u_plane[uv_w - bar_w/2]; /* move for one line */     
     }
   }
}
/* nothing past this point */
