/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



#ifndef _OVLYLOC_H
#define _OVLYLOC_H
/* System level header files */
/* Standard C header files */
#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <ti/mas/types/types.h>

/* Possible channel states */
typedef enum {
  OVLY_STATE_CLOSED = 0,
  OVLY_STATE_OPEN
} ovlyState_t;

typedef struct ovlyInst_s {
  /* Variables initialized in new fcn call */
  tuint ID;
  tint state;
#define OVLY_OFFSET_STATEVARS (offsetof(ovlyInst_t, stopped))  
  /** Overlay stopped or suspended? */
  tint stopped;
  /** Raw overlay graphics **/
  ovlyCtrlRAWG_t rawg;  
  /** Background YUV, last byte is alpha channel **/
  unsigned char yuv_bg[4];
  /** Foreground YUV, last byte is alpha channel **/  
  unsigned char yuv_fg[4];
  /* timer */
  tulong timer;
  /* timer tick */
  tulong timer_tick;
  /** Timed text local variables **/
  tuint ttxt_len;
  /** UTF-8 text storage buffer **/
  tword ttxtBuff[OVLY_TTEXT_MAXINPUT_BYTES];
} ovlyInst_t;

/* Assert macro for the exceptions */
#define ovly_exc_assert(expr,code,inst) { \
  (expr) ? ((void)0) : ovly_exception((inst)->ID, code); }

/******************************************************************************
 * Set of library functions exported for direct use by other modules
 * These are all stateless functions.
 *****************************************************************************/
void ovly_process_libfcn (ovlyCtrlRAWG_t *rawg, tword *yuvInputFrame, 
                          tuint yuvInputWidth, tuint yuvInputHeight);

void rgb2yuv_convert (tword *out_yuv, tword *in_rgb);
#endif
/* nothing past this point */
