# ==============================================================================
# File            : Makedocs.mk
# Description     : 
#
#   GNU makefile to generate NMU documentation from sources using Doxygen
#
# ==============================================================================

# The target for generating documents using doxygen is gendocs

RELEASE_DOC=./docs/doxygen/release.chm

releasenotes : $(RELEASE_DOC)

$(RELEASE_DOC): ./docs/doxygen/release.h
	-@echo generating Release Notes ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen ../swtools/docs/doxygen/releaseDoxyfile
	@xs -f ../swtools/release.js
	
PKTUTL_DOC=./docs/doxygen/PKTUTL.chm

release : $(PKTUTL_DOC)

gendocs $(PKTUTL_DOC): pkt.h crclib.h ./docs/doxygen/doxygen.h
	-@echo generating PKTUTL documentation ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen ./docs/doxygen/Doxyfile

# End of Makedocs.mk
