/* ========================================================================== */
/**
 *  @file   cga.h
 *
 *  path    /dsps_gtmas/ti/mas/pktutl/cga.h
 *
 *  @brief  Code Generation Assistance header file.
 *
 *  ============================================================================
 * Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#ifndef _CGA_H
#define _CGA_H

/** @defgroup  CGA 
 * This module contains macros for assisting code generation. 
 * The macros helps in writing portable code that can be used across the platform.
 * 
 */

/** @ingroup CGA */
/* @{ */

#ifdef ti_targets_C54
#define _CGAPORT_C54 1
#else
#define _CGAPORT_C54 0
#endif

#ifdef ti_targets_C54_far
#define _CGAPORT_C54f 1
#else
#define _CGAPORT_C54f 0
#endif

#ifdef ti_targets_C55 
#define _CGAPORT_C55 1
#else
#define _CGAPORT_C55 0
#endif

#ifdef ti_targets_C55_large
#define _CGAPORT_C55L 1
#else
#define _CGAPORT_C55L 0
#endif

#ifdef ti_targets_C64
#define _CGAPORT_C64 1
#else
#define _CGAPORT_C64 0
#endif

#ifdef ti_targets_C64_big_endian
#define _CGAPORT_C64_BIG_ENDIAN 1
#else
#define _CGAPORT_C64_BIG_ENDIAN 0
#endif

#if defined(ti_targets_C674) || defined(ti_targets_elf_C674)
#define _CGAPORT_C674 1
#else
#define _CGAPORT_C674 0
#endif

#if defined(ti_targets_C674_big_endian) || defined(ti_targets_elf_C674_big_endian)
#define _CGAPORT_C674_BIG_ENDIAN 1
#else
#define _CGAPORT_C674_BIG_ENDIAN 0
#endif


#if defined(ti_targets_C64P) || defined(ti_targets_elf_C64P)
#define _CGAPORT_C64P 1
#else
#define _CGAPORT_C64P 0
#endif

#if defined(ti_targets_C64P_big_endian) || defined(ti_targets_elf_C64P_big_endian)
#define _CGAPORT_C64P_BIG_ENDIAN 1
#else
#define _CGAPORT_C64P_BIG_ENDIAN 0
#endif

#if defined(ti_targets_C66) || defined(ti_targets_elf_C66)
#define _CGAPORT_C66 1
#else
#define _CGAPORT_C66 0
#endif

#if defined(ti_targets_C66_big_endian) || defined(ti_targets_elf_C66_big_endian)
#define _CGAPORT_C66_BIG_ENDIAN 1
#else
#define _CGAPORT_C66_BIG_ENDIAN 0
#endif

#ifdef gnu_targets_MVArm9
#define _CGAPORT_MVARM9 1
#else
#define _CGAPORT_MVARM9 0
#endif

#ifdef gnu_targets_arm_GCArmv6
#define _CGAPORT_ARM_GCARMV6 1
#else
#define _CGAPORT_ARM_GCARMV6 0
#endif

#ifdef gnu_targets_arm_GCArmv7A
#define _CGAPORT_ARM_GCARMV7A 1
#else
#define _CGAPORT_ARM_GCARMV7A 0
#endif


#ifdef ti_targets_arm_Arm11
#define _CGAPORT_ARM_ARM11 1
#else
#define _CGAPORT_ARM_ARM11 0
#endif

#ifdef ti_targets_arm_Arm11_big_endian
#define _CGAPORT_ARM_ARM11_BIG_ENDIAN 1
#else
#define _CGAPORT_ARM_ARM11_BIG_ENDIAN 0
#endif


#ifdef microsoft_targets_arm_WinCE
#define _CGAPORT_WINCE 1
#else
#define _CGAPORT_WINCE 0
#endif

#ifdef microsoft_targets_VC98
#define _CGAPORT_VC98 1
#else
#define _CGAPORT_VC98 0
#endif

#if _CGAPORT_C54 || _CGAPORT_C54f
#include <ti/mas/pktutl/src/c54/cga.h>
#elif _CGAPORT_C55 || _CGAPORT_C55L
#include <ti/mas/pktutl/src/c55/cga.h>
#elif _CGAPORT_C64 || _CGAPORT_C64_BIG_ENDIAN || _CGAPORT_C674 || _CGAPORT_C674_BIG_ENDIAN || _CGAPORT_C64P || _CGAPORT_C64P_BIG_ENDIAN || _CGAPORT_C66 || _CGAPORT_C66_BIG_ENDIAN 
#include <ti/mas/pktutl/src/c64/cga.h>
#elif _CGAPORT_MVARM9 || _CGAPORT_ARM_GCARMV6 || _CGAPORT_ARM_GCARMV7A || _CGAPORT_ARM_ARM11 || _CGAPORT_ARM_ARM11_BIG_ENDIAN
#include <ti/mas/pktutl/src/arm/cga.h>
#elif _CGAPORT_WINCE
#include <ti/mas/pktutl/src/arm/cga.h>
#elif _CGAPORT_VC98
#include <ti/mas/pktutl/src/arm/cga.h>
#else
#error invalid target
#endif
/* @} */
#endif /* _CGAPORT_H */

/* Nothing past this point */



