/*
 * This is a little header file which doxygen parses to generate the main
 * documentation page
 */

/**
 * @mainpage PKTUTL USER MANUAL
 *
 * @section description Description
 *
 * Contains packet utility modules shared across the components.
 *
 * @section modules Modules
 *  - @ref PKT
 *  - @ref CRCLIB
 *  - @ref CGA
 *
 *
 * @section integration Integration Support
 *
 *  The complete instructions for integrating pktutl package is described <a href="integration.html">here </a>.
 *
 *
 * @section dependencies Dependent Packages
 *  - ti.mas.types (Common data type defintions)
 *  - ti.mas.swtools (Internally used s/w tools)
 */
/**
 * @page Integration Integration Support
 *
 *  @section rtsc Integration in RTSC Enviornment
 *
 *  - Add the PKTUTL package in the dependent list in @b package.xdc file. <BR>
 *    <CODE> requires ti.mas.pktutl[2,0,0,1]; </CODE>
 *
 *  - Header files with the required functions should be added to the integration C file :
 *    <CODE>
      @verbatim
      #include <ti/mas/pktutl/pkt.h>
      #include <ti/mas/pktutl/crclib.h>
      #include <ti/mas/pktutl/cga.h>
      @endverbatim
      </CODE>
     <BR>
 *
 *   - The following libraries are required to be linked:
     - @verbatim ti\mas\pktutl\c<target>\pktutl_a.a<target> @endverbatim
     - @verbatim ti\mas\pktutl\c<target>\pktutl_c.a<target> @endverbatim 
     <BR>
     Note: <target> is one of 54, 55, 55L (c55x large model), 64le (c64x little endian), 64be (c64x big endian), 64Ple (c64x+ little endian), or 64Pbe (c64x+ big endian), e66le (c66x little endian), e66be (c66x big endian).
 *
 *  @section nonrtsc Integration in Non-RTSC Enviornment
 *
 *  - The XDC tools needs to be installed even for linking the RTSC library in the legacy builds.<BR> 
 *    The XDC tools could be downloaded from:<BR> 
 *     https://www-a.ti.com/downloads/sds_support/targetcontent/rtsc/index.html
 *     <BR>
 *     Note: My.TI account is required to download the same.
 * 
 *  - The PKTUTL Package integration requires the following packages:
 *    - ti.mas.types
 *
 *  - The packages can be obtained by unzipping the respective ZIP files.
 *    The package directory is in: ti\mas\<package>. <BR>
 *    Note: The directory structure and its contents have to be maintained.
 *
 *  - Header files with the required functions should be added to the integration C file :
 *    <CODE>
      @verbatim
      #include <ti/mas/pktutl/pkt.h>
      #include <ti/mas/pktutl/crclib.h>
      #include <ti/mas/pktutl/cga.h>
      @endverbatim
      </CODE>
     <BR>
      Note: The parent directory where the RTSC packages were unzipped should be there in the include list.

   - When compiling the source files which include the header files from the packages, the following compiler options need to be included:
     - -Dti_targets_<target>
     - -Dxdc_target_name__=<target>
     - -Dxdc_target_types__=ti/targets/std.h
     - -Dxdc__nolocalnames 
     <BR>
     Note: <target> is one of C54, C55, C55_large, C64 (c64x little endian), C64_big_endian, C64P (c64x+ little endian), or C64P_big_endian, C66 (c66x little endian), C66_big_endian.

   - The XDC tools path needs to be in the include list for linking standard XDC header files:<BR>
     -i $(TOOLSXDC)/packages <BR>     
     TOOLSXDC is the path to XDC tools
     
   - The following libraries are required to be linked:
     - @verbatim ti\mas\pktutl\c<target>\pktutl_a.a<target> @endverbatim
     - @verbatim ti\mas\pktutl\c<target>\pktutl_c.a<target> @endverbatim 
     <BR>
     Note: <target> is one of 54, 55, 55L (c55x large model), 64 (c64x little endian), 64e (c64x big endian), 64P (c64x+ little endian), or 64Pe (c64x+ big endian), e66 (c66x little endian), e66e (c64x big endian).

*/


/**
 * @page Revision History
 * <center> <B> Revision History </B> </center>
 *
 * <TABLE align=center>
 * <TR>
 * <TD><B>Version</B></TD>
 * <TD><B>Comments</B></TD>
 * </TR>
 * <TR>
 * <TD>2.1.1.0</TD>
 * <TD>Includes CGA support </TD>
 * </TR>
 * <TR>
 * <TD>2.0.0.1</TD>
 * <TD>Includes support for ELF libraries for C66 target </TD>
 * </TR>
 * </TABLE>
 */

/**
 * @page Disclaimer
 *<center> <B>IMPORTANT NOTICE </B> </center>
 * Texas Instruments Incorporated and its subsidiaries (TI) reserve the right
 * to make corrections, modifications, enhancements, improvements, and other
 * changes to its products and services at any time and to discontinue any
 * product or service without notice. Customers should obtain the latest
 * relevant information before placing orders and should verify that such
 * information is current and complete. All products are sold subject to TIs
 * terms and conditions of sale supplied at the time of order acknowledgment.
 *
 * TI warrants performance of its hardware products to the specifications
 * applicable at the time of sale in accordance with TIs standard warranty.
 * Testing and other quality control techniques are used to the extent TI
 * deems necessary to support this warranty. Except where mandated by
 * government requirements, testing of all parameters of each product is not
 * necessarily performed.
 *
 * TI assumes no liability for applications assistance or customer product
 * design. Customers are responsible for their products and applications
 * using TI components. To minimize the risks associated with customer
 * products and applications, customers should provide adequate design and
 * operating safeguards.
 *
 * TI does not warrant or represent that any license, either express or
 * implied, is granted under any TI patent right, copyright, mask work right,
 * or other TI intellectual property right relating to any combination,
 * machine, or process in which TI products or services are used. Information
 * published by TI regarding third-party products or services does not
 * constitute a license from TI to use such products or services or a warranty
 * or endorsement thereof. Use of such information may require a license from a
 * third party under the patents or other intellectual property of the third
 * party, or a license from TI under the patents or other intellectual property
 * of TI.
 *
 * Reproduction of information in TI data books or data sheets is permissible
 * only if reproduction is without alteration and is accompanied by all
 * associated warranties, conditions, limitations, and notices. Reproduction
 * of this information with alteration is an unfair and deceptive business
 * practice. TI is not responsible or liable for such altered documentation.
 *
 * Resale of TI products or services with statements different from or beyond
 * the parameters stated by TI for that product or service voids all express
 * and any implied warranties for the associated TI product or service and is
 * an unfair and deceptive business practice. TI is not responsible or liable
 * for any such statements.
 *
 *
 *
 *
 * Mailing Address: <BR>
 * Texas Instruments <BR>
 * Post Office Box 655303 <BR>
 * Dallas, Texas 75265 <BR>
 *
 *
 *
 * Copyright  2006 Texas Instruments Incorporated.
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 * Information in this document is subject to change without notice.
 * Texas Instruments may have pending patent applications, trademarks,
 * copyrights, or other intellectual property rights covering matter in this
 * document.  The furnishing of this document is given for usage with Texas
 * Instruments products only and does not give you any license to the
 * intellectual property that might be contained within this document.
 * Texas Instruments makes no implied or expressed warranties in this document
 * and is not responsible for the products based from this document.
 *
 *
*/
